/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.ViewGroup;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.UiLayer;
import com.google.vr.ndk.base.DaydreamUtilsWrapper;
import com.google.vr.vrcore.library.api.IGvrUiLayout;
import com.google.vr.vrcore.library.api.IObjectWrapper;
import com.google.vr.vrcore.library.api.ObjectWrapper;

class GvrUiLayoutImpl
extends IGvrUiLayout.Stub {
    private static final float DAYDREAM_ALIGNMENT_MARKER_SCALE = 0.35f;
    private final UiLayer uiLayer;
    private final Runnable defaultCloseButtonListener;
    private boolean daydreamModeEnabled = false;

    GvrUiLayoutImpl(Context context) {
        this(context, new DaydreamUtilsWrapper());
    }

    GvrUiLayoutImpl(Context context, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        this.defaultCloseButtonListener = GvrUiLayoutImpl.createDefaultCloseButtonListener(context, daydreamUtilsWrapper);
        this.uiLayer = new UiLayer(context);
        this.uiLayer.setBackButtonListener(this.defaultCloseButtonListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.uiLayer.setEnabled(bl);
    }

    @Override
    public IObjectWrapper getRootView() {
        return ObjectWrapper.wrap(this.uiLayer.getView());
    }

    @Override
    public boolean isEnabled() {
        return this.uiLayer.isEnabled();
    }

    @Override
    public void setCloseButtonListener(IObjectWrapper iObjectWrapper) {
        this.uiLayer.setBackButtonListener(iObjectWrapper != null ? ObjectWrapper.unwrap(iObjectWrapper, Runnable.class) : this.defaultCloseButtonListener);
    }

    @Override
    public void setTransitionViewEnabled(boolean bl) {
        this.uiLayer.setTransitionViewEnabled(bl && !this.daydreamModeEnabled);
    }

    @Override
    public void setTransitionViewListener(IObjectWrapper iObjectWrapper) {
        this.uiLayer.setTransitionViewListener(iObjectWrapper != null ? ObjectWrapper.unwrap(iObjectWrapper, Runnable.class) : null);
    }

    @Override
    public void setSettingsButtonEnabled(boolean bl) {
        this.uiLayer.setSettingsButtonEnabled(bl);
    }

    @Override
    public void setSettingsButtonListener(IObjectWrapper iObjectWrapper) {
        this.uiLayer.setSettingsButtonListener(iObjectWrapper != null ? ObjectWrapper.unwrap(iObjectWrapper, Runnable.class) : null);
    }

    @Override
    public void setViewerName(String string2) {
        this.uiLayer.setViewerName(string2);
    }

    UiLayer getUiLayer() {
        return this.uiLayer;
    }

    ViewGroup getRoot() {
        return this.uiLayer.getView();
    }

    void invokeCloseButtonListener() {
        Runnable runnable = this.uiLayer.getBackButtonListener();
        if (runnable != null) {
            runnable.run();
        }
    }

    void setDaydreamModeEnabled(boolean bl) {
        if (this.daydreamModeEnabled == bl) {
            return;
        }
        this.daydreamModeEnabled = bl;
        if (bl) {
            this.uiLayer.setAlignmentMarkerScale(0.35f);
            this.uiLayer.setTransitionViewEnabled(false);
            return;
        }
        this.uiLayer.setAlignmentMarkerScale(1.0f);
    }

    boolean isDaydreamModeEnabled() {
        return this.daydreamModeEnabled;
    }

    private static Runnable createDefaultCloseButtonListener(Context context, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        final Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            return null;
        }
        if (daydreamUtilsWrapper.isDaydreamActivity(activity)) {
            return new Runnable(){

                @Override
                public final void run() {
                    Intent intent = new Intent("android.intent.action.MAIN");
                    intent.addCategory("android.intent.category.HOME");
                    intent.setFlags(0x10000000);
                    activity.startActivity(intent);
                    activity.finish();
                }
            };
        }
        return new Runnable(){

            @Override
            public final void run() {
                activity.onBackPressed();
            }
        };
    }
}

