/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.View;
import android.widget.FrameLayout;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.VrContextWrapper;
import com.google.vr.cardboard.annotations.UsedByReflection;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayoutImpl;
import com.google.vr.ndk.base.GvrLayoutImplWrapper;
import com.google.vr.ndk.base.GvrUiLayout;
import com.google.vr.ndk.base.TraceCompat;
import com.google.vr.vrcore.library.api.IGvrLayout;
import com.google.vr.vrcore.library.api.ObjectWrapper;

@UsedByReflection(value="Unity")
public class GvrLayout
extends FrameLayout {
    private static final String TAG = "GvrLayout";
    private IGvrLayout impl;
    private GvrUiLayout uiLayout;
    private GvrApi gvrApi;

    public GvrLayout(Context context) {
        super(context);
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            throw new IllegalArgumentException("An Activity Context is required for VR functionality.");
        }
        this.init();
    }

    public GvrLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            throw new IllegalArgumentException("An Activity Context is required for VR functionality.");
        }
        this.init();
    }

    public GvrLayout(VrContextWrapper vrContextWrapper) {
        super((Context)vrContextWrapper);
        this.init();
    }

    GvrLayout(Context context, GvrLayoutImpl gvrLayoutImpl) {
        super(context);
        this.impl = new GvrLayoutImplWrapper(gvrLayoutImpl);
        this.init();
    }

    private void init() {
        TraceCompat.beginSection("GvrLayout.init");
        try {
            if (this.impl == null) {
                this.impl = new GvrLayoutImplWrapper(new GvrLayoutImpl(this.getContext()));
            }
            this.uiLayout = new GvrUiLayout(this.impl.getUiLayout());
            this.gvrApi = new GvrApi(this.getContext(), this.impl.getNativeGvrContext());
            this.addView(ObjectWrapper.unwrap(this.impl.getRootView(), View.class));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        finally {
            TraceCompat.endSection();
        }
    }

    @UsedByReflection(value="Unity")
    public GvrUiLayout getUiLayout() {
        return this.uiLayout;
    }

    @UsedByReflection(value="Unity")
    public void onPause() {
        TraceCompat.beginSection("GvrLayout.onPause");
        try {
            this.impl.onPause();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        finally {
            TraceCompat.endSection();
        }
    }

    @UsedByReflection(value="Unity")
    public void onResume() {
        TraceCompat.beginSection("GvrLayout.onResume");
        try {
            this.impl.onResume();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        finally {
            TraceCompat.endSection();
        }
    }

    @UsedByReflection(value="Unity")
    public void shutdown() {
        TraceCompat.beginSection("GvrLayout.shutdown");
        try {
            this.impl.shutdown();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        finally {
            TraceCompat.endSection();
        }
    }

    @UsedByReflection(value="Unity")
    public void setPresentationView(View view) {
        try {
            this.impl.setPresentationView(ObjectWrapper.wrap(view));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setFixedPresentationSurfaceSize(int n, int n2) {
        this.getGvrApi().setSurfaceSize(n, n2);
    }

    public boolean enableAsyncReprojectionVideoSurface(ExternalSurfaceListener externalSurfaceListener, Handler handler, boolean bl) {
        return ((GvrLayoutImplWrapper)this.impl).getWrappedImpl().enableAsyncReprojectionVideoSurface(externalSurfaceListener, handler, bl);
    }

    @UsedByReflection(value="Unity")
    public boolean setAsyncReprojectionEnabled(boolean bl) {
        try {
            return this.impl.setAsyncReprojectionEnabled(bl);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public boolean enableCardboardTriggerEmulation(Runnable runnable) {
        try {
            return this.impl.enableCardboardTriggerEmulation(ObjectWrapper.wrap(runnable));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public int getAsyncReprojectionVideoSurfaceId() {
        return ((GvrLayoutImplWrapper)this.impl).getWrappedImpl().getAsyncReprojectionVideoSurfaceId();
    }

    public Surface getAsyncReprojectionVideoSurface() {
        return ((GvrLayoutImplWrapper)this.impl).getWrappedImpl().getAsyncReprojectionVideoSurface();
    }

    @UsedByReflection(value="Unity")
    public GvrApi getGvrApi() {
        return this.gvrApi;
    }

    public void setStereoModeEnabled(boolean bl) {
        try {
            this.impl.setStereoModeEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public static interface ExternalSurfaceListener {
        public void onSurfaceAvailable(Surface var1);

        public void onFrameAvailable();
    }
}

