/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.util.Log;
import android.view.Surface;
import com.google.vr.ndk.base.GvrApi;

public class ExternalSurface {
    private static final String TAG = ExternalSurface.class.getSimpleName();
    private long nativeExternalSurface;

    ExternalSurface(long l) {
        this.nativeExternalSurface = l;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeExternalSurface != 0L) {
                Log.w((String)TAG, (String)"ExternalSurface.shutdown() should be called to ensure resource cleanup");
                this.shutdown();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public Surface getSurface() {
        return GvrApi.nativeExternalSurfaceGetSurface(this.nativeExternalSurface);
    }

    public void shutdown() {
        if (this.nativeExternalSurface != 0L) {
            GvrApi.nativeExternalSurfaceDestroy(this.nativeExternalSurface);
            this.nativeExternalSurface = 0L;
        }
    }

    int getId() {
        return GvrApi.nativeExternalSurfaceGetId(this.nativeExternalSurface);
    }
}

