/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.google.vr.cardboard.UsedByNative;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@UsedByNative
public class ExternalSurfaceManager {
    private static final String TAG = ExternalSurfaceManager.class.getSimpleName();
    private final GvrApi gvrApi;
    private volatile ExternalSurfaceData surfaceData = new ExternalSurfaceData();
    private final Object surfaceDataUpdateLock = new Object();
    private int nextID = 1;

    @UsedByNative
    public ExternalSurfaceManager(GvrApi gvrApi) {
        this.gvrApi = gvrApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByNative
    public void shutdown() {
        Object object = this.surfaceDataUpdateLock;
        synchronized (object) {
            ExternalSurfaceData externalSurfaceData = this.surfaceData;
            this.surfaceData = new ExternalSurfaceData();
            for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
                externalSurface.shutdown(this.gvrApi);
            }
            for (ExternalSurface externalSurface : externalSurfaceData.surfacesToRelease.values()) {
                externalSurface.shutdown(this.gvrApi);
            }
            return;
        }
    }

    public int createExternalSurface(GvrLayout.ExternalSurfaceListener externalSurfaceListener, Handler handler) {
        if (externalSurfaceListener == null || handler == null) {
            throw new IllegalArgumentException("listener and handler must both be both non-null");
        }
        return this.createExternalSurfaceImpl(externalSurfaceListener, handler);
    }

    @UsedByNative
    public int createExternalSurface() {
        return this.createExternalSurfaceImpl(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createExternalSurfaceImpl(GvrLayout.ExternalSurfaceListener externalSurfaceListener, Handler handler) {
        Object object = this.surfaceDataUpdateLock;
        synchronized (object) {
            ExternalSurfaceData externalSurfaceData = new ExternalSurfaceData(this.surfaceData);
            int n = this.nextID++;
            ExternalSurfaceCallback externalSurfaceCallback = null;
            if (externalSurfaceListener != null && handler != null) {
                externalSurfaceCallback = new ExternalSurfaceCallback(externalSurfaceListener, handler);
            }
            externalSurfaceData.surfaces.put(n, new ExternalSurface(n, externalSurfaceCallback));
            this.surfaceData = externalSurfaceData;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByNative
    public void releaseExternalSurface(int n) {
        Object object = this.surfaceDataUpdateLock;
        synchronized (object) {
            ExternalSurfaceData externalSurfaceData = new ExternalSurfaceData(this.surfaceData);
            ExternalSurface externalSurface = externalSurfaceData.surfaces.remove(n);
            if (externalSurface != null) {
                externalSurfaceData.surfacesToRelease.put(n, externalSurface);
                this.surfaceData = externalSurfaceData;
            } else {
                Log.e((String)TAG, (String)new StringBuilder(48).append("Not releasing nonexistent surface ID ").append(n).toString());
            }
            return;
        }
    }

    public int getSurfaceCount() {
        return this.surfaceData.surfaces.size();
    }

    @UsedByNative
    public Surface getSurface(int n) {
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        if (externalSurfaceData.surfaces.containsKey(n)) {
            return externalSurfaceData.surfaces.get(n).getSurface();
        }
        Log.e((String)TAG, (String)new StringBuilder(58).append("Surface with ID ").append(n).append(" does not exist, returning null").toString());
        return null;
    }

    @UsedByNative
    public void consumerAttachToCurrentGLContext() {
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
            externalSurface.maybeAttachToCurrentGLContext();
        }
    }

    @UsedByNative
    public void consumerDetachFromCurrentGLContext() {
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
            externalSurface.maybeDetachFromCurrentGLContext();
        }
        this.gvrApi.removeAllSurfacesReprojectionThread();
    }

    @UsedByNative
    public void consumerUpdateManagedSurfaces() {
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
            externalSurface.updateSurfaceTexture(this.gvrApi);
        }
        for (ExternalSurface externalSurface : externalSurfaceData.surfacesToRelease.values()) {
            externalSurface.shutdown(this.gvrApi);
        }
    }

    private static class ExternalSurface {
        private final int id;
        private final ExternalSurfaceCallback callback;
        private final float[] transformMatrix = new float[16];
        private final AtomicBoolean hasNewFrame = new AtomicBoolean(false);
        private final AtomicBoolean released = new AtomicBoolean(false);
        private final int[] glTextureId = new int[1];
        private volatile SurfaceTexture surfaceTexture;
        private volatile Surface surface;
        private boolean isAttached = false;

        ExternalSurface(int n, ExternalSurfaceCallback externalSurfaceCallback) {
            this.id = n;
            this.callback = externalSurfaceCallback;
            Matrix.setIdentityM((float[])this.transformMatrix, (int)0);
        }

        void maybeAttachToCurrentGLContext() {
            if (this.isAttached) {
                return;
            }
            GLES20.glGenTextures((int)1, (int[])this.glTextureId, (int)0);
            if (this.surfaceTexture == null) {
                this.surfaceTexture = new SurfaceTexture(this.glTextureId[0]);
                this.surfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                        ExternalSurface.this.hasNewFrame.set(true);
                        if (ExternalSurface.this.callback != null) {
                            ExternalSurface.this.callback.postOnFrameAvailable();
                        }
                    }
                });
                this.surface = new Surface(this.surfaceTexture);
            } else {
                this.surfaceTexture.attachToGLContext(this.glTextureId[0]);
            }
            this.isAttached = true;
            if (this.callback != null) {
                this.callback.postOnAvailable(this.surface);
            }
        }

        void maybeDetachFromCurrentGLContext() {
            if (!this.isAttached) {
                return;
            }
            this.surfaceTexture.detachFromGLContext();
            this.isAttached = false;
        }

        void updateSurfaceTexture(GvrApi gvrApi) {
            if (!this.isAttached) {
                return;
            }
            boolean bl = this.hasNewFrame.getAndSet(false);
            if (bl) {
                this.surfaceTexture.updateTexImage();
                this.surfaceTexture.getTransformMatrix(this.transformMatrix);
                long l = this.surfaceTexture.getTimestamp();
                gvrApi.updateSurfaceReprojectionThread(this.id, this.glTextureId[0], l, this.transformMatrix);
            }
        }

        Surface getSurface() {
            return this.surface;
        }

        void shutdown(GvrApi gvrApi) {
            if (this.released.getAndSet(true)) {
                return;
            }
            if (this.surfaceTexture != null) {
                this.surfaceTexture.release();
                this.surfaceTexture = null;
                this.surface = null;
            }
            gvrApi.updateSurfaceReprojectionThread(this.id, 0, 0L, this.transformMatrix);
        }
    }

    private static class ExternalSurfaceCallback {
        private final GvrLayout.ExternalSurfaceListener listener;
        private final Handler handler;
        private final Runnable frameAvailableRunnable;

        public ExternalSurfaceCallback(GvrLayout.ExternalSurfaceListener externalSurfaceListener, Handler handler) {
            this.listener = externalSurfaceListener;
            this.handler = handler;
            this.frameAvailableRunnable = new Runnable(){

                @Override
                public void run() {
                    ExternalSurfaceCallback.this.listener.onFrameAvailable();
                }
            };
        }

        public void postOnAvailable(final Surface surface) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ExternalSurfaceCallback.this.listener.onSurfaceAvailable(surface);
                }
            });
        }

        public void postOnFrameAvailable() {
            this.handler.post(this.frameAvailableRunnable);
        }
    }

    private static class ExternalSurfaceData {
        final HashMap<Integer, ExternalSurface> surfaces;
        final HashMap<Integer, ExternalSurface> surfacesToRelease;

        ExternalSurfaceData() {
            this.surfaces = new HashMap();
            this.surfacesToRelease = new HashMap();
        }

        ExternalSurfaceData(ExternalSurfaceData externalSurfaceData) {
            this.surfaces = new HashMap<Integer, ExternalSurface>(externalSurfaceData.surfaces);
            this.surfacesToRelease = new HashMap<Integer, ExternalSurface>(externalSurfaceData.surfacesToRelease);
            Iterator<Map.Entry<Integer, ExternalSurface>> iterator = this.surfacesToRelease.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, ExternalSurface> entry = iterator.next();
                if (!entry.getValue().released.get()) continue;
                iterator.remove();
            }
        }
    }
}

