/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.vr.vrcore.controller.api.ControllerBatteryEvent;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerPositionEvent;
import java.util.ArrayDeque;

public final class ControllerEventPacket2
extends ControllerEventPacket {
    private static ArrayDeque<ControllerEventPacket2> pool = new ArrayDeque();
    private static Object poolLock = new Object();
    private int positionEventCount;
    private ControllerPositionEvent[] positionEvents = new ControllerPositionEvent[16];
    private boolean hasBatteryEvent;
    private ControllerBatteryEvent batteryEvent = new ControllerBatteryEvent();
    private long timestampMillis;
    public static final Parcelable.Creator<ControllerEventPacket2> CREATOR = new Parcelable.Creator<ControllerEventPacket2>(){

        public final ControllerEventPacket2 createFromParcel(Parcel parcel) {
            ControllerEventPacket2 controllerEventPacket2 = ControllerEventPacket2.obtain();
            controllerEventPacket2.readFromParcel(parcel);
            return controllerEventPacket2;
        }

        public final ControllerEventPacket2[] newArray(int n) {
            return new ControllerEventPacket2[n];
        }
    };

    public ControllerEventPacket2() {
        for (int i = 0; i < 16; ++i) {
            this.positionEvents[i] = new ControllerPositionEvent();
        }
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        this.positionEventCount = 0;
        this.hasBatteryEvent = false;
        this.timestampMillis = 0L;
    }

    public final void refreshTimestampMillis() {
        this.timestampMillis = SystemClock.elapsedRealtime();
    }

    public final long getTimestampMillis() {
        return this.timestampMillis;
    }

    public final int getPositionEventCount() {
        return this.positionEventCount;
    }

    public final boolean hasBatteryEvent() {
        return this.hasBatteryEvent;
    }

    public final ControllerPositionEvent getPositionEvent(int n) {
        if (n < 0 || n >= this.positionEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.positionEvents[n];
    }

    public final ControllerPositionEvent addPositionEvent() {
        if (this.positionEventCount >= 16) {
            throw new IllegalStateException("ControllerEventPacket capacity exceeded.");
        }
        return this.positionEvents[this.positionEventCount++];
    }

    public final ControllerBatteryEvent getBatteryEvent() {
        if (!this.hasBatteryEvent) {
            throw new IllegalStateException("ControllerEventPacket doesn't have a battery event.");
        }
        return this.batteryEvent;
    }

    public final ControllerBatteryEvent addBatteryEvent() {
        if (this.hasBatteryEvent) {
            throw new IllegalStateException("ControllerEventPacket already has battery event.");
        }
        this.hasBatteryEvent = true;
        return this.batteryEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerEventPacket2 obtain() {
        Object object = poolLock;
        synchronized (object) {
            return pool.isEmpty() ? new ControllerEventPacket2() : pool.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recycle() {
        this.clear();
        Object object = poolLock;
        synchronized (object) {
            if (!pool.contains(this)) {
                pool.add(this);
            }
            return;
        }
    }

    @Override
    public final int describeContents() {
        return 0;
    }

    @Override
    protected final int calculateParcelByteLength() {
        int n = super.calculateParcelByteLength();
        n += 4;
        n += 4;
        for (int i = 0; i < this.positionEventCount; ++i) {
            n += this.positionEvents[i].getByteSize();
        }
        n += 4;
        if (this.hasBatteryEvent) {
            n += this.batteryEvent.getByteSize();
        }
        return n += 8;
    }

    @Override
    public final void writeToParcel(Parcel parcel, int n) {
        int n2 = parcel.dataPosition();
        int n3 = this.calculateParcelByteLength();
        parcel.writeInt(n3);
        super.writeToParcel(parcel, n);
        parcel.writeInt(this.positionEventCount);
        for (int i = 0; i < this.positionEventCount; ++i) {
            this.positionEvents[i].writeToParcel(parcel, n);
        }
        parcel.writeInt(this.hasBatteryEvent ? 1 : 0);
        if (this.hasBatteryEvent) {
            this.batteryEvent.writeToParcel(parcel, n);
        }
        parcel.writeLong(this.timestampMillis);
        if (parcel.dataPosition() - n2 != n3) {
            throw new IllegalStateException("Parcelable implemented incorrectly, getByteSize() must return the correct size for each ControllerEvent subclass.");
        }
    }

    @Override
    public final void readFromParcel(Parcel parcel) {
        int n = parcel.dataPosition();
        int n2 = parcel.readInt();
        int n3 = n + n2;
        super.readFromParcel(parcel);
        if (parcel.dataPosition() < n3) {
            this.positionEventCount = parcel.readInt();
            this.checkIsValidEventCount(this.positionEventCount);
            for (int i = 0; i < this.positionEventCount; ++i) {
                this.positionEvents[i].readFromParcel(parcel);
            }
        }
        if (parcel.dataPosition() < n3) {
            boolean bl = this.hasBatteryEvent = 0 != parcel.readInt();
            if (this.hasBatteryEvent) {
                this.batteryEvent.readFromParcel(parcel);
            }
        }
        if (parcel.dataPosition() < n3) {
            this.timestampMillis = parcel.readLong();
        }
        parcel.setDataPosition(n3);
    }
}

