/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.graphics.RectF;
import android.util.Log;
import com.google.vr.ndk.base.ExternalSurface;
import com.google.vr.ndk.base.GvrApi;

public class BufferViewport {
    private static final String TAG = BufferViewport.class.getSimpleName();
    long nativeBufferViewport;
    public static final int EXTERNAL_SURFACE_ID_NONE = -1;
    public static final int BUFFER_INDEX_EXTERNAL_SURFACE = -1;

    BufferViewport(long l) {
        this.nativeBufferViewport = l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BufferViewport)) {
            return false;
        }
        BufferViewport bufferViewport = (BufferViewport)object;
        return GvrApi.nativeBufferViewportEqual(this.nativeBufferViewport, bufferViewport.nativeBufferViewport);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeBufferViewport != 0L) {
                Log.w((String)TAG, (String)"BufferViewport.shutdown() should be called to ensure resource cleanup");
                this.shutdown();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void shutdown() {
        if (this.nativeBufferViewport != 0L) {
            GvrApi.nativeBufferViewportDestroy(this.nativeBufferViewport);
            this.nativeBufferViewport = 0L;
        }
    }

    public void getSourceUv(RectF rectF) {
        GvrApi.nativeBufferViewportGetSourceUv(this.nativeBufferViewport, rectF);
    }

    public void setSourceUv(RectF rectF) {
        GvrApi.nativeBufferViewportSetSourceUv(this.nativeBufferViewport, rectF.left, rectF.top, rectF.right, rectF.bottom);
    }

    public void getSourceFov(RectF rectF) {
        GvrApi.nativeBufferViewportGetSourceFov(this.nativeBufferViewport, rectF);
    }

    public void setSourceFov(RectF rectF) {
        GvrApi.nativeBufferViewportSetSourceFov(this.nativeBufferViewport, rectF.left, rectF.top, rectF.right, rectF.bottom);
    }

    public void getTransform(float[] fArray) {
        GvrApi.nativeBufferViewportGetTransform(this.nativeBufferViewport, fArray);
    }

    public void setTransform(float[] fArray) {
        GvrApi.nativeBufferViewportSetTransform(this.nativeBufferViewport, fArray);
    }

    public int getTargetEye() {
        return GvrApi.nativeBufferViewportGetTargetEye(this.nativeBufferViewport);
    }

    public void setTargetEye(int n) {
        GvrApi.nativeBufferViewportSetTargetEye(this.nativeBufferViewport, n);
    }

    public int getSourceBufferIndex() {
        return GvrApi.nativeBufferViewportGetSourceBufferIndex(this.nativeBufferViewport);
    }

    public void setSourceBufferIndex(int n) {
        GvrApi.nativeBufferViewportSetSourceBufferIndex(this.nativeBufferViewport, n);
    }

    public int getExternalSurfaceId() {
        return GvrApi.nativeBufferViewportGetExternalSurfaceId(this.nativeBufferViewport);
    }

    public void setExternalSurfaceId(int n) {
        GvrApi.nativeBufferViewportSetExternalSurfaceId(this.nativeBufferViewport, n);
    }

    public void setExternalSurface(ExternalSurface externalSurface) {
        this.setExternalSurfaceId(externalSurface != null ? externalSurface.getId() : -1);
    }

    public int getReprojection() {
        return GvrApi.nativeBufferViewportGetReprojection(this.nativeBufferViewport);
    }

    public void setReprojection(int n) {
        GvrApi.nativeBufferViewportSetReprojection(this.nativeBufferViewport, n);
    }

    public static abstract class Reprojection {
        public static final int NONE = 0;
        public static final int FULL = 1;
    }

    public static abstract class EyeType {
        public static final int LEFT = 0;
        public static final int RIGHT = 1;
    }
}

