/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.view.Choreographer;
import com.google.vr.cardboard.ThreadUtils;

public class FrameMonitor
implements Choreographer.FrameCallback {
    private final Choreographer choreographer;
    private final Choreographer.FrameCallback callback;
    private boolean isPaused;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FrameMonitor(Choreographer.FrameCallback frameCallback) {
        this(Choreographer.getInstance(), frameCallback);
    }

    public FrameMonitor(Choreographer choreographer, Choreographer.FrameCallback frameCallback) {
        ThreadUtils.assertOnUiThread();
        this.callback = frameCallback;
        this.choreographer = choreographer;
        choreographer.postFrameCallback((Choreographer.FrameCallback)this);
    }

    public void onPause() {
        if (this.isPaused) {
            return;
        }
        this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
        this.isPaused = true;
    }

    public void onResume() {
        if (!this.isPaused) {
            return;
        }
        this.isPaused = false;
        this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
    }

    public void doFrame(long l) {
        this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
        this.callback.doFrame(l);
    }
}

