/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.common.api;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.vr.vrcore.common.api.HeadTrackingState;
import com.google.vr.vrcore.common.api.IDaydreamListener;
import com.google.vr.vrcore.common.api.ITransitionCallbacks;

public interface IDaydreamManager
extends IInterface {
    public boolean registerListener(ComponentName var1, IDaydreamListener var2) throws RemoteException;

    public boolean unregisterListener(ComponentName var1) throws RemoteException;

    public int prepareVr(ComponentName var1, HeadTrackingState var2) throws RemoteException;

    public boolean deprecatedLaunchInVr(PendingIntent var1) throws RemoteException;

    public void registerDaydreamIntent(PendingIntent var1) throws RemoteException;

    public void unregisterDaydreamIntent() throws RemoteException;

    public boolean launchInVr(PendingIntent var1, ComponentName var2) throws RemoteException;

    public boolean launchVrHome() throws RemoteException;

    public boolean launchVrTransition(ITransitionCallbacks var1) throws RemoteException;

    public boolean exitFromVr(PendingIntent var1) throws RemoteException;

    public void handleInsertionIntoHeadset(byte[] var1) throws RemoteException;

    public void handleRemovalFromHeadset() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDaydreamManager {
        private static final String DESCRIPTOR = "com.google.vr.vrcore.common.api.IDaydreamManager";
        static final int TRANSACTION_registerListener = 1;
        static final int TRANSACTION_unregisterListener = 2;
        static final int TRANSACTION_prepareVr = 3;
        static final int TRANSACTION_deprecatedLaunchInVr = 4;
        static final int TRANSACTION_registerDaydreamIntent = 5;
        static final int TRANSACTION_unregisterDaydreamIntent = 6;
        static final int TRANSACTION_launchInVr = 7;
        static final int TRANSACTION_launchVrHome = 8;
        static final int TRANSACTION_launchVrTransition = 9;
        static final int TRANSACTION_exitFromVr = 10;
        static final int TRANSACTION_handleInsertionIntoHeadset = 11;
        static final int TRANSACTION_handleRemovalFromHeadset = 12;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDaydreamManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IDaydreamManager) {
                return (IDaydreamManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = 0 != parcel.readInt() ? (ComponentName)ComponentName.CREATOR.createFromParcel(parcel) : null;
                    IDaydreamListener iDaydreamListener = IDaydreamListener.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.registerListener(componentName, iDaydreamListener);
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = 0 != parcel.readInt() ? (ComponentName)ComponentName.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.unregisterListener(componentName);
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = 0 != parcel.readInt() ? (ComponentName)ComponentName.CREATOR.createFromParcel(parcel) : null;
                    HeadTrackingState headTrackingState = new HeadTrackingState();
                    int n3 = this.prepareVr(componentName, headTrackingState);
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    parcel2.writeInt(1);
                    headTrackingState.writeToParcel(parcel2, 1);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PendingIntent pendingIntent = 0 != parcel.readInt() ? (PendingIntent)PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.deprecatedLaunchInVr(pendingIntent);
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PendingIntent pendingIntent = 0 != parcel.readInt() ? (PendingIntent)PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    this.registerDaydreamIntent(pendingIntent);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterDaydreamIntent();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PendingIntent pendingIntent = 0 != parcel.readInt() ? (PendingIntent)PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    ComponentName componentName = 0 != parcel.readInt() ? (ComponentName)ComponentName.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.launchInVr(pendingIntent, componentName);
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.launchVrHome();
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ITransitionCallbacks iTransitionCallbacks = ITransitionCallbacks.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.launchVrTransition(iTransitionCallbacks);
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PendingIntent pendingIntent = 0 != parcel.readInt() ? (PendingIntent)PendingIntent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.exitFromVr(pendingIntent);
                    parcel2.writeNoException();
                    parcel2.writeInt(bl ? 1 : 0);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    byte[] byArray = parcel.createByteArray();
                    this.handleInsertionIntoHeadset(byArray);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.handleRemovalFromHeadset();
                    return true;
                }
            }
            return super.onTransact(n, parcel, parcel2, n2);
        }

        private static class Proxy
        implements IDaydreamManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public boolean registerListener(ComponentName componentName, IDaydreamListener iDaydreamListener) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeStrongBinder(iDaydreamListener != null ? iDaydreamListener.asBinder() : null);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            @Override
            public boolean unregisterListener(ComponentName componentName) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            @Override
            public int prepareVr(ComponentName componentName, HeadTrackingState headTrackingState) throws RemoteException {
                int n;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    n = parcel2.readInt();
                    if (0 != parcel2.readInt()) {
                        headTrackingState.readFromParcel(parcel2);
                    }
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return n;
            }

            @Override
            public boolean deprecatedLaunchInVr(PendingIntent pendingIntent) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            @Override
            public void registerDaydreamIntent(PendingIntent pendingIntent) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void unregisterDaydreamIntent() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public boolean launchInVr(PendingIntent pendingIntent, ComponentName componentName) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            @Override
            public boolean launchVrHome() throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            @Override
            public boolean launchVrTransition(ITransitionCallbacks iTransitionCallbacks) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iTransitionCallbacks != null ? iTransitionCallbacks.asBinder() : null);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            @Override
            public boolean exitFromVr(PendingIntent pendingIntent) throws RemoteException {
                boolean bl;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (pendingIntent != null) {
                        parcel.writeInt(1);
                        pendingIntent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    bl = 0 != parcel2.readInt();
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
                return bl;
            }

            @Override
            public void handleInsertionIntoHeadset(byte[] byArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeByteArray(byArray);
                    this.mRemote.transact(11, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void handleRemovalFromHeadset() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

