/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.google.vr.cardboard.annotations.UsedByNative;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerEventPacket2;
import com.google.vr.vrcore.controller.api.ControllerInitResults;
import com.google.vr.vrcore.controller.api.ControllerListenerOptions;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerRequest;
import com.google.vr.vrcore.controller.api.ControllerServiceBridge$$Lambda$0;
import com.google.vr.vrcore.controller.api.ControllerServiceBridge$$Lambda$1;
import com.google.vr.vrcore.controller.api.ControllerServiceBridge$$Lambda$2;
import com.google.vr.vrcore.controller.api.ControllerServiceBridge$$Lambda$3;
import com.google.vr.vrcore.controller.api.IControllerListener;
import com.google.vr.vrcore.controller.api.IControllerService;
import com.google.vr.vrcore.controller.api.IControllerServiceListener;
import com.google.vr.vrcore.controller.api.nano.Proto;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;

@UsedByNative
public class ControllerServiceBridge
implements ServiceConnection {
    static final String TAG = "VrCtl.ServiceBridge";
    private static final boolean DEBUG = false;
    public static final int TARGET_SERVICE_API_VERSION = 25;
    static final int MIN_API_VERSION_FOR_SERVICE_CALLBACKS = 21;
    private static final AtomicInteger UNIQUE_INT = new AtomicInteger(-1);
    public static final int FLAG_SUPPORTS_RECENTER = 1;
    private final Context context;
    private final Handler mainThreadHandler;
    private final int vrcoreApiVersion;
    final String listenerKey;
    private final ControllerServiceListener defaultServiceListener;
    private final SparseArray<LocalControllerListener> controllerListenerMap = new SparseArray();
    private IControllerService service;
    private LocalControllerListener defaultListener;
    private boolean isBound;

    @UsedByNative
    public ControllerServiceBridge(Context context, Callbacks callbacks, int n) {
        this(context, callbacks, new ControllerListenerOptions(n));
    }

    public ControllerServiceBridge(Context context, Callbacks callbacks) {
        this(context, callbacks, null);
    }

    private ControllerServiceBridge(Context context, Callbacks callbacks, ControllerListenerOptions controllerListenerOptions) {
        this.context = context.getApplicationContext();
        this.initializeDefaultListener(callbacks, controllerListenerOptions);
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.defaultServiceListener = new ControllerServiceListener(this);
        this.vrcoreApiVersion = ControllerServiceBridge.getVrCoreApiVersion(context);
        this.listenerKey = ControllerServiceBridge.createListenerKey();
    }

    @UsedByNative
    public void requestBind() {
        this.mainThreadHandler.post((Runnable)new ControllerServiceBridge$$Lambda$0(this));
    }

    @UsedByNative
    public void requestUnbind() {
        this.mainThreadHandler.post((Runnable)new ControllerServiceBridge$$Lambda$1(this));
    }

    public void doBind() {
        this.ensureOnMainThread();
        if (this.isBound) {
            Log.w((String)TAG, (String)"Service is already bound.");
            return;
        }
        Intent intent = new Intent("com.google.vr.vrcore.controller.BIND");
        intent.setPackage("com.google.vr.vrcore");
        if (!this.context.bindService(intent, (ServiceConnection)this, 1)) {
            Log.w((String)TAG, (String)"Bind failed. Service is not available.");
            this.defaultListener.callbacks.onServiceUnavailable();
        }
        this.isBound = true;
    }

    public void doUnbind() {
        this.ensureOnMainThread();
        if (!this.isBound) {
            Log.w((String)TAG, (String)"Service is already unbound.");
            return;
        }
        this.unregisterListeners();
        if (this.vrcoreApiVersion >= 21) {
            try {
                if (this.service != null && !this.service.unregisterServiceListener(this.defaultServiceListener)) {
                    Log.w((String)TAG, (String)"Failed to unregister remote service listener.");
                }
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf((Object)remoteException);
                Log.w((String)TAG, (String)new StringBuilder(55 + String.valueOf(string2).length()).append("Exception while unregistering remote service listener: ").append(string2).toString());
            }
        }
        this.context.unbindService((ServiceConnection)this);
        this.service = null;
        this.isBound = false;
    }

    public Callbacks getControllerCallbacks(int n) {
        this.ensureOnMainThread();
        LocalControllerListener localControllerListener = (LocalControllerListener)this.controllerListenerMap.get(n);
        if (localControllerListener == null) {
            return null;
        }
        return localControllerListener.callbacks;
    }

    public void clearControllers() {
        this.ensureOnMainThread();
        this.controllerListenerMap.clear();
    }

    @UsedByNative
    public boolean createAndConnectController(int n, Callbacks callbacks, int n2) throws RemoteException {
        return this.createAndConnectControllerInternal(n, callbacks, new ControllerListenerOptions(n2));
    }

    public boolean createAndConnectController(int n, Callbacks callbacks) throws RemoteException {
        return this.createAndConnectControllerInternal(n, callbacks, new ControllerListenerOptions());
    }

    public void unregisterListeners() {
        this.ensureOnMainThread();
        if (this.service == null) {
            return;
        }
        try {
            this.service.unregisterListener(this.listenerKey);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)TAG, (String)"RemoteException while unregistering listeners.", (Throwable)remoteException);
            return;
        }
    }

    @UsedByNative
    public void vibrateController(int n, int n2, int n3, int n4) {
        Proto.Request request = new Proto.Request();
        new Proto.Request().vibration = new Proto.Request.Vibration().setFrequencyHz(n2).setVolumePercentage(n3).setDurationMs(n4);
        ControllerRequest controllerRequest = new ControllerRequest();
        controllerRequest.setFromProto(request);
        this.mainThreadHandler.post((Runnable)new ControllerServiceBridge$$Lambda$2(this, n, controllerRequest));
    }

    private void vibrateControllerInternal(int n, ControllerRequest controllerRequest) {
        this.ensureOnMainThread();
        if (this.service == null) {
            Log.w((String)TAG, (String)"Vibration cancelled: service not connected");
            return;
        }
        try {
            this.service.request(n, controllerRequest);
            return;
        }
        catch (RemoteException remoteException) {
            Log.w((String)TAG, (String)"RemoteException while vibrating the controller.", (Throwable)remoteException);
            return;
        }
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        int n;
        this.ensureOnMainThread();
        if (!this.isBound) {
            Log.d((String)TAG, (String)"Ignoring service connection after unbind.");
            return;
        }
        this.service = IControllerService.Stub.asInterface(iBinder);
        try {
            n = this.service.initialize(25);
        }
        catch (RemoteException remoteException) {
            Log.e((String)TAG, (String)"Failed to call initialize() on controller service (RemoteException).", (Throwable)remoteException);
            this.defaultListener.callbacks.onServiceFailed();
            this.doUnbind();
            return;
        }
        if (n != 0) {
            String string2 = String.valueOf(ControllerInitResults.toString(n));
            Log.e((String)TAG, (String)(string2.length() != 0 ? "initialize() returned error: ".concat(string2) : new String("initialize() returned error: ")));
            this.defaultListener.callbacks.onServiceInitFailed(n);
            this.doUnbind();
            return;
        }
        if (this.vrcoreApiVersion >= 21) {
            try {
                if (!this.service.registerServiceListener(this.defaultServiceListener)) {
                    Log.e((String)TAG, (String)"Failed to register remote service listener.");
                    this.defaultListener.callbacks.onServiceInitFailed(n);
                    this.doUnbind();
                    return;
                }
            }
            catch (RemoteException remoteException) {
                String string3 = String.valueOf((Object)remoteException);
                Log.w((String)TAG, (String)new StringBuilder(53 + String.valueOf(string3).length()).append("Exception while registering remote service listener: ").append(string3).toString());
            }
        }
        this.setupAndBindDefaultControllerListener();
    }

    private void setupAndBindDefaultControllerListener() {
        this.defaultListener.callbacks.onServiceConnected(1);
        if (!this.registerListener(this.defaultListener.controllerIndex, this.defaultListener)) {
            Log.w((String)TAG, (String)"Failed to register service listener.");
            this.defaultListener.callbacks.onServiceFailed();
            this.doUnbind();
            return;
        }
        this.controllerListenerMap.put(this.defaultListener.controllerIndex, (Object)this.defaultListener);
        Log.i((String)TAG, (String)"Successfully registered service listener.");
    }

    public void onServiceDisconnected(ComponentName componentName) {
        this.ensureOnMainThread();
        this.service = null;
        this.defaultListener.callbacks.onServiceDisconnected();
    }

    private void ensureOnMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new IllegalStateException("This should be running on the main thread.");
        }
    }

    private void handleServiceEvent(int n) {
        if (n == 1) {
            this.mainThreadHandler.post((Runnable)new ControllerServiceBridge$$Lambda$3(this));
        }
    }

    private void handleAvailableControllersChanged() {
        this.ensureOnMainThread();
        if (this.getNumOfControllers() > 0) {
            if (this.isBound) {
                this.setupAndBindDefaultControllerListener();
                return;
            }
        } else {
            int n = this.controllerListenerMap.size();
            for (int i = 0; i < n; ++i) {
                LocalControllerListener localControllerListener = (LocalControllerListener)this.controllerListenerMap.valueAt(i);
                if (localControllerListener == null) continue;
                localControllerListener.callbacks.onControllerStateChanged(i, 0);
            }
            this.clearControllers();
            this.defaultListener.callbacks.onServiceDisconnected();
        }
    }

    public int getNumOfControllers() {
        if (this.service == null) {
            return 0;
        }
        try {
            return this.service.getNumberOfControllers();
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf((Object)remoteException);
            Log.w((String)TAG, (String)new StringBuilder(54 + String.valueOf(string2).length()).append("Remote exception while getting number of controllers: ").append(string2).toString());
            return 0;
        }
    }

    private static int getVrCoreApiVersion(Context context) {
        try {
            return VrCoreUtils.getVrCoreClientApiVersion(context);
        }
        catch (VrCoreNotAvailableException vrCoreNotAvailableException) {
            return 0;
        }
    }

    private static void logIfControllerPacketLags(ControllerEventPacket2 controllerEventPacket2) {
        if (controllerEventPacket2.getTimestampMillis() == 0L) {
            return;
        }
        long l = ControllerEventPacket2.getSystemTimeMillis() - controllerEventPacket2.getTimestampMillis();
        if (l > 300L) {
            Log.w((String)TAG, (String)new StringBuilder(122).append("Experiencing large controller packet delivery time between service and  client: timestamp diff in ms: ").append(l).toString());
        }
    }

    private void initializeDefaultListener(Callbacks callbacks, ControllerListenerOptions controllerListenerOptions) {
        this.defaultListener = new LocalControllerListener(callbacks, controllerListenerOptions, 0);
        this.controllerListenerMap.put(this.defaultListener.controllerIndex, (Object)this.defaultListener);
    }

    private boolean createAndConnectControllerInternal(int n, Callbacks callbacks, ControllerListenerOptions controllerListenerOptions) throws RemoteException {
        this.ensureOnMainThread();
        if (this.service == null) {
            return false;
        }
        LocalControllerListener localControllerListener = new LocalControllerListener(callbacks, controllerListenerOptions, n);
        if (this.registerListener(localControllerListener.controllerIndex, localControllerListener)) {
            if (localControllerListener.controllerIndex == 0) {
                this.defaultListener = localControllerListener;
            }
            this.controllerListenerMap.put(n, (Object)localControllerListener);
            return true;
        }
        if (n == 0) {
            Log.e((String)TAG, (String)new StringBuilder(41).append("Failed to connect controller ").append(n).append(".").toString());
        }
        this.controllerListenerMap.remove(n);
        return false;
    }

    private boolean registerListener(int n, LocalControllerListener localControllerListener) {
        try {
            if (this.service.registerListener(n, this.listenerKey, new ControllerListener(localControllerListener))) {
                return true;
            }
        }
        catch (RemoteException remoteException) {
            Log.w((String)TAG, (String)"RemoteException while registering listener.", (Throwable)remoteException);
        }
        return false;
    }

    private static String createListenerKey() {
        int n = UNIQUE_INT.incrementAndGet();
        return new StringBuilder(30).append(TAG).append(n).toString();
    }

    final /* synthetic */ void lambda$vibrateController$0$ControllerServiceBridge(int n, ControllerRequest controllerRequest) {
        this.vibrateControllerInternal(n, controllerRequest);
    }

    final /* synthetic */ void bridge$lambda$0$ControllerServiceBridge() {
        this.handleAvailableControllersChanged();
    }

    private static class ControllerListener
    extends IControllerListener.Stub {
        private final WeakReference<LocalControllerListener> listener;

        public ControllerListener(LocalControllerListener localControllerListener) {
            this.listener = new WeakReference<LocalControllerListener>(localControllerListener);
        }

        @Override
        public int getApiVersion() throws RemoteException {
            return 25;
        }

        @Override
        public ControllerListenerOptions getOptions() throws RemoteException {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return null;
            }
            return localControllerListener.options;
        }

        @Override
        public void onControllerStateChanged(int n, int n2) throws RemoteException {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return;
            }
            localControllerListener.callbacks.onControllerStateChanged(n, n2);
        }

        @Override
        public void onControllerEventPacket(ControllerEventPacket controllerEventPacket) throws RemoteException {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return;
            }
            controllerEventPacket.setEventsControllerIndex(localControllerListener.controllerIndex);
            localControllerListener.callbacks.onControllerEventPacket(controllerEventPacket);
            controllerEventPacket.recycle();
        }

        @Override
        public void onControllerEventPacket2(ControllerEventPacket2 controllerEventPacket2) throws RemoteException {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return;
            }
            ControllerServiceBridge.logIfControllerPacketLags(controllerEventPacket2);
            controllerEventPacket2.setEventsControllerIndex(localControllerListener.controllerIndex);
            localControllerListener.callbacks.onControllerEventPacket2(controllerEventPacket2);
            controllerEventPacket2.recycle();
        }

        @Override
        public void onControllerRecentered(ControllerOrientationEvent controllerOrientationEvent) {
            LocalControllerListener localControllerListener = (LocalControllerListener)this.listener.get();
            if (localControllerListener == null) {
                return;
            }
            controllerOrientationEvent.controllerId = localControllerListener.controllerIndex;
            localControllerListener.callbacks.onControllerRecentered(controllerOrientationEvent);
        }
    }

    private static class ControllerServiceListener
    extends IControllerServiceListener.Stub {
        private final WeakReference<ControllerServiceBridge> serviceBridge;

        public ControllerServiceListener(ControllerServiceBridge controllerServiceBridge) {
            this.serviceBridge = new WeakReference<ControllerServiceBridge>(controllerServiceBridge);
        }

        @Override
        public int getApiVersion() throws RemoteException {
            return 25;
        }

        @Override
        public void onControllerServiceEvent(int n) throws RemoteException {
            ControllerServiceBridge controllerServiceBridge = (ControllerServiceBridge)this.serviceBridge.get();
            if (controllerServiceBridge == null) {
                return;
            }
            controllerServiceBridge.handleServiceEvent(n);
        }
    }

    private static class LocalControllerListener {
        public final Callbacks callbacks;
        public final ControllerListenerOptions options;
        public final int controllerIndex;

        public LocalControllerListener(Callbacks callbacks, ControllerListenerOptions controllerListenerOptions, int n) {
            this.callbacks = callbacks;
            this.options = controllerListenerOptions;
            this.controllerIndex = n;
        }
    }

    @UsedByNative
    public static interface Callbacks {
        public void onServiceConnected(int var1);

        public void onServiceDisconnected();

        public void onServiceUnavailable();

        public void onServiceFailed();

        public void onServiceInitFailed(int var1);

        public void onControllerStateChanged(int var1, int var2);

        public void onControllerEventPacket(ControllerEventPacket var1);

        public void onControllerRecentered(ControllerOrientationEvent var1);

        public void onControllerEventPacket2(ControllerEventPacket2 var1);
    }
}

