/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import com.google.vr.cardboard.ExternalSurfaceManager$$Lambda$0;
import com.google.vr.cardboard.ExternalSurfaceManager$$Lambda$1;
import com.google.vr.cardboard.ExternalSurfaceManager$NativeCallback$$Lambda$0;
import com.google.vr.cardboard.UsedByNative;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@UsedByNative
public class ExternalSurfaceManager {
    private static final String TAG = ExternalSurfaceManager.class.getSimpleName();
    public static final int UNSPECIFIED_BUFFER_SIZE = -1;
    private final UpdateSurfaceCallback updateSurfaceCallback;
    private final SurfaceTextureFactory surfaceTextureFactory;
    private final Object surfaceDataUpdateLock = new Object();
    private volatile ExternalSurfaceData surfaceData = new ExternalSurfaceData();
    private int nextID = 1;
    private boolean isAttachedToGlContext;

    @UsedByNative
    public ExternalSurfaceManager(final long l) {
        this(new UpdateSurfaceCallback(){

            @Override
            public void updateSurface(int n, int n2, long l2, float[] fArray) {
                ExternalSurfaceManager.nativeUpdateSurface(l, n, n2, l2, fArray);
            }
        }, new SurfaceTextureFactory(){

            @Override
            public SurfaceTexture createSurfaceTexture(int n) {
                return new SurfaceTexture(n);
            }
        });
    }

    public ExternalSurfaceManager(UpdateSurfaceCallback updateSurfaceCallback, SurfaceTextureFactory surfaceTextureFactory) {
        this.updateSurfaceCallback = updateSurfaceCallback;
        this.surfaceTextureFactory = surfaceTextureFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByNative
    public void shutdown() {
        Object object = this.surfaceDataUpdateLock;
        synchronized (object) {
            ExternalSurfaceData externalSurfaceData = this.surfaceData;
            this.surfaceData = new ExternalSurfaceData();
            if (!externalSurfaceData.surfaces.isEmpty()) {
                for (Map.Entry<Integer, ExternalSurface> entry : externalSurfaceData.surfaces.entrySet()) {
                    entry.getValue().shutdown(this.updateSurfaceCallback);
                }
            }
            if (!externalSurfaceData.surfacesToRelease.isEmpty()) {
                for (Map.Entry<Integer, ExternalSurface> entry : externalSurfaceData.surfacesToRelease.entrySet()) {
                    entry.getValue().shutdown(this.updateSurfaceCallback);
                }
            }
            return;
        }
    }

    @UsedByNative
    public int createExternalSurface() {
        return this.createExternalSurfaceImpl(-1, -1, null);
    }

    @UsedByNative
    public int createExternalSurface(int n, int n2, Runnable runnable, Runnable runnable2, Handler handler) {
        if (runnable == null || handler == null) {
            throw new IllegalArgumentException("Surface listener and handler must both be non-null for external Surface creation for Java callbacks.");
        }
        return this.createExternalSurfaceImpl(n, n2, new AndroidHandlerCallback(runnable, runnable2, handler));
    }

    @UsedByNative
    public int createExternalSurfaceWithNativeCallback(int n, int n2, long l, long l2) {
        return this.createExternalSurfaceImpl(n, n2, new NativeCallback(l, l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createExternalSurfaceImpl(int n, int n2, ExternalSurfaceCallback externalSurfaceCallback) {
        Object object = this.surfaceDataUpdateLock;
        synchronized (object) {
            ExternalSurfaceData externalSurfaceData = new ExternalSurfaceData(this.surfaceData);
            int n3 = this.nextID++;
            externalSurfaceData.surfaces.put(n3, new ExternalSurface(n3, n, n2, externalSurfaceCallback, this.surfaceTextureFactory));
            this.surfaceData = externalSurfaceData;
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByNative
    public void releaseExternalSurface(int n) {
        Object object = this.surfaceDataUpdateLock;
        synchronized (object) {
            ExternalSurfaceData externalSurfaceData = new ExternalSurfaceData(this.surfaceData);
            ExternalSurface externalSurface = externalSurfaceData.surfaces.remove(n);
            if (externalSurface != null) {
                externalSurfaceData.surfacesToRelease.put(n, externalSurface);
                this.surfaceData = externalSurfaceData;
            } else {
                Log.e((String)TAG, (String)new StringBuilder(48).append("Not releasing nonexistent surface ID ").append(n).toString());
            }
            return;
        }
    }

    public int getSurfaceCount() {
        return this.surfaceData.surfaces.size();
    }

    @UsedByNative
    public Surface getSurface(int n) {
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        if (externalSurfaceData.surfaces.containsKey(n)) {
            return externalSurfaceData.surfaces.get(n).getSurface();
        }
        Log.e((String)TAG, (String)new StringBuilder(58).append("Surface with ID ").append(n).append(" does not exist, returning null").toString());
        return null;
    }

    @UsedByNative
    public void consumerAttachToCurrentGLContext() {
        this.isAttachedToGlContext = true;
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        if (!externalSurfaceData.surfaces.isEmpty()) {
            for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
                externalSurface.maybeAttachToCurrentGLContext();
            }
        }
    }

    @UsedByNative
    public void consumerAttachToCurrentGLContext(Map<Integer, Integer> map) {
        this.isAttachedToGlContext = true;
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        if (!this.surfaceData.surfaces.isEmpty()) {
            for (Integer object : this.surfaceData.surfaces.keySet()) {
                if (map.containsKey(object)) continue;
                Log.e((String)TAG, (String)String.format("Surface %d's texture ID is not provided, abandoning attaching to current GL context.", object));
                return;
            }
        }
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                if (externalSurfaceData.surfaces.containsKey(entry.getKey())) {
                    externalSurfaceData.surfaces.get(entry.getKey()).maybeAttachToCurrentGLContext((Integer)entry.getValue());
                    continue;
                }
                Log.e((String)TAG, (String)String.format("Surface %d doesn't exist, skip attaching to current GL context.", entry.getKey()));
            }
        }
    }

    @UsedByNative
    public void consumerDetachFromCurrentGLContext() {
        this.isAttachedToGlContext = false;
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        if (!externalSurfaceData.surfaces.isEmpty()) {
            for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
                externalSurface.maybeDetachFromCurrentGLContext();
            }
        }
    }

    @UsedByNative
    public void consumerUpdateManagedSurfaces() {
        this.consumerUpdateManagedSurfaceHelper(new ExternalSurfaceManager$$Lambda$0(this));
    }

    @UsedByNative
    public void consumerUpdateManagedSurfacesSequentially() {
        this.consumerUpdateManagedSurfaceHelper(new ExternalSurfaceManager$$Lambda$1(this));
    }

    private void consumerUpdateManagedSurfaceHelper(ExternalSurfaceConsumer externalSurfaceConsumer) {
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        if (this.isAttachedToGlContext && !externalSurfaceData.surfaces.isEmpty()) {
            for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
                externalSurface.maybeAttachToCurrentGLContext();
                externalSurfaceConsumer.accept(externalSurface);
            }
        }
        if (!externalSurfaceData.surfacesToRelease.isEmpty()) {
            for (ExternalSurface externalSurface : externalSurfaceData.surfacesToRelease.values()) {
                externalSurface.shutdown(this.updateSurfaceCallback);
            }
        }
    }

    private static native void nativeUpdateSurface(long var0, int var2, int var3, long var4, float[] var6);

    private static native void nativeCallback(long var0);

    final /* synthetic */ void lambda$consumerUpdateManagedSurfacesSequentially$1$ExternalSurfaceManager(ExternalSurface externalSurface) {
        externalSurface.updateSurfaceTextureSequentially(this.updateSurfaceCallback);
    }

    final /* synthetic */ void lambda$consumerUpdateManagedSurfaces$0$ExternalSurfaceManager(ExternalSurface externalSurface) {
        externalSurface.updateSurfaceTexture(this.updateSurfaceCallback);
    }

    private static class ExternalSurface {
        private final int id;
        private final ExternalSurfaceCallback callback;
        private final SurfaceTextureFactory surfaceTextureFactory;
        private final float[] transformMatrix = new float[16];
        private final AtomicInteger frameAvailableCallbackCount = new AtomicInteger(0);
        private final AtomicBoolean released = new AtomicBoolean(false);
        private final int[] glTextureId = new int[1];
        private final int surfaceTextureWidth;
        private final int surfaceTextureHeight;
        private volatile SurfaceTexture surfaceTexture;
        private volatile Surface surface;
        private volatile boolean isAttached = false;
        private volatile boolean isShutdown = false;
        private final Object onFrameAvailableShutdownLock = new Object();

        ExternalSurface(int n, int n2, int n3, ExternalSurfaceCallback externalSurfaceCallback, SurfaceTextureFactory surfaceTextureFactory) {
            this.id = n;
            this.surfaceTextureWidth = n2;
            this.surfaceTextureHeight = n3;
            this.callback = externalSurfaceCallback;
            this.surfaceTextureFactory = surfaceTextureFactory;
            Matrix.setIdentityM((float[])this.transformMatrix, (int)0);
        }

        void maybeAttachToCurrentGLContext() {
            if (this.isAttached) {
                return;
            }
            GLES20.glGenTextures((int)1, (int[])this.glTextureId, (int)0);
            this.maybeAttachToCurrentGLContext(this.glTextureId[0]);
        }

        void maybeAttachToCurrentGLContext(int n) {
            if (this.isAttached) {
                return;
            }
            this.glTextureId[0] = n;
            if (this.surfaceTexture == null) {
                this.surfaceTexture = this.surfaceTextureFactory.createSurfaceTexture(this.glTextureId[0]);
                if (this.surfaceTextureWidth > 0 && this.surfaceTextureHeight > 0) {
                    this.surfaceTexture.setDefaultBufferSize(this.surfaceTextureWidth, this.surfaceTextureHeight);
                }
                this.surfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                        ExternalSurface.this.frameAvailableCallbackCount.getAndIncrement();
                        Object object = ExternalSurface.this.onFrameAvailableShutdownLock;
                        synchronized (object) {
                            if (!ExternalSurface.this.isShutdown && ExternalSurface.this.callback != null) {
                                ExternalSurface.this.callback.onFrameAvailable();
                            }
                            return;
                        }
                    }
                }, new Handler(Looper.getMainLooper()));
                this.surface = new Surface(this.surfaceTexture);
            } else {
                this.surfaceTexture.attachToGLContext(this.glTextureId[0]);
            }
            this.isAttached = true;
            if (this.callback != null) {
                this.callback.onSurfaceAvailable();
            }
        }

        void maybeDetachFromCurrentGLContext() {
            if (!this.isAttached) {
                return;
            }
            if (this.callback != null) {
                this.callback.cancelPosts();
            }
            this.surfaceTexture.detachFromGLContext();
            this.isAttached = false;
        }

        void updateSurfaceTexture(UpdateSurfaceCallback updateSurfaceCallback) {
            if (!this.isAttached) {
                return;
            }
            boolean bl = this.frameAvailableCallbackCount.getAndSet(0) > 0;
            if (bl) {
                this.surfaceTexture.updateTexImage();
                this.surfaceTexture.getTransformMatrix(this.transformMatrix);
                long l = this.surfaceTexture.getTimestamp();
                updateSurfaceCallback.updateSurface(this.id, this.glTextureId[0], l, this.transformMatrix);
            }
        }

        void updateSurfaceTextureSequentially(UpdateSurfaceCallback updateSurfaceCallback) {
            if (!this.isAttached) {
                return;
            }
            boolean bl = this.frameAvailableCallbackCount.get() > 0;
            if (bl) {
                this.frameAvailableCallbackCount.decrementAndGet();
                this.surfaceTexture.updateTexImage();
                this.surfaceTexture.getTransformMatrix(this.transformMatrix);
                long l = this.surfaceTexture.getTimestamp();
                updateSurfaceCallback.updateSurface(this.id, this.glTextureId[0], l, this.transformMatrix);
            }
        }

        Surface getSurface() {
            if (!this.isAttached) {
                return null;
            }
            return this.surface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown(UpdateSurfaceCallback updateSurfaceCallback) {
            Object object = this.onFrameAvailableShutdownLock;
            synchronized (object) {
                this.isShutdown = true;
            }
            if (this.released.getAndSet(true)) {
                return;
            }
            if (this.callback != null) {
                this.callback.cancelPosts();
            }
            if (this.surfaceTexture != null) {
                this.surfaceTexture.release();
                this.surfaceTexture = null;
                if (this.surface != null) {
                    this.surface.release();
                }
                this.surface = null;
            }
            updateSurfaceCallback.updateSurface(this.id, 0, 0L, this.transformMatrix);
        }
    }

    private static class AndroidHandlerCallback
    implements ExternalSurfaceCallback {
        private final Runnable surfaceListener;
        private final Runnable frameListener;
        private final Handler handler;

        public AndroidHandlerCallback(Runnable runnable, Runnable runnable2, Handler handler) {
            this.surfaceListener = runnable;
            this.frameListener = runnable2;
            this.handler = handler;
        }

        @Override
        public void onSurfaceAvailable() {
            if (this.surfaceListener != null) {
                this.handler.post(this.surfaceListener);
            }
        }

        @Override
        public void onFrameAvailable() {
            if (this.frameListener != null) {
                this.handler.post(this.frameListener);
            }
        }

        @Override
        public void cancelPosts() {
            if (this.surfaceListener != null) {
                this.handler.removeCallbacks(this.surfaceListener);
            }
            if (this.frameListener != null) {
                this.handler.removeCallbacks(this.frameListener);
            }
        }
    }

    private static class NativeCallback
    implements ExternalSurfaceCallback {
        private final Runnable surfaceListener;
        private final long nativeFrameCallbackPtr;
        private final Handler surfaceMainHandler;

        public NativeCallback(long l, long l2) {
            this.surfaceListener = new ExternalSurfaceManager$NativeCallback$$Lambda$0(l);
            this.nativeFrameCallbackPtr = l2;
            this.surfaceMainHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void onSurfaceAvailable() {
            this.surfaceMainHandler.post(this.surfaceListener);
        }

        @Override
        public void onFrameAvailable() {
            ExternalSurfaceManager.nativeCallback(this.nativeFrameCallbackPtr);
        }

        @Override
        public void cancelPosts() {
            this.surfaceMainHandler.removeCallbacks(this.surfaceListener);
        }

        static final /* synthetic */ void lambda$new$0$ExternalSurfaceManager$NativeCallback(long l) {
            ExternalSurfaceManager.nativeCallback(l);
        }
    }

    private static interface ExternalSurfaceCallback {
        public void onSurfaceAvailable();

        public void onFrameAvailable();

        public void cancelPosts();
    }

    private static class ExternalSurfaceData {
        final HashMap<Integer, ExternalSurface> surfaces;
        final HashMap<Integer, ExternalSurface> surfacesToRelease;

        ExternalSurfaceData() {
            this.surfaces = new HashMap();
            this.surfacesToRelease = new HashMap();
        }

        ExternalSurfaceData(ExternalSurfaceData externalSurfaceData) {
            this.surfaces = new HashMap<Integer, ExternalSurface>(externalSurfaceData.surfaces);
            this.surfacesToRelease = new HashMap<Integer, ExternalSurface>(externalSurfaceData.surfacesToRelease);
            Iterator<Map.Entry<Integer, ExternalSurface>> iterator = this.surfacesToRelease.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, ExternalSurface> entry = iterator.next();
                if (!entry.getValue().released.get()) continue;
                iterator.remove();
            }
        }
    }

    private static interface ExternalSurfaceConsumer {
        public void accept(ExternalSurface var1);
    }

    public static interface SurfaceTextureFactory {
        public SurfaceTexture createSurfaceTexture(int var1);
    }

    public static interface UpdateSurfaceCallback {
        public void updateSurface(int var1, int var2, long var3, float[] var5);
    }
}

