/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.ContentProviderClient;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import android.util.Base64;
import android.util.Log;
import com.google.common.logging.nano.Vr;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrSettingsProviderContract;
import com.google.vr.ndk.base.SdkConfigurationReader;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Display;
import com.google.vr.sdk.proto.nano.Preferences;
import com.google.vr.sdk.proto.nano.SdkConfiguration;

public class ContentProviderVrParamsProvider
implements VrParamsProvider {
    private static final String TAG = ContentProviderVrParamsProvider.class.getSimpleName();
    private final ContentProviderClient client;
    private final Uri deviceParamsSettingUri;
    private final Uri userPrefsUri;
    private final Uri displayParamsSettingUri;
    private final Uri sdkConfigurationParamsSettingUri;
    private final Uri recentHeadsetsSettingUri;

    public ContentProviderVrParamsProvider(ContentProviderClient contentProviderClient, String string2) {
        if (contentProviderClient == null) {
            throw new IllegalArgumentException("ContentProviderClient must not be null");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Authority key must be non-null and non-empty");
        }
        this.client = contentProviderClient;
        this.deviceParamsSettingUri = VrSettingsProviderContract.createUri(string2, "device_params");
        this.userPrefsUri = VrSettingsProviderContract.createUri(string2, "user_prefs");
        this.displayParamsSettingUri = VrSettingsProviderContract.createUri(string2, "phone_params");
        this.sdkConfigurationParamsSettingUri = VrSettingsProviderContract.createUri(string2, "sdk_configuration_params");
        this.recentHeadsetsSettingUri = VrSettingsProviderContract.createUri(string2, "recent_headsets");
    }

    @Override
    public CardboardDevice.DeviceParams readDeviceParams() {
        return this.readParams(new CardboardDevice.DeviceParams(), this.deviceParamsSettingUri, null);
    }

    @Override
    public boolean writeDeviceParams(CardboardDevice.DeviceParams deviceParams) {
        return this.writeParams((MessageNano)deviceParams, this.deviceParamsSettingUri);
    }

    @Override
    public CardboardDevice.DeviceParamsList readRecentHeadsets() {
        return this.readParams(new CardboardDevice.DeviceParamsList(), this.recentHeadsetsSettingUri, null);
    }

    @Override
    public Display.DisplayParams readDisplayParams() {
        return this.readParams(new Display.DisplayParams(), this.displayParamsSettingUri, null);
    }

    @Override
    public Vr.VREvent.SdkConfigurationParams readSdkConfigurationParams(SdkConfiguration.SdkConfigurationRequest sdkConfigurationRequest) {
        String string2 = Base64.encodeToString((byte[])MessageNano.toByteArray((MessageNano)sdkConfigurationRequest), (int)0);
        return this.readParams(SdkConfigurationReader.DEFAULT_PARAMS, this.sdkConfigurationParamsSettingUri, string2);
    }

    @Override
    public Preferences.UserPrefs readUserPrefs() {
        return this.readParams(new Preferences.UserPrefs(), this.userPrefsUri, null);
    }

    @Override
    public boolean updateUserPrefs(Preferences.UserPrefs userPrefs) {
        return this.writeParams((MessageNano)userPrefs, this.userPrefsUri);
    }

    @Override
    public void close() {
        if (Build.VERSION.SDK_INT >= 24) {
            this.client.close();
            return;
        }
        this.client.release();
    }

    private <T extends MessageNano> T readParams(T t, Uri uri, String string2) {
        try (Cursor cursor = null;){
            cursor = this.client.query(uri, null, string2, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                byte[] byArray = cursor.getBlob(0);
                if (byArray == null) {
                    return null;
                }
                MessageNano messageNano = MessageNano.mergeFrom(t, (byte[])byArray);
                return (T)messageNano;
            }
            String string3 = String.valueOf(uri);
            Log.e((String)TAG, (String)new StringBuilder(50 + String.valueOf(string3).length()).append("Invalid params result from ContentProvider query: ").append(string3).toString());
            return null;
        }
    }

    private boolean writeParams(MessageNano messageNano, Uri uri) {
        try {
            int n;
            if (messageNano == null) {
                n = this.client.delete(uri, null, null);
            } else {
                ContentValues contentValues = new ContentValues();
                byte[] byArray = MessageNano.toByteArray((MessageNano)messageNano);
                contentValues.put("value", byArray);
                n = this.client.update(uri, contentValues, null, null);
            }
            return n > 0;
        }
        catch (RemoteException remoteException) {
            Log.e((String)TAG, (String)"Failed to write params to ContentProvider", (Throwable)remoteException);
            return false;
        }
        catch (SecurityException securityException) {
            Log.e((String)TAG, (String)"Insufficient permissions to write params to ContentProvider", (Throwable)securityException);
            return false;
        }
    }
}

