/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.vr.vrcore.controller.api.ControllerBatteryEvent;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerPositionEvent;
import com.google.vr.vrcore.controller.api.ControllerTrackingStatusEvent;
import java.util.ArrayDeque;
import java.util.concurrent.TimeUnit;

public final class ControllerEventPacket2
extends ControllerEventPacket {
    private static ArrayDeque<ControllerEventPacket2> pool = new ArrayDeque();
    private static Object poolLock = new Object();
    private int positionEventCount;
    private ControllerPositionEvent[] positionEvents = new ControllerPositionEvent[16];
    private boolean hasBatteryEvent;
    private ControllerBatteryEvent batteryEvent = new ControllerBatteryEvent();
    private long timestampMillis;
    private int trackingStatusEventCount;
    private final ControllerTrackingStatusEvent[] trackingStatusEvents = new ControllerTrackingStatusEvent[16];
    public static final Parcelable.Creator<ControllerEventPacket2> CREATOR = new Parcelable.Creator<ControllerEventPacket2>(){

        public ControllerEventPacket2 createFromParcel(Parcel parcel) {
            ControllerEventPacket2 controllerEventPacket2 = ControllerEventPacket2.obtain();
            controllerEventPacket2.readFromParcel(parcel);
            return controllerEventPacket2;
        }

        public ControllerEventPacket2[] newArray(int n) {
            return new ControllerEventPacket2[n];
        }
    };

    public ControllerEventPacket2() {
        for (int i = 0; i < 16; ++i) {
            this.positionEvents[i] = new ControllerPositionEvent();
            this.trackingStatusEvents[i] = new ControllerTrackingStatusEvent();
        }
        this.clear();
    }

    @Override
    public final void copyFrom(ControllerEventPacket controllerEventPacket) {
        if (!(controllerEventPacket instanceof ControllerEventPacket2)) {
            throw new IllegalStateException("Cannot copy ControllerEventPacket2 from non-ControllerEventPacket2 instance.");
        }
        super.copyFrom(controllerEventPacket);
        ControllerEventPacket2 controllerEventPacket2 = (ControllerEventPacket2)controllerEventPacket;
        this.positionEventCount = controllerEventPacket2.positionEventCount;
        this.trackingStatusEventCount = controllerEventPacket2.trackingStatusEventCount;
        this.hasBatteryEvent = controllerEventPacket2.hasBatteryEvent;
        this.timestampMillis = controllerEventPacket2.timestampMillis;
        this.batteryEvent.copyFrom(controllerEventPacket2.batteryEvent);
        for (int i = 0; i < 16; ++i) {
            this.positionEvents[i].copyFrom(controllerEventPacket2.positionEvents[i]);
            this.trackingStatusEvents[i].copyFrom(controllerEventPacket2.trackingStatusEvents[i]);
        }
    }

    @Override
    public final void clear() {
        super.clear();
        this.positionEventCount = 0;
        this.trackingStatusEventCount = 0;
        this.hasBatteryEvent = false;
        this.timestampMillis = 0L;
    }

    @Override
    public final void setEventsControllerIndex(int n) {
        super.setEventsControllerIndex(n);
        ControllerEventPacket2.setControllerIndex(n, this.positionEventCount, this.positionEvents);
        this.batteryEvent.controllerId = n;
        ControllerEventPacket2.setControllerIndex(n, this.trackingStatusEventCount, this.trackingStatusEvents);
    }

    public final void refreshTimestampMillis() {
        this.timestampMillis = ControllerEventPacket2.getSystemTimeMillis();
    }

    public final void setTimestampMillis(long l) {
        this.timestampMillis = l;
    }

    public final long getTimestampMillis() {
        return this.timestampMillis;
    }

    public final int getPositionEventCount() {
        return this.positionEventCount;
    }

    public final int getTrackingStatusEventCount() {
        return this.trackingStatusEventCount;
    }

    public final boolean hasBatteryEvent() {
        return this.hasBatteryEvent;
    }

    public final ControllerPositionEvent getPositionEvent(int n) {
        if (n < 0 || n >= this.positionEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.positionEvents[n];
    }

    public final ControllerPositionEvent addPositionEvent() {
        if (this.positionEventCount >= 16) {
            throw new IllegalStateException("ControllerEventPacket capacity exceeded.");
        }
        return this.positionEvents[this.positionEventCount++];
    }

    public final ControllerTrackingStatusEvent getTrackingStatusEvent(int n) {
        if (n < 0 || n >= this.trackingStatusEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.trackingStatusEvents[n];
    }

    public final ControllerTrackingStatusEvent addTrackingStatusEvent() {
        if (this.trackingStatusEventCount >= 16) {
            throw new IllegalStateException("ControllerEventPacket capacity exceeded.");
        }
        return this.trackingStatusEvents[this.trackingStatusEventCount++];
    }

    public final ControllerBatteryEvent getBatteryEvent() {
        if (!this.hasBatteryEvent) {
            throw new IllegalStateException("ControllerEventPacket doesn't have a battery event.");
        }
        return this.batteryEvent;
    }

    public final ControllerBatteryEvent addBatteryEvent() {
        if (this.hasBatteryEvent) {
            throw new IllegalStateException("ControllerEventPacket already has battery event.");
        }
        this.hasBatteryEvent = true;
        return this.batteryEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerEventPacket2 obtain() {
        Object object = poolLock;
        synchronized (object) {
            return pool.isEmpty() ? new ControllerEventPacket2() : pool.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void recycle() {
        this.clear();
        Object object = poolLock;
        synchronized (object) {
            if (!pool.contains(this)) {
                pool.add(this);
            }
            return;
        }
    }

    @Override
    public final int describeContents() {
        return 0;
    }

    @Override
    protected final int calculateParcelByteLength() {
        int n;
        int n2 = super.calculateParcelByteLength();
        n2 += 4;
        n2 += 4;
        for (n = 0; n < this.positionEventCount; ++n) {
            n2 += this.positionEvents[n].getByteSize();
        }
        n2 += 4;
        if (this.hasBatteryEvent) {
            n2 += this.batteryEvent.getByteSize();
        }
        n2 += 8;
        n2 += 4;
        for (n = 0; n < this.trackingStatusEventCount; ++n) {
            n2 += this.trackingStatusEvents[n].getByteSize();
        }
        return n2;
    }

    @Override
    public final void writeToParcel(Parcel parcel, int n) {
        int n2;
        int n3 = parcel.dataPosition();
        int n4 = this.calculateParcelByteLength();
        parcel.writeInt(n4);
        super.writeToParcel(parcel, n);
        parcel.writeInt(this.positionEventCount);
        for (n2 = 0; n2 < this.positionEventCount; ++n2) {
            this.positionEvents[n2].writeToParcel(parcel, n);
        }
        parcel.writeInt(this.hasBatteryEvent ? 1 : 0);
        if (this.hasBatteryEvent) {
            this.batteryEvent.writeToParcel(parcel, n);
        }
        parcel.writeLong(this.timestampMillis);
        parcel.writeInt(this.trackingStatusEventCount);
        for (n2 = 0; n2 < this.trackingStatusEventCount; ++n2) {
            this.trackingStatusEvents[n2].writeToParcel(parcel, n);
        }
        if (parcel.dataPosition() - n3 != n4) {
            throw new IllegalStateException("Parcelable implemented incorrectly, getByteSize() must return the correct size for each ControllerEvent subclass.");
        }
    }

    @Override
    public final void readFromParcel(Parcel parcel) {
        int n;
        int n2 = parcel.dataPosition();
        int n3 = parcel.readInt();
        int n4 = n2 + n3;
        super.readFromParcel(parcel);
        if (parcel.dataPosition() < n4) {
            this.positionEventCount = parcel.readInt();
            this.checkIsValidEventCount(this.positionEventCount);
            for (n = 0; n < this.positionEventCount; ++n) {
                this.positionEvents[n].readFromParcel(parcel);
            }
        }
        if (parcel.dataPosition() < n4) {
            boolean bl = this.hasBatteryEvent = 0 != parcel.readInt();
            if (this.hasBatteryEvent) {
                this.batteryEvent.readFromParcel(parcel);
            }
        }
        if (parcel.dataPosition() < n4) {
            this.timestampMillis = parcel.readLong();
        }
        if (parcel.dataPosition() < n4) {
            this.trackingStatusEventCount = parcel.readInt();
            this.checkIsValidEventCount(this.trackingStatusEventCount);
            for (n = 0; n < this.trackingStatusEventCount; ++n) {
                this.trackingStatusEvents[n].readFromParcel(parcel);
            }
        }
        parcel.setDataPosition(n4);
    }

    public static long getSystemTimeMillis() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime(), TimeUnit.NANOSECONDS);
    }
}

