/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.proto.nano;

import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.ExtendableMessageNano;
import com.google.protobuf.nano.InternalNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.NanoEnumValue;
import com.google.protobuf.nano.WireFormatNano;
import java.io.IOException;

public class Preferences {
    private Preferences() {
    }

    @NanoEnumValue(value=ControllerConfigurationType.class, legacy=false)
    public static int checkControllerConfigurationTypeOrThrow(int n) {
        if (n >= 0 && n <= 3) {
            return n;
        }
        throw new IllegalArgumentException(new StringBuilder(59).append(n).append(" is not a valid enum ControllerConfigurationType").toString());
    }

    @NanoEnumValue(value=ControllerConfigurationType.class, legacy=false)
    public static int[] checkControllerConfigurationTypeOrThrow(int[] nArray) {
        int[] nArray2;
        int[] nArray3 = nArray2 = (int[])nArray.clone();
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray3[i];
            Preferences.checkControllerConfigurationTypeOrThrow(n2);
        }
        return nArray2;
    }

    public static final class TrackingConfigurationParams
    extends ExtendableMessageNano<TrackingConfigurationParams>
    implements Cloneable {
        private static volatile TrackingConfigurationParams[] _emptyArray;
        private int bitField0_;
        private int controllerConfigType_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static TrackingConfigurationParams[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new TrackingConfigurationParams[0];
                    }
                }
            }
            return _emptyArray;
        }

        @NanoEnumValue(value=ControllerConfigurationType.class, legacy=false)
        public final int getControllerConfigType() {
            return this.controllerConfigType_;
        }

        public final TrackingConfigurationParams setControllerConfigType(@NanoEnumValue(value=ControllerConfigurationType.class, legacy=false) int n) {
            this.controllerConfigType_ = n;
            this.bitField0_ |= 1;
            return this;
        }

        public final boolean hasControllerConfigType() {
            return (this.bitField0_ & 1) != 0;
        }

        public final TrackingConfigurationParams clearControllerConfigType() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.controllerConfigType_ = 0;
            return this;
        }

        public TrackingConfigurationParams() {
            this.clear();
        }

        public final TrackingConfigurationParams clear() {
            this.bitField0_ = 0;
            this.controllerConfigType_ = 0;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final TrackingConfigurationParams clone() {
            TrackingConfigurationParams trackingConfigurationParams;
            try {
                trackingConfigurationParams = (TrackingConfigurationParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            return trackingConfigurationParams;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeInt32(1, this.controllerConfigType_);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n += CodedOutputByteBufferNano.computeInt32Size((int)1, (int)this.controllerConfigType_);
            }
            return n;
        }

        public final TrackingConfigurationParams mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block6: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block6;
                        return this;
                    }
                    case 8: 
                }
                this.bitField0_ |= 1;
                int n2 = codedInputByteBufferNano.getPosition();
                try {
                    this.controllerConfigType_ = Preferences.checkControllerConfigurationTypeOrThrow(codedInputByteBufferNano.readInt32());
                    this.bitField0_ |= 1;
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    codedInputByteBufferNano.rewindToPosition(n2);
                    this.storeUnknownField(codedInputByteBufferNano, n);
                    continue;
                }
                break;
            }
        }

        public static TrackingConfigurationParams parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (TrackingConfigurationParams)MessageNano.mergeFrom((MessageNano)new TrackingConfigurationParams(), (byte[])byArray);
        }

        public static TrackingConfigurationParams parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new TrackingConfigurationParams().mergeFrom(codedInputByteBufferNano);
        }
    }

    public static final class FrameReuseMonitoringParams
    extends ExtendableMessageNano<FrameReuseMonitoringParams>
    implements Cloneable {
        private static volatile FrameReuseMonitoringParams[] _emptyArray;
        private int bitField0_;
        private long frameWindowMs_;
        private float failureProportion_;
        private float recoveryProportion_;
        private long fadeInDurationMs_;
        private long fadeOutDurationMs_;
        private long promptUserToKillDelayMs_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static FrameReuseMonitoringParams[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new FrameReuseMonitoringParams[0];
                    }
                }
            }
            return _emptyArray;
        }

        public final long getFrameWindowMs() {
            return this.frameWindowMs_;
        }

        public final boolean hasFrameWindowMs() {
            return (this.bitField0_ & 1) != 0;
        }

        public final FrameReuseMonitoringParams clearFrameWindowMs() {
            this.frameWindowMs_ = 0L;
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public final FrameReuseMonitoringParams setFrameWindowMs(long l) {
            this.bitField0_ |= 1;
            this.frameWindowMs_ = l;
            return this;
        }

        public final float getFailureProportion() {
            return this.failureProportion_;
        }

        public final boolean hasFailureProportion() {
            return (this.bitField0_ & 2) != 0;
        }

        public final FrameReuseMonitoringParams clearFailureProportion() {
            this.failureProportion_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public final FrameReuseMonitoringParams setFailureProportion(float f) {
            this.bitField0_ |= 2;
            this.failureProportion_ = f;
            return this;
        }

        public final float getRecoveryProportion() {
            return this.recoveryProportion_;
        }

        public final boolean hasRecoveryProportion() {
            return (this.bitField0_ & 4) != 0;
        }

        public final FrameReuseMonitoringParams clearRecoveryProportion() {
            this.recoveryProportion_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public final FrameReuseMonitoringParams setRecoveryProportion(float f) {
            this.bitField0_ |= 4;
            this.recoveryProportion_ = f;
            return this;
        }

        public final long getFadeInDurationMs() {
            return this.fadeInDurationMs_;
        }

        public final boolean hasFadeInDurationMs() {
            return (this.bitField0_ & 8) != 0;
        }

        public final FrameReuseMonitoringParams clearFadeInDurationMs() {
            this.fadeInDurationMs_ = 0L;
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        public final FrameReuseMonitoringParams setFadeInDurationMs(long l) {
            this.bitField0_ |= 8;
            this.fadeInDurationMs_ = l;
            return this;
        }

        public final long getFadeOutDurationMs() {
            return this.fadeOutDurationMs_;
        }

        public final boolean hasFadeOutDurationMs() {
            return (this.bitField0_ & 0x10) != 0;
        }

        public final FrameReuseMonitoringParams clearFadeOutDurationMs() {
            this.fadeOutDurationMs_ = 0L;
            this.bitField0_ &= 0xFFFFFFEF;
            return this;
        }

        public final FrameReuseMonitoringParams setFadeOutDurationMs(long l) {
            this.bitField0_ |= 0x10;
            this.fadeOutDurationMs_ = l;
            return this;
        }

        public final long getPromptUserToKillDelayMs() {
            return this.promptUserToKillDelayMs_;
        }

        public final boolean hasPromptUserToKillDelayMs() {
            return (this.bitField0_ & 0x20) != 0;
        }

        public final FrameReuseMonitoringParams clearPromptUserToKillDelayMs() {
            this.promptUserToKillDelayMs_ = 0L;
            this.bitField0_ &= 0xFFFFFFDF;
            return this;
        }

        public final FrameReuseMonitoringParams setPromptUserToKillDelayMs(long l) {
            this.bitField0_ |= 0x20;
            this.promptUserToKillDelayMs_ = l;
            return this;
        }

        public FrameReuseMonitoringParams() {
            this.clear();
        }

        public final FrameReuseMonitoringParams clear() {
            this.bitField0_ = 0;
            this.frameWindowMs_ = 0L;
            this.failureProportion_ = 0.0f;
            this.recoveryProportion_ = 0.0f;
            this.fadeInDurationMs_ = 0L;
            this.fadeOutDurationMs_ = 0L;
            this.promptUserToKillDelayMs_ = 0L;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final FrameReuseMonitoringParams clone() {
            FrameReuseMonitoringParams frameReuseMonitoringParams;
            try {
                frameReuseMonitoringParams = (FrameReuseMonitoringParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            return frameReuseMonitoringParams;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeInt64(1, this.frameWindowMs_);
            }
            if ((this.bitField0_ & 2) != 0) {
                codedOutputByteBufferNano.writeFloat(2, this.failureProportion_);
            }
            if ((this.bitField0_ & 4) != 0) {
                codedOutputByteBufferNano.writeFloat(3, this.recoveryProportion_);
            }
            if ((this.bitField0_ & 8) != 0) {
                codedOutputByteBufferNano.writeInt64(4, this.fadeInDurationMs_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                codedOutputByteBufferNano.writeInt64(5, this.fadeOutDurationMs_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                codedOutputByteBufferNano.writeInt64(6, this.promptUserToKillDelayMs_);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n += CodedOutputByteBufferNano.computeInt64Size((int)1, (long)this.frameWindowMs_);
            }
            if ((this.bitField0_ & 2) != 0) {
                n += CodedOutputByteBufferNano.computeFloatSize((int)2, (float)this.failureProportion_);
            }
            if ((this.bitField0_ & 4) != 0) {
                n += CodedOutputByteBufferNano.computeFloatSize((int)3, (float)this.recoveryProportion_);
            }
            if ((this.bitField0_ & 8) != 0) {
                n += CodedOutputByteBufferNano.computeInt64Size((int)4, (long)this.fadeInDurationMs_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                n += CodedOutputByteBufferNano.computeInt64Size((int)5, (long)this.fadeOutDurationMs_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                n += CodedOutputByteBufferNano.computeInt64Size((int)6, (long)this.promptUserToKillDelayMs_);
            }
            return n;
        }

        public final FrameReuseMonitoringParams mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block9: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block9;
                        return this;
                    }
                    case 8: {
                        this.frameWindowMs_ = codedInputByteBufferNano.readInt64();
                        this.bitField0_ |= 1;
                        continue block9;
                    }
                    case 21: {
                        this.failureProportion_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 2;
                        continue block9;
                    }
                    case 29: {
                        this.recoveryProportion_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 4;
                        continue block9;
                    }
                    case 32: {
                        this.fadeInDurationMs_ = codedInputByteBufferNano.readInt64();
                        this.bitField0_ |= 8;
                        continue block9;
                    }
                    case 40: {
                        this.fadeOutDurationMs_ = codedInputByteBufferNano.readInt64();
                        this.bitField0_ |= 0x10;
                        continue block9;
                    }
                    case 48: 
                }
                this.promptUserToKillDelayMs_ = codedInputByteBufferNano.readInt64();
                this.bitField0_ |= 0x20;
            }
        }

        public static FrameReuseMonitoringParams parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (FrameReuseMonitoringParams)MessageNano.mergeFrom((MessageNano)new FrameReuseMonitoringParams(), (byte[])byArray);
        }

        public static FrameReuseMonitoringParams parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new FrameReuseMonitoringParams().mergeFrom(codedInputByteBufferNano);
        }
    }

    public static final class SafetyCylinderParams
    extends ExtendableMessageNano<SafetyCylinderParams>
    implements Cloneable {
        private static volatile SafetyCylinderParams[] _emptyArray;
        private int bitField0_;
        private float collisionSphereRadius_;
        private float innerRadius_;
        private float outerRadius_;
        public float[] innerFogColor;
        public float[] outerFogColor;
        private float enterEventRadius_;
        private float exitEventRadius_;
        private float anchorWarningDistance_;
        private boolean graphicsEnabled_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static SafetyCylinderParams[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new SafetyCylinderParams[0];
                    }
                }
            }
            return _emptyArray;
        }

        public final float getCollisionSphereRadius() {
            return this.collisionSphereRadius_;
        }

        public final boolean hasCollisionSphereRadius() {
            return (this.bitField0_ & 1) != 0;
        }

        public final SafetyCylinderParams clearCollisionSphereRadius() {
            this.collisionSphereRadius_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public final SafetyCylinderParams setCollisionSphereRadius(float f) {
            this.bitField0_ |= 1;
            this.collisionSphereRadius_ = f;
            return this;
        }

        public final float getInnerRadius() {
            return this.innerRadius_;
        }

        public final boolean hasInnerRadius() {
            return (this.bitField0_ & 2) != 0;
        }

        public final SafetyCylinderParams clearInnerRadius() {
            this.innerRadius_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public final SafetyCylinderParams setInnerRadius(float f) {
            this.bitField0_ |= 2;
            this.innerRadius_ = f;
            return this;
        }

        public final float getOuterRadius() {
            return this.outerRadius_;
        }

        public final boolean hasOuterRadius() {
            return (this.bitField0_ & 4) != 0;
        }

        public final SafetyCylinderParams clearOuterRadius() {
            this.outerRadius_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public final SafetyCylinderParams setOuterRadius(float f) {
            this.bitField0_ |= 4;
            this.outerRadius_ = f;
            return this;
        }

        public final float getEnterEventRadius() {
            return this.enterEventRadius_;
        }

        public final boolean hasEnterEventRadius() {
            return (this.bitField0_ & 8) != 0;
        }

        public final SafetyCylinderParams clearEnterEventRadius() {
            this.enterEventRadius_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        public final SafetyCylinderParams setEnterEventRadius(float f) {
            this.bitField0_ |= 8;
            this.enterEventRadius_ = f;
            return this;
        }

        public final float getExitEventRadius() {
            return this.exitEventRadius_;
        }

        public final boolean hasExitEventRadius() {
            return (this.bitField0_ & 0x10) != 0;
        }

        public final SafetyCylinderParams clearExitEventRadius() {
            this.exitEventRadius_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFEF;
            return this;
        }

        public final SafetyCylinderParams setExitEventRadius(float f) {
            this.bitField0_ |= 0x10;
            this.exitEventRadius_ = f;
            return this;
        }

        public final float getAnchorWarningDistance() {
            return this.anchorWarningDistance_;
        }

        public final boolean hasAnchorWarningDistance() {
            return (this.bitField0_ & 0x20) != 0;
        }

        public final SafetyCylinderParams clearAnchorWarningDistance() {
            this.anchorWarningDistance_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFDF;
            return this;
        }

        public final SafetyCylinderParams setAnchorWarningDistance(float f) {
            this.bitField0_ |= 0x20;
            this.anchorWarningDistance_ = f;
            return this;
        }

        public final boolean getGraphicsEnabled() {
            return this.graphicsEnabled_;
        }

        public final boolean hasGraphicsEnabled() {
            return (this.bitField0_ & 0x40) != 0;
        }

        public final SafetyCylinderParams clearGraphicsEnabled() {
            this.graphicsEnabled_ = true;
            this.bitField0_ &= 0xFFFFFFBF;
            return this;
        }

        public final SafetyCylinderParams setGraphicsEnabled(boolean bl) {
            this.bitField0_ |= 0x40;
            this.graphicsEnabled_ = bl;
            return this;
        }

        public SafetyCylinderParams() {
            this.clear();
        }

        public final SafetyCylinderParams clear() {
            this.bitField0_ = 0;
            this.collisionSphereRadius_ = 0.0f;
            this.innerRadius_ = 0.0f;
            this.outerRadius_ = 0.0f;
            this.innerFogColor = WireFormatNano.EMPTY_FLOAT_ARRAY;
            this.outerFogColor = WireFormatNano.EMPTY_FLOAT_ARRAY;
            this.enterEventRadius_ = 0.0f;
            this.exitEventRadius_ = 0.0f;
            this.anchorWarningDistance_ = 0.0f;
            this.graphicsEnabled_ = true;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final SafetyCylinderParams clone() {
            SafetyCylinderParams safetyCylinderParams;
            try {
                safetyCylinderParams = (SafetyCylinderParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.innerFogColor != null && this.innerFogColor.length > 0) {
                safetyCylinderParams.innerFogColor = (float[])this.innerFogColor.clone();
            }
            if (this.outerFogColor != null && this.outerFogColor.length > 0) {
                safetyCylinderParams.outerFogColor = (float[])this.outerFogColor.clone();
            }
            return safetyCylinderParams;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            int n;
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeFloat(1, this.collisionSphereRadius_);
            }
            if ((this.bitField0_ & 2) != 0) {
                codedOutputByteBufferNano.writeFloat(2, this.innerRadius_);
            }
            if ((this.bitField0_ & 4) != 0) {
                codedOutputByteBufferNano.writeFloat(3, this.outerRadius_);
            }
            if (this.innerFogColor != null && this.innerFogColor.length > 0) {
                for (n = 0; n < this.innerFogColor.length; ++n) {
                    codedOutputByteBufferNano.writeFloat(4, this.innerFogColor[n]);
                }
            }
            if (this.outerFogColor != null && this.outerFogColor.length > 0) {
                for (n = 0; n < this.outerFogColor.length; ++n) {
                    codedOutputByteBufferNano.writeFloat(5, this.outerFogColor[n]);
                }
            }
            if ((this.bitField0_ & 8) != 0) {
                codedOutputByteBufferNano.writeFloat(6, this.enterEventRadius_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                codedOutputByteBufferNano.writeFloat(7, this.exitEventRadius_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                codedOutputByteBufferNano.writeFloat(8, this.anchorWarningDistance_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                codedOutputByteBufferNano.writeBool(9, this.graphicsEnabled_);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n;
            int n2 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n2 += CodedOutputByteBufferNano.computeFloatSize((int)1, (float)this.collisionSphereRadius_);
            }
            if ((this.bitField0_ & 2) != 0) {
                n2 += CodedOutputByteBufferNano.computeFloatSize((int)2, (float)this.innerRadius_);
            }
            if ((this.bitField0_ & 4) != 0) {
                n2 += CodedOutputByteBufferNano.computeFloatSize((int)3, (float)this.outerRadius_);
            }
            if (this.innerFogColor != null && this.innerFogColor.length > 0) {
                n = 4 * this.innerFogColor.length;
                n2 += n;
                n2 += 1 * this.innerFogColor.length;
            }
            if (this.outerFogColor != null && this.outerFogColor.length > 0) {
                n = 4 * this.outerFogColor.length;
                n2 += n;
                n2 += 1 * this.outerFogColor.length;
            }
            if ((this.bitField0_ & 8) != 0) {
                n2 += CodedOutputByteBufferNano.computeFloatSize((int)6, (float)this.enterEventRadius_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                n2 += CodedOutputByteBufferNano.computeFloatSize((int)7, (float)this.exitEventRadius_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                n2 += CodedOutputByteBufferNano.computeFloatSize((int)8, (float)this.anchorWarningDistance_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                n2 += CodedOutputByteBufferNano.computeBoolSize((int)9, (boolean)this.graphicsEnabled_);
            }
            return n2;
        }

        public final SafetyCylinderParams mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block14: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block14;
                        return this;
                    }
                    case 13: {
                        this.collisionSphereRadius_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 1;
                        continue block14;
                    }
                    case 21: {
                        this.innerRadius_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 2;
                        continue block14;
                    }
                    case 29: {
                        this.outerRadius_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 4;
                        continue block14;
                    }
                    case 37: {
                        int n2 = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)codedInputByteBufferNano, (int)37);
                        int n3 = this.innerFogColor == null ? 0 : this.innerFogColor.length;
                        float[] fArray = new float[n3 + n2];
                        if (n3 != 0) {
                            System.arraycopy(this.innerFogColor, 0, fArray, 0, n3);
                        }
                        while (n3 < fArray.length - 1) {
                            fArray[n3] = codedInputByteBufferNano.readFloat();
                            codedInputByteBufferNano.readTag();
                            ++n3;
                        }
                        fArray[n3] = codedInputByteBufferNano.readFloat();
                        this.innerFogColor = fArray;
                        continue block14;
                    }
                    case 34: {
                        int n2 = codedInputByteBufferNano.readRawVarint32();
                        int n3 = codedInputByteBufferNano.pushLimit(n2);
                        int n4 = n2 / 4;
                        int n5 = this.innerFogColor == null ? 0 : this.innerFogColor.length;
                        float[] fArray = new float[n5 + n4];
                        if (n5 != 0) {
                            System.arraycopy(this.innerFogColor, 0, fArray, 0, n5);
                        }
                        while (n5 < fArray.length) {
                            fArray[n5] = codedInputByteBufferNano.readFloat();
                            ++n5;
                        }
                        this.innerFogColor = fArray;
                        codedInputByteBufferNano.popLimit(n3);
                        continue block14;
                    }
                    case 45: {
                        int n2 = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)codedInputByteBufferNano, (int)45);
                        int n3 = this.outerFogColor == null ? 0 : this.outerFogColor.length;
                        float[] fArray = new float[n3 + n2];
                        if (n3 != 0) {
                            System.arraycopy(this.outerFogColor, 0, fArray, 0, n3);
                        }
                        while (n3 < fArray.length - 1) {
                            fArray[n3] = codedInputByteBufferNano.readFloat();
                            codedInputByteBufferNano.readTag();
                            ++n3;
                        }
                        fArray[n3] = codedInputByteBufferNano.readFloat();
                        this.outerFogColor = fArray;
                        continue block14;
                    }
                    case 42: {
                        int n2 = codedInputByteBufferNano.readRawVarint32();
                        int n3 = codedInputByteBufferNano.pushLimit(n2);
                        int n6 = n2 / 4;
                        int n5 = this.outerFogColor == null ? 0 : this.outerFogColor.length;
                        float[] fArray = new float[n5 + n6];
                        if (n5 != 0) {
                            System.arraycopy(this.outerFogColor, 0, fArray, 0, n5);
                        }
                        while (n5 < fArray.length) {
                            fArray[n5] = codedInputByteBufferNano.readFloat();
                            ++n5;
                        }
                        this.outerFogColor = fArray;
                        codedInputByteBufferNano.popLimit(n3);
                        continue block14;
                    }
                    case 53: {
                        this.enterEventRadius_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 8;
                        continue block14;
                    }
                    case 61: {
                        this.exitEventRadius_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 0x10;
                        continue block14;
                    }
                    case 69: {
                        this.anchorWarningDistance_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 0x20;
                        continue block14;
                    }
                    case 72: 
                }
                this.graphicsEnabled_ = codedInputByteBufferNano.readBool();
                this.bitField0_ |= 0x40;
            }
        }

        public static SafetyCylinderParams parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (SafetyCylinderParams)MessageNano.mergeFrom((MessageNano)new SafetyCylinderParams(), (byte[])byArray);
        }

        public static SafetyCylinderParams parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new SafetyCylinderParams().mergeFrom(codedInputByteBufferNano);
        }
    }

    public static final class DeveloperPrefs
    extends ExtendableMessageNano<DeveloperPrefs>
    implements Cloneable {
        private static volatile DeveloperPrefs[] _emptyArray;
        private int bitField0_;
        private boolean performanceMonitoringEnabled_;
        private boolean sensorLoggingEnabled_;
        private boolean dEPRECATEDMotophoPatchEnabled_;
        private boolean developerLoggingEnabled_;
        private boolean forceUndistortedRendering_;
        private boolean performanceHudEnabled_;
        private boolean dEPRECATEDGvrPlatformLibraryEnabled_;
        private boolean dEPRECATEDHeadTrackingServiceEnabled_;
        private boolean captureEnabled_;
        public SafetyCylinderParams safetyCylinderParams;
        private boolean frameTrackerEnabled_;
        private int motophoPatchMode_;
        private boolean performanceLoggingActivated_;
        private boolean openglKhrDebugEnabled_;
        public TrackingConfigurationParams trackingConfigurationParams;

        @NanoEnumValue(value=MotophoPatchMode.class, legacy=false)
        public static int checkMotophoPatchModeOrThrow(int n) {
            if (n >= 0 && n <= 2) {
                return n;
            }
            throw new IllegalArgumentException(new StringBuilder(48).append(n).append(" is not a valid enum MotophoPatchMode").toString());
        }

        @NanoEnumValue(value=MotophoPatchMode.class, legacy=false)
        public static int[] checkMotophoPatchModeOrThrow(int[] nArray) {
            int[] nArray2;
            int[] nArray3 = nArray2 = (int[])nArray.clone();
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray3[i];
                DeveloperPrefs.checkMotophoPatchModeOrThrow(n2);
            }
            return nArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DeveloperPrefs[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DeveloperPrefs[0];
                    }
                }
            }
            return _emptyArray;
        }

        public final boolean getPerformanceMonitoringEnabled() {
            return this.performanceMonitoringEnabled_;
        }

        public final boolean hasPerformanceMonitoringEnabled() {
            return (this.bitField0_ & 1) != 0;
        }

        public final DeveloperPrefs clearPerformanceMonitoringEnabled() {
            this.performanceMonitoringEnabled_ = false;
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public final DeveloperPrefs setPerformanceMonitoringEnabled(boolean bl) {
            this.bitField0_ |= 1;
            this.performanceMonitoringEnabled_ = bl;
            return this;
        }

        public final boolean getSensorLoggingEnabled() {
            return this.sensorLoggingEnabled_;
        }

        public final boolean hasSensorLoggingEnabled() {
            return (this.bitField0_ & 2) != 0;
        }

        public final DeveloperPrefs clearSensorLoggingEnabled() {
            this.sensorLoggingEnabled_ = false;
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public final DeveloperPrefs setSensorLoggingEnabled(boolean bl) {
            this.bitField0_ |= 2;
            this.sensorLoggingEnabled_ = bl;
            return this;
        }

        public final boolean getDEPRECATEDMotophoPatchEnabled() {
            return this.dEPRECATEDMotophoPatchEnabled_;
        }

        public final boolean hasDEPRECATEDMotophoPatchEnabled() {
            return (this.bitField0_ & 4) != 0;
        }

        public final DeveloperPrefs clearDEPRECATEDMotophoPatchEnabled() {
            this.dEPRECATEDMotophoPatchEnabled_ = false;
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public final DeveloperPrefs setDEPRECATEDMotophoPatchEnabled(boolean bl) {
            this.bitField0_ |= 4;
            this.dEPRECATEDMotophoPatchEnabled_ = bl;
            return this;
        }

        public final boolean getDeveloperLoggingEnabled() {
            return this.developerLoggingEnabled_;
        }

        public final boolean hasDeveloperLoggingEnabled() {
            return (this.bitField0_ & 8) != 0;
        }

        public final DeveloperPrefs clearDeveloperLoggingEnabled() {
            this.developerLoggingEnabled_ = false;
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        public final DeveloperPrefs setDeveloperLoggingEnabled(boolean bl) {
            this.bitField0_ |= 8;
            this.developerLoggingEnabled_ = bl;
            return this;
        }

        public final boolean getForceUndistortedRendering() {
            return this.forceUndistortedRendering_;
        }

        public final boolean hasForceUndistortedRendering() {
            return (this.bitField0_ & 0x10) != 0;
        }

        public final DeveloperPrefs clearForceUndistortedRendering() {
            this.forceUndistortedRendering_ = false;
            this.bitField0_ &= 0xFFFFFFEF;
            return this;
        }

        public final DeveloperPrefs setForceUndistortedRendering(boolean bl) {
            this.bitField0_ |= 0x10;
            this.forceUndistortedRendering_ = bl;
            return this;
        }

        public final boolean getPerformanceHudEnabled() {
            return this.performanceHudEnabled_;
        }

        public final boolean hasPerformanceHudEnabled() {
            return (this.bitField0_ & 0x20) != 0;
        }

        public final DeveloperPrefs clearPerformanceHudEnabled() {
            this.performanceHudEnabled_ = false;
            this.bitField0_ &= 0xFFFFFFDF;
            return this;
        }

        public final DeveloperPrefs setPerformanceHudEnabled(boolean bl) {
            this.bitField0_ |= 0x20;
            this.performanceHudEnabled_ = bl;
            return this;
        }

        public final boolean getDEPRECATEDGvrPlatformLibraryEnabled() {
            return this.dEPRECATEDGvrPlatformLibraryEnabled_;
        }

        public final boolean hasDEPRECATEDGvrPlatformLibraryEnabled() {
            return (this.bitField0_ & 0x40) != 0;
        }

        public final DeveloperPrefs clearDEPRECATEDGvrPlatformLibraryEnabled() {
            this.dEPRECATEDGvrPlatformLibraryEnabled_ = false;
            this.bitField0_ &= 0xFFFFFFBF;
            return this;
        }

        public final DeveloperPrefs setDEPRECATEDGvrPlatformLibraryEnabled(boolean bl) {
            this.bitField0_ |= 0x40;
            this.dEPRECATEDGvrPlatformLibraryEnabled_ = bl;
            return this;
        }

        public final boolean getDEPRECATEDHeadTrackingServiceEnabled() {
            return this.dEPRECATEDHeadTrackingServiceEnabled_;
        }

        public final boolean hasDEPRECATEDHeadTrackingServiceEnabled() {
            return (this.bitField0_ & 0x80) != 0;
        }

        public final DeveloperPrefs clearDEPRECATEDHeadTrackingServiceEnabled() {
            this.dEPRECATEDHeadTrackingServiceEnabled_ = false;
            this.bitField0_ &= 0xFFFFFF7F;
            return this;
        }

        public final DeveloperPrefs setDEPRECATEDHeadTrackingServiceEnabled(boolean bl) {
            this.bitField0_ |= 0x80;
            this.dEPRECATEDHeadTrackingServiceEnabled_ = bl;
            return this;
        }

        public final boolean getCaptureEnabled() {
            return this.captureEnabled_;
        }

        public final boolean hasCaptureEnabled() {
            return (this.bitField0_ & 0x100) != 0;
        }

        public final DeveloperPrefs clearCaptureEnabled() {
            this.captureEnabled_ = false;
            this.bitField0_ &= 0xFFFFFEFF;
            return this;
        }

        public final DeveloperPrefs setCaptureEnabled(boolean bl) {
            this.bitField0_ |= 0x100;
            this.captureEnabled_ = bl;
            return this;
        }

        public final boolean getFrameTrackerEnabled() {
            return this.frameTrackerEnabled_;
        }

        public final boolean hasFrameTrackerEnabled() {
            return (this.bitField0_ & 0x200) != 0;
        }

        public final DeveloperPrefs clearFrameTrackerEnabled() {
            this.frameTrackerEnabled_ = false;
            this.bitField0_ &= 0xFFFFFDFF;
            return this;
        }

        public final DeveloperPrefs setFrameTrackerEnabled(boolean bl) {
            this.bitField0_ |= 0x200;
            this.frameTrackerEnabled_ = bl;
            return this;
        }

        @NanoEnumValue(value=MotophoPatchMode.class, legacy=false)
        public final int getMotophoPatchMode() {
            return this.motophoPatchMode_;
        }

        public final DeveloperPrefs setMotophoPatchMode(@NanoEnumValue(value=MotophoPatchMode.class, legacy=false) int n) {
            this.motophoPatchMode_ = n;
            this.bitField0_ |= 0x400;
            return this;
        }

        public final boolean hasMotophoPatchMode() {
            return (this.bitField0_ & 0x400) != 0;
        }

        public final DeveloperPrefs clearMotophoPatchMode() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.motophoPatchMode_ = 0;
            return this;
        }

        public final boolean getPerformanceLoggingActivated() {
            return this.performanceLoggingActivated_;
        }

        public final boolean hasPerformanceLoggingActivated() {
            return (this.bitField0_ & 0x800) != 0;
        }

        public final DeveloperPrefs clearPerformanceLoggingActivated() {
            this.performanceLoggingActivated_ = false;
            this.bitField0_ &= 0xFFFFF7FF;
            return this;
        }

        public final DeveloperPrefs setPerformanceLoggingActivated(boolean bl) {
            this.bitField0_ |= 0x800;
            this.performanceLoggingActivated_ = bl;
            return this;
        }

        public final boolean getOpenglKhrDebugEnabled() {
            return this.openglKhrDebugEnabled_;
        }

        public final boolean hasOpenglKhrDebugEnabled() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        public final DeveloperPrefs clearOpenglKhrDebugEnabled() {
            this.openglKhrDebugEnabled_ = false;
            this.bitField0_ &= 0xFFFFEFFF;
            return this;
        }

        public final DeveloperPrefs setOpenglKhrDebugEnabled(boolean bl) {
            this.bitField0_ |= 0x1000;
            this.openglKhrDebugEnabled_ = bl;
            return this;
        }

        public DeveloperPrefs() {
            this.clear();
        }

        public final DeveloperPrefs clear() {
            this.bitField0_ = 0;
            this.performanceMonitoringEnabled_ = false;
            this.sensorLoggingEnabled_ = false;
            this.dEPRECATEDMotophoPatchEnabled_ = false;
            this.developerLoggingEnabled_ = false;
            this.forceUndistortedRendering_ = false;
            this.performanceHudEnabled_ = false;
            this.dEPRECATEDGvrPlatformLibraryEnabled_ = false;
            this.dEPRECATEDHeadTrackingServiceEnabled_ = false;
            this.captureEnabled_ = false;
            this.safetyCylinderParams = null;
            this.frameTrackerEnabled_ = false;
            this.motophoPatchMode_ = 0;
            this.performanceLoggingActivated_ = false;
            this.openglKhrDebugEnabled_ = false;
            this.trackingConfigurationParams = null;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final DeveloperPrefs clone() {
            DeveloperPrefs developerPrefs;
            try {
                developerPrefs = (DeveloperPrefs)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.safetyCylinderParams != null) {
                developerPrefs.safetyCylinderParams = this.safetyCylinderParams.clone();
            }
            if (this.trackingConfigurationParams != null) {
                developerPrefs.trackingConfigurationParams = this.trackingConfigurationParams.clone();
            }
            return developerPrefs;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeBool(1, this.performanceMonitoringEnabled_);
            }
            if ((this.bitField0_ & 2) != 0) {
                codedOutputByteBufferNano.writeBool(2, this.sensorLoggingEnabled_);
            }
            if ((this.bitField0_ & 4) != 0) {
                codedOutputByteBufferNano.writeBool(3, this.dEPRECATEDMotophoPatchEnabled_);
            }
            if ((this.bitField0_ & 8) != 0) {
                codedOutputByteBufferNano.writeBool(4, this.developerLoggingEnabled_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                codedOutputByteBufferNano.writeBool(5, this.forceUndistortedRendering_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                codedOutputByteBufferNano.writeBool(6, this.performanceHudEnabled_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                codedOutputByteBufferNano.writeBool(7, this.dEPRECATEDGvrPlatformLibraryEnabled_);
            }
            if ((this.bitField0_ & 0x80) != 0) {
                codedOutputByteBufferNano.writeBool(8, this.dEPRECATEDHeadTrackingServiceEnabled_);
            }
            if ((this.bitField0_ & 0x100) != 0) {
                codedOutputByteBufferNano.writeBool(9, this.captureEnabled_);
            }
            if (this.safetyCylinderParams != null) {
                codedOutputByteBufferNano.writeMessage(10, (MessageNano)this.safetyCylinderParams);
            }
            if ((this.bitField0_ & 0x200) != 0) {
                codedOutputByteBufferNano.writeBool(11, this.frameTrackerEnabled_);
            }
            if ((this.bitField0_ & 0x400) != 0) {
                codedOutputByteBufferNano.writeInt32(12, this.motophoPatchMode_);
            }
            if ((this.bitField0_ & 0x800) != 0) {
                codedOutputByteBufferNano.writeBool(13, this.performanceLoggingActivated_);
            }
            if ((this.bitField0_ & 0x1000) != 0) {
                codedOutputByteBufferNano.writeBool(14, this.openglKhrDebugEnabled_);
            }
            if (this.trackingConfigurationParams != null) {
                codedOutputByteBufferNano.writeMessage(15, (MessageNano)this.trackingConfigurationParams);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)1, (boolean)this.performanceMonitoringEnabled_);
            }
            if ((this.bitField0_ & 2) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)2, (boolean)this.sensorLoggingEnabled_);
            }
            if ((this.bitField0_ & 4) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)3, (boolean)this.dEPRECATEDMotophoPatchEnabled_);
            }
            if ((this.bitField0_ & 8) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)4, (boolean)this.developerLoggingEnabled_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)5, (boolean)this.forceUndistortedRendering_);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)6, (boolean)this.performanceHudEnabled_);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)7, (boolean)this.dEPRECATEDGvrPlatformLibraryEnabled_);
            }
            if ((this.bitField0_ & 0x80) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)8, (boolean)this.dEPRECATEDHeadTrackingServiceEnabled_);
            }
            if ((this.bitField0_ & 0x100) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)9, (boolean)this.captureEnabled_);
            }
            if (this.safetyCylinderParams != null) {
                n += CodedOutputByteBufferNano.computeMessageSize((int)10, (MessageNano)this.safetyCylinderParams);
            }
            if ((this.bitField0_ & 0x200) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)11, (boolean)this.frameTrackerEnabled_);
            }
            if ((this.bitField0_ & 0x400) != 0) {
                n += CodedOutputByteBufferNano.computeInt32Size((int)12, (int)this.motophoPatchMode_);
            }
            if ((this.bitField0_ & 0x800) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)13, (boolean)this.performanceLoggingActivated_);
            }
            if ((this.bitField0_ & 0x1000) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)14, (boolean)this.openglKhrDebugEnabled_);
            }
            if (this.trackingConfigurationParams != null) {
                n += CodedOutputByteBufferNano.computeMessageSize((int)15, (MessageNano)this.trackingConfigurationParams);
            }
            return n;
        }

        public final DeveloperPrefs mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block20: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block20;
                        return this;
                    }
                    case 8: {
                        this.performanceMonitoringEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 1;
                        continue block20;
                    }
                    case 16: {
                        this.sensorLoggingEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 2;
                        continue block20;
                    }
                    case 24: {
                        this.dEPRECATEDMotophoPatchEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 4;
                        continue block20;
                    }
                    case 32: {
                        this.developerLoggingEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 8;
                        continue block20;
                    }
                    case 40: {
                        this.forceUndistortedRendering_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 0x10;
                        continue block20;
                    }
                    case 48: {
                        this.performanceHudEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 0x20;
                        continue block20;
                    }
                    case 56: {
                        this.dEPRECATEDGvrPlatformLibraryEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 0x40;
                        continue block20;
                    }
                    case 64: {
                        this.dEPRECATEDHeadTrackingServiceEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 0x80;
                        continue block20;
                    }
                    case 72: {
                        this.captureEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 0x100;
                        continue block20;
                    }
                    case 82: {
                        if (this.safetyCylinderParams == null) {
                            this.safetyCylinderParams = new SafetyCylinderParams();
                        }
                        codedInputByteBufferNano.readMessage((MessageNano)this.safetyCylinderParams);
                        continue block20;
                    }
                    case 88: {
                        this.frameTrackerEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 0x200;
                        continue block20;
                    }
                    case 96: {
                        this.bitField0_ |= 0x400;
                        int n2 = codedInputByteBufferNano.getPosition();
                        try {
                            this.motophoPatchMode_ = DeveloperPrefs.checkMotophoPatchModeOrThrow(codedInputByteBufferNano.readInt32());
                            this.bitField0_ |= 0x400;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            codedInputByteBufferNano.rewindToPosition(n2);
                            this.storeUnknownField(codedInputByteBufferNano, n);
                        }
                        continue block20;
                    }
                    case 104: {
                        this.performanceLoggingActivated_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 0x800;
                        continue block20;
                    }
                    case 112: {
                        this.openglKhrDebugEnabled_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 0x1000;
                        continue block20;
                    }
                    case 122: 
                }
                if (this.trackingConfigurationParams == null) {
                    this.trackingConfigurationParams = new TrackingConfigurationParams();
                }
                codedInputByteBufferNano.readMessage((MessageNano)this.trackingConfigurationParams);
            }
        }

        public static DeveloperPrefs parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (DeveloperPrefs)MessageNano.mergeFrom((MessageNano)new DeveloperPrefs(), (byte[])byArray);
        }

        public static DeveloperPrefs parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new DeveloperPrefs().mergeFrom(codedInputByteBufferNano);
        }

        public static interface MotophoPatchMode {
            @NanoEnumValue(value=MotophoPatchMode.class, legacy=false)
            public static final int NONE = 0;
            @NanoEnumValue(value=MotophoPatchMode.class, legacy=false)
            public static final int VELOCITY = 1;
            @NanoEnumValue(value=MotophoPatchMode.class, legacy=false)
            public static final int IMPULSE = 2;
        }
    }

    public static final class UserPrefs
    extends ExtendableMessageNano<UserPrefs>
    implements Cloneable {
        private static volatile UserPrefs[] _emptyArray;
        private int bitField0_;
        private int controllerHandedness_;
        public DeveloperPrefs developerPrefs;

        @NanoEnumValue(value=Handedness.class, legacy=false)
        public static int checkHandednessOrThrow(int n) {
            if (n >= 0 && n <= 1) {
                return n;
            }
            throw new IllegalArgumentException(new StringBuilder(42).append(n).append(" is not a valid enum Handedness").toString());
        }

        @NanoEnumValue(value=Handedness.class, legacy=false)
        public static int[] checkHandednessOrThrow(int[] nArray) {
            int[] nArray2;
            int[] nArray3 = nArray2 = (int[])nArray.clone();
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray3[i];
                UserPrefs.checkHandednessOrThrow(n2);
            }
            return nArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static UserPrefs[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new UserPrefs[0];
                    }
                }
            }
            return _emptyArray;
        }

        @NanoEnumValue(value=Handedness.class, legacy=false)
        public final int getControllerHandedness() {
            return this.controllerHandedness_;
        }

        public final UserPrefs setControllerHandedness(@NanoEnumValue(value=Handedness.class, legacy=false) int n) {
            this.controllerHandedness_ = n;
            this.bitField0_ |= 1;
            return this;
        }

        public final boolean hasControllerHandedness() {
            return (this.bitField0_ & 1) != 0;
        }

        public final UserPrefs clearControllerHandedness() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.controllerHandedness_ = 0;
            return this;
        }

        public UserPrefs() {
            this.clear();
        }

        public final UserPrefs clear() {
            this.bitField0_ = 0;
            this.controllerHandedness_ = 0;
            this.developerPrefs = null;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final UserPrefs clone() {
            UserPrefs userPrefs;
            try {
                userPrefs = (UserPrefs)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.developerPrefs != null) {
                userPrefs.developerPrefs = this.developerPrefs.clone();
            }
            return userPrefs;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeInt32(1, this.controllerHandedness_);
            }
            if (this.developerPrefs != null) {
                codedOutputByteBufferNano.writeMessage(2, (MessageNano)this.developerPrefs);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n += CodedOutputByteBufferNano.computeInt32Size((int)1, (int)this.controllerHandedness_);
            }
            if (this.developerPrefs != null) {
                n += CodedOutputByteBufferNano.computeMessageSize((int)2, (MessageNano)this.developerPrefs);
            }
            return n;
        }

        public final UserPrefs mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block7: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block7;
                        return this;
                    }
                    case 8: {
                        this.bitField0_ |= 1;
                        int n2 = codedInputByteBufferNano.getPosition();
                        try {
                            this.controllerHandedness_ = UserPrefs.checkHandednessOrThrow(codedInputByteBufferNano.readInt32());
                            this.bitField0_ |= 1;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            codedInputByteBufferNano.rewindToPosition(n2);
                            this.storeUnknownField(codedInputByteBufferNano, n);
                        }
                        continue block7;
                    }
                    case 18: 
                }
                if (this.developerPrefs == null) {
                    this.developerPrefs = new DeveloperPrefs();
                }
                codedInputByteBufferNano.readMessage((MessageNano)this.developerPrefs);
            }
        }

        public static UserPrefs parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (UserPrefs)MessageNano.mergeFrom((MessageNano)new UserPrefs(), (byte[])byArray);
        }

        public static UserPrefs parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new UserPrefs().mergeFrom(codedInputByteBufferNano);
        }

        public static interface Handedness {
            @NanoEnumValue(value=Handedness.class, legacy=false)
            public static final int RIGHT_HANDED = 0;
            @NanoEnumValue(value=Handedness.class, legacy=false)
            public static final int LEFT_HANDED = 1;
        }
    }

    public static interface ControllerConfigurationType {
        @NanoEnumValue(value=ControllerConfigurationType.class, legacy=false)
        public static final int GVR_CONTROLLER_CONFIGURATION_UNKNOWN = 0;
        @NanoEnumValue(value=ControllerConfigurationType.class, legacy=false)
        public static final int GVR_CONTROLLER_CONFIGURATION_UNSUPPORTED = 1;
        @NanoEnumValue(value=ControllerConfigurationType.class, legacy=false)
        public static final int GVR_CONTROLLER_CONFIGURATION_3DOF_1 = 2;
        @NanoEnumValue(value=ControllerConfigurationType.class, legacy=false)
        public static final int GVR_CONTROLLER_CONFIGURATION_6DOF_2 = 3;
    }
}

