/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import android.os.AsyncTask;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import com.google.common.logging.nano.Vr;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.ndk.base.AbstractDaydreamTouchListener;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayoutImpl;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import com.google.vr.sdk.proto.nano.Display;
import com.google.vr.vrcore.logging.api.VREventParcelable;

class SdkDaydreamTouchListener
extends AbstractDaydreamTouchListener
implements View.OnTouchListener {
    static final String TAG = "SdkDaydreamTouchListener";
    private final VrParamsProvider vrParamsProvider;
    private final GvrLayoutImpl gvrLayout;
    private final GvrApi gvrApi;
    private final boolean isDaydreamImageAlignmentEnabled;

    public SdkDaydreamTouchListener(GvrLayoutImpl gvrLayoutImpl) {
        this.gvrLayout = gvrLayoutImpl;
        this.gvrApi = gvrLayoutImpl.getGvrApi();
        this.isDaydreamImageAlignmentEnabled = this.gvrApi.getSdkConfigurationParams().daydreamImageAlignment != 1 && this.gvrApi.getSdkConfigurationParams().touchOverlayEnabled == false;
        Context context = gvrLayoutImpl.getContext();
        this.vrParamsProvider = VrParamsProviderFactory.create(context);
        FinishInitializationTask finishInitializationTask = new FinishInitializationTask();
        new FinishInitializationTask().display = DisplayUtils.getDefaultDisplay(context);
        finishInitializationTask.execute(new Void[0]);
    }

    SdkDaydreamTouchListener(VrParamsProvider vrParamsProvider, DisplayMetrics displayMetrics, Display.DisplayParams displayParams, GvrApi gvrApi, GvrLayoutImpl gvrLayoutImpl, boolean bl) {
        this.isDaydreamImageAlignmentEnabled = bl;
        this.vrParamsProvider = vrParamsProvider;
        this.gvrApi = gvrApi;
        this.gvrLayout = gvrLayoutImpl;
        this.init(displayMetrics, displayParams);
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        return this.handleTouch(motionEvent, 0.0f, 0.0f);
    }

    public void refreshViewerProfile() {
        new RefreshViewerProfileTask().execute(new Void[0]);
    }

    public void shutdown() {
        this.vrParamsProvider.close();
    }

    private void init(DisplayMetrics displayMetrics, Display.DisplayParams displayParams) {
        this.initWithDisplayParams(displayMetrics, displayParams);
        this.refreshViewerProfile();
    }

    @Override
    protected boolean isDaydreamImageAlignmentEnabled() {
        return this.isDaydreamImageAlignmentEnabled;
    }

    @Override
    protected void setLensOffset(float f, float f2, float f3) {
        this.gvrApi.setLensOffset(f, f2, 0.0f);
    }

    @Override
    protected void logEvent(int n, Vr.VREvent vREvent) {
        if (this.gvrLayout.getVrCoreSdkClient() != null && this.gvrLayout.getVrCoreSdkClient().getLoggingService() != null) {
            VREventParcelable vREventParcelable = new VREventParcelable(2012, vREvent);
            try {
                this.gvrLayout.getVrCoreSdkClient().getLoggingService().log(vREventParcelable);
            }
            catch (RemoteException remoteException) {
                Log.w((String)TAG, (String)"Unable to log alignment event");
                return;
            }
        } else {
            Log.w((String)TAG, (String)"Unable to log alignment event; logging service not available.");
        }
    }

    private class FinishInitializationTask
    extends AsyncTask<Void, Void, Display.DisplayParams> {
        public Display display;

        private FinishInitializationTask() {
        }

        protected Display.DisplayParams doInBackground(Void ... voidArray) {
            return SdkDaydreamTouchListener.this.vrParamsProvider.readDisplayParams();
        }

        protected void onProgressUpdate(Void ... voidArray) {
        }

        protected void onPostExecute(Display.DisplayParams displayParams) {
            DisplayMetrics displayMetrics = DisplayUtils.getDisplayMetricsLandscapeWithOverride(this.display, displayParams);
            SdkDaydreamTouchListener.this.init(displayMetrics, displayParams);
        }
    }

    private class RefreshViewerProfileTask
    extends AsyncTask<Void, Void, CardboardDevice.DeviceParams> {
        private RefreshViewerProfileTask() {
        }

        protected CardboardDevice.DeviceParams doInBackground(Void ... voidArray) {
            return SdkDaydreamTouchListener.this.vrParamsProvider.readDeviceParams();
        }

        protected void onProgressUpdate(Void ... voidArray) {
        }

        protected void onPostExecute(CardboardDevice.DeviceParams deviceParams) {
            SdkDaydreamTouchListener.this.setDeviceParams(deviceParams);
        }
    }
}

