/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.TextUtils;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.ndk.base.DaydreamApi;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@TargetApi(value=24)
public class HeadsetSelector {
    private static final String TAG = "HeadsetSelector";

    public HeadsetSelector() {
    }

    public static List<String> getRecentHeadsetModels(Context context) {
        CardboardDevice.DeviceParamsList deviceParamsList = DaydreamApi.getRecentHeadsets(context);
        if (deviceParamsList == null || deviceParamsList.params.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(deviceParamsList.params.length);
        CardboardDevice.DeviceParams[] deviceParamsArray = deviceParamsList.params;
        int n = deviceParamsList.params.length;
        for (int i = 0; i < n; ++i) {
            CardboardDevice.DeviceParams deviceParams = deviceParamsArray[i];
            arrayList.add(deviceParams.getModel());
        }
        return arrayList;
    }

    public static String getCurrentHeadsetModel(Context context) {
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);){
            String string2 = null;
            CardboardDevice.DeviceParams deviceParams = vrParamsProvider.readDeviceParams();
            if (deviceParams != null) {
                string2 = deviceParams.getModel();
            }
            String string3 = string2;
            return string3;
        }
    }

    public static boolean selectHeadset(Context context, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        try (VrParamsProvider vrParamsProvider = VrParamsProviderFactory.create(context);){
            CardboardDevice.DeviceParamsList deviceParamsList = vrParamsProvider.readRecentHeadsets();
            if (deviceParamsList == null || deviceParamsList.params.length == 0) {
                return false;
            }
            CardboardDevice.DeviceParams[] deviceParamsArray = deviceParamsList.params;
            int n = deviceParamsList.params.length;
            for (int i = 0; i < n; ++i) {
                CardboardDevice.DeviceParams deviceParams = deviceParamsArray[i];
                if (!string2.equalsIgnoreCase(deviceParams.getModel())) continue;
                boolean bl = vrParamsProvider.writeDeviceParams(deviceParams);
                return bl;
            }
            vrParamsProvider.close();
            return false;
        }
    }
}

