/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import android.opengl.EGL14;
import android.opengl.EGLDisplay;
import android.opengl.GLDebugHelper;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.google.vr.cardboard.EglFactory;
import com.google.vr.cardboard.EglReadyListener;
import com.google.vr.cardboard.IsEmulator;
import com.google.vr.ndk.base.TraceCompat;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;

public class GvrSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback2 {
    private static final String TAG = "GvrSurfaceView";
    private static final boolean LOG_ATTACH_DETACH = false;
    private static final boolean LOG_THREADS = false;
    private static final boolean LOG_PAUSE_RESUME = false;
    private static final boolean LOG_SURFACE = false;
    private static final boolean LOG_RENDERER = false;
    private static final boolean LOG_RENDERER_DRAW_FRAME = false;
    private static final boolean LOG_EGL = false;
    private static final int GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR = 8;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;
    public static final int SWAPMODE_QUEUED = 0;
    public static final int SWAPMODE_SINGLE = 1;
    public static final int SWAPMODE_MANUAL = 2;
    public static final int DEBUG_CHECK_GL_ERROR = 1;
    public static final int DEBUG_LOG_GL_CALLS = 2;
    private final WeakReference<GvrSurfaceView> mThisWeakRef = new WeakReference<GvrSurfaceView>(this);
    private GLThread mGLThread;
    private GLSurfaceView.Renderer mRenderer;
    private boolean mDetached;
    private GLSurfaceView.EGLConfigChooser mEGLConfigChooser;
    private GLSurfaceView.EGLContextFactory mEGLContextFactory;
    private GLSurfaceView.EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLWrapper mGLWrapper;
    private int mDebugFlags;
    private int mEGLContextClientVersion;
    private boolean mPreserveEGLContextOnPause;
    private boolean mPreserveGlThreadOnDetachedFromWindow;
    private EglReadyListener mAppContextListener;

    public GvrSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public GvrSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    private void init() {
        SurfaceHolder surfaceHolder = this.getHolder();
        surfaceHolder.addCallback((SurfaceHolder.Callback)this);
    }

    public void setGLWrapper(GLWrapper gLWrapper) {
        this.mGLWrapper = gLWrapper;
    }

    public void setDebugFlags(int n) {
        this.mDebugFlags = n;
    }

    public int getDebugFlags() {
        return this.mDebugFlags;
    }

    public void setPreserveEGLContextOnPause(boolean bl) {
        this.mPreserveEGLContextOnPause = bl;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.mPreserveEGLContextOnPause;
    }

    public void setRenderer(GLSurfaceView.Renderer renderer) {
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            this.mEGLConfigChooser = new SimpleEGLConfigChooser(this, true);
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory();
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        this.mRenderer = renderer;
        this.mGLThread = new GLThread(this.mThisWeakRef);
        this.mGLThread.start();
    }

    public void setEglReadyListener(EglReadyListener eglReadyListener) {
        this.mAppContextListener = eglReadyListener;
    }

    public void setEGLContextFactory(GLSurfaceView.EGLContextFactory eGLContextFactory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = eGLContextFactory;
    }

    public void setEGLWindowSurfaceFactory(GLSurfaceView.EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = eGLWindowSurfaceFactory;
    }

    public void setEGLConfigChooser(GLSurfaceView.EGLConfigChooser eGLConfigChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = eGLConfigChooser;
    }

    public void setEGLConfigChooser(boolean bl) {
        this.setEGLConfigChooser(new SimpleEGLConfigChooser(this, bl));
    }

    public void setEGLConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setEGLConfigChooser(new ComponentSizeChooser(this, n, n2, n3, n4, n5, n6));
    }

    public void setEGLContextClientVersion(int n) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = n;
    }

    public void setRenderMode(int n) {
        this.mGLThread.setRenderMode(n);
    }

    public int getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    public void requestRender() {
        this.mGLThread.requestRender();
    }

    public void setSwapMode(int n) {
        if (n == 1 && (Build.VERSION.SDK_INT < 17 || IsEmulator.isEmulator())) {
            Log.e((String)TAG, (String)"setSwapMode(SWAPMODE_SINGLE) requires Jellybean MR1 (EGL14 dependency) and is not supported on emulators.");
            return;
        }
        this.mGLThread.setSwapMode(n);
    }

    public void setPreserveGlThreadOnDetachedFromWindow(boolean bl) {
        this.checkRenderThreadState();
        this.mPreserveGlThreadOnDetachedFromWindow = bl;
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mGLThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.onSurfaceDestroyed(null);
    }

    public void onSurfaceDestroyed(Runnable runnable) {
        this.mGLThread.surfaceDestroyed(runnable);
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        this.mGLThread.onWindowResize(n2, n3);
    }

    public void surfaceRedrawNeeded(SurfaceHolder surfaceHolder) {
        this.mGLThread.requestRenderAndWait();
    }

    public void onPause() {
        this.mGLThread.onPause(null);
    }

    public void onPause(Runnable runnable) {
        this.mGLThread.onPause(runnable);
    }

    public void onResume() {
        this.mGLThread.onResume();
    }

    public void queueEvent(Runnable runnable) {
        this.mGLThread.queueEvent(runnable);
    }

    public void requestExitAndWait() {
        this.mGLThread.requestExitAndWait();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDetached && this.mRenderer != null && !this.mPreserveGlThreadOnDetachedFromWindow) {
            int n = 1;
            int n2 = 0;
            if (this.mGLThread != null) {
                n = this.mGLThread.getRenderMode();
                n2 = this.mGLThread.getSwapMode();
            }
            this.mGLThread = new GLThread(this.mThisWeakRef);
            if (n != 1) {
                this.mGLThread.setRenderMode(n);
            }
            if (n2 != 0) {
                this.mGLThread.setSwapMode(n2);
            }
            this.mGLThread.start();
        }
        this.mDetached = false;
    }

    protected void onDetachedFromWindow() {
        if (this.mGLThread != null && !this.mPreserveGlThreadOnDetachedFromWindow) {
            this.requestExitAndWait();
        }
        this.mDetached = true;
        super.onDetachedFromWindow();
    }

    protected boolean isDetachedFromWindow() {
        return this.mDetached;
    }

    private void checkRenderThreadState() {
        if (this.mGLThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    static /* synthetic */ boolean access$900(GvrSurfaceView gvrSurfaceView) {
        return gvrSurfaceView.mPreserveEGLContextOnPause;
    }

    static /* synthetic */ GLSurfaceView.Renderer access$1000(GvrSurfaceView gvrSurfaceView) {
        return gvrSurfaceView.mRenderer;
    }

    static class LogWriter
    extends Writer {
        private StringBuilder mBuilder = new StringBuilder();

        LogWriter() {
        }

        @Override
        public void close() {
            this.flushBuilder();
        }

        @Override
        public void flush() {
            this.flushBuilder();
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            for (int i = 0; i < n2; ++i) {
                char c2 = cArray[n + i];
                if (c2 == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c2);
            }
        }

        private void flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Log.v((String)GvrSurfaceView.TAG, (String)this.mBuilder.toString());
                this.mBuilder.delete(0, this.mBuilder.length());
            }
        }
    }

    static class GLThread
    extends Thread
    implements EglReadyListener.EventListener {
        private boolean mShouldExit;
        private boolean mExited;
        private boolean mRequestPaused;
        private boolean mPaused;
        private boolean mHasSurface;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private boolean mFinishedCreatingEglSurface;
        private boolean mShouldReleaseEglContext;
        private int mWidth = 0;
        private int mHeight = 0;
        private int mRenderMode = 1;
        private int mRequestedSwapMode = 0;
        private boolean mRequestRender = true;
        private boolean mWantRenderNotification = false;
        private boolean mRenderComplete;
        private ArrayList<Runnable> mEventQueue = new ArrayList();
        private boolean mSizeChanged = true;
        private EglHelper mEglHelper;
        private WeakReference<GvrSurfaceView> mGvrSurfaceViewWeakRef;
        private final GLThreadManager mGLThreadManager = new GLThreadManager();

        GLThread(WeakReference<GvrSurfaceView> weakReference) {
            this.mGvrSurfaceViewWeakRef = weakReference;
            GvrSurfaceView gvrSurfaceView = (GvrSurfaceView)((Object)weakReference.get());
            if (gvrSurfaceView != null && gvrSurfaceView.mAppContextListener != null) {
                gvrSurfaceView.mAppContextListener.setEventListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEglReady() {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mEglHelper.renewPendingEglContext();
                this.mGLThreadManager.notifyAll();
                return;
            }
        }

        @Override
        public void run() {
            long l = this.getId();
            this.setName(new StringBuilder(29).append("GLThread ").append(l).toString());
            try {
                this.guardedRun();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                this.mGLThreadManager.threadExiting(this);
            }
        }

        private void stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        private void stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                this.mGLThreadManager.releaseEglContextLocked(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void guardedRun() throws InterruptedException {
            block65: {
                this.mEglHelper = new EglHelper(this.mGvrSurfaceViewWeakRef);
                this.mHaveEglContext = false;
                this.mHaveEglSurface = false;
                this.mWantRenderNotification = false;
                try {
                    var1_1 = null;
                    var2_2 = false;
                    var3_3 = false;
                    var4_4 = false;
                    var5_5 = false;
                    var6_6 = false;
                    var7_7 = false;
                    var8_8 = false;
                    var9_9 = false;
                    var10_10 = false;
                    var11_11 = 0;
                    var12_12 = 0;
                    var13_13 = 0;
                    var14_14 = null;
                    while (true) {
                        var15_15 /* !! */  = this.mGLThreadManager;
                        synchronized (var15_15 /* !! */ ) {
                            while (true) {
                                if (this.mShouldExit) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 64, 32, 14, 31] lbl25 : MonitorExitStatement: MONITOREXIT : var15_15 /* !! */ 
                                    var16_17 = this.mGLThreadManager;
                                    break block65;
                                }
                                if (!this.mEventQueue.isEmpty()) {
                                    var14_14 = this.mEventQueue.remove(0);
                                    break;
                                }
                                var16_18 = false;
                                if (this.mPaused != this.mRequestPaused) {
                                    var16_18 = this.mRequestPaused;
                                    this.mPaused = this.mRequestPaused;
                                    this.mGLThreadManager.notifyAll();
                                }
                                if (this.mShouldReleaseEglContext) {
                                    this.stopEglSurfaceLocked();
                                    this.stopEglContextLocked();
                                    this.mShouldReleaseEglContext = false;
                                    var9_9 = true;
                                }
                                if (var5_5) {
                                    this.stopEglSurfaceLocked();
                                    this.stopEglContextLocked();
                                    var5_5 = false;
                                }
                                if (var16_18 && this.mHaveEglSurface) {
                                    this.stopEglSurfaceLocked();
                                }
                                if (var16_18 && this.mHaveEglContext && !(var18_22 = (var17_20 = (GvrSurfaceView)this.mGvrSurfaceViewWeakRef.get()) == null ? false : GvrSurfaceView.access$900(var17_20))) {
                                    this.stopEglContextLocked();
                                }
                                if (!this.mHasSurface && !this.mWaitingForSurface) {
                                    if (this.mHaveEglSurface) {
                                        this.stopEglSurfaceLocked();
                                    }
                                    this.mWaitingForSurface = true;
                                    this.mSurfaceIsBad = false;
                                    this.mGLThreadManager.notifyAll();
                                }
                                if (this.mHasSurface && this.mWaitingForSurface) {
                                    this.mWaitingForSurface = false;
                                    this.mGLThreadManager.notifyAll();
                                }
                                if (var8_8) {
                                    this.mWantRenderNotification = false;
                                    var8_8 = false;
                                    this.mRenderComplete = true;
                                    this.mGLThreadManager.notifyAll();
                                }
                                if (this.readyToDraw()) {
                                    if (!this.mHaveEglContext) {
                                        if (var9_9) {
                                            var9_9 = false;
                                        } else {
                                            try {
                                                this.mEglHelper.start();
                                            }
                                            catch (RuntimeException var17_21) {
                                                this.mGLThreadManager.releaseEglContextLocked(this);
                                                throw var17_21;
                                            }
                                            if (this.mEglHelper.mEglContext != null) {
                                                this.mHaveEglContext = true;
                                                var2_2 = true;
                                                this.mGLThreadManager.notifyAll();
                                            }
                                        }
                                    }
                                    if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                        this.mHaveEglSurface = true;
                                        var3_3 = true;
                                        var4_4 = true;
                                        var6_6 = true;
                                    }
                                    if (this.mHaveEglSurface) {
                                        if (this.mSizeChanged) {
                                            var6_6 = true;
                                            var12_12 = this.mWidth;
                                            var13_13 = this.mHeight;
                                            this.mWantRenderNotification = true;
                                            var3_3 = true;
                                            this.mSizeChanged = false;
                                        }
                                        this.mRequestRender = false;
                                        this.mGLThreadManager.notifyAll();
                                        if (this.mWantRenderNotification) {
                                            var7_7 = true;
                                        }
                                        var10_10 = this.mRequestedSwapMode != var11_11;
                                        var11_11 = this.mRequestedSwapMode;
                                        break;
                                    }
                                }
                                this.mGLThreadManager.wait();
                            }
                            ** if (var14_14 == null) goto lbl104
                        }
lbl-1000:
                        // 1 sources

                        {
                            var14_14.run();
                            var14_14 = null;
                            continue;
                        }
lbl104:
                        // 1 sources

                        if (var3_3) {
                            if (this.mEglHelper.createSurface()) {
                                var15_15 /* !! */  = this.mGLThreadManager;
                                synchronized (var15_15 /* !! */ ) {
                                    this.mFinishedCreatingEglSurface = true;
                                    this.mGLThreadManager.notifyAll();
                                }
                                var3_3 = false;
                                var11_11 = 0;
                            } else {
                                var15_15 /* !! */  = this.mGLThreadManager;
                                synchronized (var15_15 /* !! */ ) {
                                    this.mFinishedCreatingEglSurface = true;
                                    this.mSurfaceIsBad = true;
                                    this.mGLThreadManager.notifyAll();
                                    continue;
                                }
                            }
                        }
                        if (var4_4) {
                            var1_1 = (GL10)this.mEglHelper.createGL();
                            var4_4 = false;
                        }
                        if (var2_2) {
                            var15_15 /* !! */  = (GvrSurfaceView)this.mGvrSurfaceViewWeakRef.get();
                            if (var15_15 /* !! */  != null) {
                                try {
                                    TraceCompat.beginSection("onSurfaceCreated");
                                    GvrSurfaceView.access$1000((GvrSurfaceView)var15_15 /* !! */ ).onSurfaceCreated(var1_1, this.mEglHelper.mEglConfig);
                                }
                                finally {
                                    TraceCompat.endSection();
                                }
                            }
                            var2_2 = false;
                        }
                        if (var6_6) {
                            var15_15 /* !! */  = (GvrSurfaceView)this.mGvrSurfaceViewWeakRef.get();
                            if (var15_15 /* !! */  != null) {
                                try {
                                    TraceCompat.beginSection("onSurfaceChanged");
                                    GvrSurfaceView.access$1000((GvrSurfaceView)var15_15 /* !! */ ).onSurfaceChanged(var1_1, var12_12, var13_13);
                                }
                                finally {
                                    TraceCompat.endSection();
                                }
                            }
                            var6_6 = false;
                        }
                        if (var10_10) {
                            this.mEglHelper.setEglSurfaceAttrib(12422, var11_11 == 1 ? 12421 : 12420);
                            this.mEglHelper.setEglSurfaceAttrib(12620, var11_11 == 1 ? 1 : 0);
                        }
                        if ((var15_15 /* !! */  = (GvrSurfaceView)this.mGvrSurfaceViewWeakRef.get()) != null) {
                            try {
                                TraceCompat.beginSection("onDrawFrame");
                                GvrSurfaceView.access$1000((GvrSurfaceView)var15_15 /* !! */ ).onDrawFrame(var1_1);
                            }
                            finally {
                                TraceCompat.endSection();
                            }
                        }
                        if (var10_10 || var11_11 == 0) {
                            var15_16 = this.mEglHelper.swap();
                            switch (var15_16) {
                                case 12288: {
                                    break;
                                }
                                case 12302: {
                                    var5_5 = true;
                                    break;
                                }
                                default: {
                                    EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", var15_16);
                                    if (var11_11 != 0) break;
                                    var16_19 = this.mGLThreadManager;
                                    synchronized (var16_19) {
                                        this.mSurfaceIsBad = true;
                                        this.mGLThreadManager.notifyAll();
                                        break;
                                    }
                                }
                            }
                        }
                        if (!var7_7) continue;
                        var8_8 = true;
                        var7_7 = false;
                    }
                }
                catch (Throwable var26_26) {
                    var27_27 = this.mGLThreadManager;
                    synchronized (var27_27) {
                        this.stopEglSurfaceLocked();
                        this.stopEglContextLocked();
                        throw var26_26;
                    }
                }
            }
            synchronized (var16_17) {
                this.stopEglSurfaceLocked();
                this.stopEglContextLocked();
                return;
            }
        }

        public boolean ableToDraw() {
            return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
        }

        private boolean readyToDraw() {
            boolean bl;
            GvrSurfaceView gvrSurfaceView = (GvrSurfaceView)((Object)this.mGvrSurfaceViewWeakRef.get());
            EglReadyListener eglReadyListener = gvrSurfaceView == null ? null : gvrSurfaceView.mAppContextListener;
            boolean bl2 = bl = eglReadyListener == null || eglReadyListener.getEGLContext() != null;
            return !this.mPaused && bl && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int n) {
            if (n < 0 || n > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderMode = n;
                this.mGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSwapMode(int n) {
            if (n < 0 || n > 2) {
                throw new IllegalArgumentException("swapMode");
            }
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestedSwapMode = n;
                this.mGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSwapMode() {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRequestedSwapMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                this.mGLThreadManager.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRenderAndWait() {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                if (Thread.currentThread() == this) {
                    return;
                }
                this.mWantRenderNotification = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                this.mGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                    try {
                        this.mGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated() {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = true;
                this.mFinishedCreatingEglSurface = false;
                this.mGLThreadManager.notifyAll();
                while (this.mWaitingForSurface && !this.mFinishedCreatingEglSurface && !this.mExited) {
                    try {
                        this.mGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed(Runnable runnable) {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = false;
                if (runnable != null) {
                    this.mEventQueue.add(runnable);
                }
                this.mGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && !this.mExited) {
                    try {
                        this.mGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause(Runnable runnable) {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = true;
                if (runnable != null) {
                    this.mEventQueue.add(runnable);
                }
                this.mGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused) {
                    try {
                        this.mGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                this.mGLThreadManager.notifyAll();
                while (!this.mExited && this.mPaused && !this.mRenderComplete) {
                    try {
                        this.mGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int n, int n2) {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = n;
                this.mHeight = n2;
                this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                if (Thread.currentThread() == this) {
                    return;
                }
                this.mGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                    try {
                        this.mGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mShouldExit = true;
                this.mGLThreadManager.notifyAll();
                while (!this.mExited) {
                    try {
                        this.mGLThreadManager.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                GvrSurfaceView gvrSurfaceView = (GvrSurfaceView)((Object)this.mGvrSurfaceViewWeakRef.get());
                if (gvrSurfaceView != null && gvrSurfaceView.mAppContextListener != null) {
                    gvrSurfaceView.mAppContextListener.releaseEventListener();
                }
                return;
            }
        }

        public void requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            this.mGLThreadManager.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = this.mGLThreadManager;
            synchronized (gLThreadManager) {
                this.mEventQueue.add(runnable);
                this.mGLThreadManager.notifyAll();
                return;
            }
        }

        private static class GLThreadManager {
            private static final String TAG = "GLThreadManager";

            private GLThreadManager() {
            }

            public synchronized void threadExiting(GLThread gLThread) {
                gLThread.mExited = true;
                this.notifyAll();
            }

            public void releaseEglContextLocked(GLThread gLThread) {
                this.notifyAll();
            }
        }
    }

    private static class EglHelper {
        public static final int EGL_FRONT_BUFFER_AUTO_REFRESH = 12620;
        private WeakReference<GvrSurfaceView> mGvrSurfaceViewWeakRef;
        EGL10 mEgl;
        javax.microedition.khronos.egl.EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        EGLConfig mEglConfig;
        EGLContext mEglContext;
        EGLContext mPendingEglContext;
        javax.microedition.khronos.egl.EGLDisplay mPendingEglDisplay;

        public EglHelper(WeakReference<GvrSurfaceView> weakReference) {
            this.mGvrSurfaceViewWeakRef = weakReference;
        }

        public void start() {
            if (this.mEgl == null) {
                this.initialize();
            }
            if (this.mEglContext != null) {
                this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
                this.mEglContext = null;
            }
            if (this.mPendingEglContext == null) {
                this.createPendingEglContext();
            }
            this.mEglContext = this.mPendingEglContext;
            this.mEglDisplay = this.mPendingEglDisplay;
            this.mPendingEglContext = null;
            this.mPendingEglDisplay = null;
        }

        public void renewPendingEglContext() {
            if (this.mEgl == null) {
                this.initialize();
            }
            if (this.mPendingEglContext != null) {
                this.mEgl.eglDestroyContext(this.mEglDisplay, this.mPendingEglContext);
            }
            this.createPendingEglContext();
        }

        private void initialize() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] nArray = new int[2];
            if (!this.mEgl.eglInitialize(this.mEglDisplay, nArray)) {
                throw new RuntimeException("eglInitialize failed");
            }
            this.mEglSurface = null;
        }

        private void createPendingEglContext() {
            EGLContext eGLContext;
            this.mPendingEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mPendingEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] nArray = new int[2];
            if (!this.mEgl.eglInitialize(this.mPendingEglDisplay, nArray)) {
                throw new RuntimeException("eglInitialize failed");
            }
            GvrSurfaceView gvrSurfaceView = (GvrSurfaceView)((Object)this.mGvrSurfaceViewWeakRef.get());
            if (gvrSurfaceView == null) {
                this.mEglConfig = null;
                eGLContext = null;
            } else {
                if (gvrSurfaceView.mAppContextListener != null) {
                    EGLContext eGLContext2 = gvrSurfaceView.mAppContextListener.getEGLContext();
                    if (eGLContext2 == null || eGLContext2 == EGL10.EGL_NO_CONTEXT) {
                        this.throwEglException("Unable to obtain application's OpenGL context.");
                    } else {
                        EglFactory eglFactory = (EglFactory)gvrSurfaceView.mEGLContextFactory;
                        int n = gvrSurfaceView.mAppContextListener.getEGLContextFlags();
                        eglFactory.setSharedContext(eGLContext2);
                        eglFactory.setErrorReportingEnabled((n & 8) == 0);
                        eglFactory.setEGLContextClientVersion(gvrSurfaceView.mAppContextListener.getGLVersion());
                    }
                }
                this.mEglConfig = gvrSurfaceView.mEGLConfigChooser.chooseConfig(this.mEgl, this.mPendingEglDisplay);
                eGLContext = gvrSurfaceView.mEGLContextFactory.createContext(this.mEgl, this.mPendingEglDisplay, this.mEglConfig);
            }
            if (eGLContext == null || eGLContext == EGL10.EGL_NO_CONTEXT) {
                eGLContext = null;
                int n = this.mEgl.eglGetError();
                if (n == 12294) {
                    Log.e((String)"EglHelper", (String)"Stashed EGL context has become invalid and can no longer be used for sharing.");
                    this.mPendingEglContext = null;
                    this.mPendingEglDisplay = null;
                    this.mEglConfig = null;
                    if (gvrSurfaceView.mAppContextListener != null) {
                        gvrSurfaceView.mAppContextListener.clearContext();
                    }
                    return;
                }
                EglHelper.throwEglException("createPendingEglContext", n);
            }
            this.mPendingEglContext = eGLContext;
        }

        public boolean createSurface() {
            if (this.mEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (this.mEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (this.mEglConfig == null) {
                throw new RuntimeException("mEglConfig not initialized");
            }
            this.destroySurfaceImp();
            GvrSurfaceView gvrSurfaceView = (GvrSurfaceView)((Object)this.mGvrSurfaceViewWeakRef.get());
            this.mEglSurface = gvrSurfaceView != null ? gvrSurfaceView.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, (Object)gvrSurfaceView.getHolder()) : null;
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int n = this.mEgl.eglGetError();
                if (n == 12299) {
                    Log.e((String)"EglHelper", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
                return false;
            }
            return true;
        }

        GL createGL() {
            GL gL = this.mEglContext.getGL();
            GvrSurfaceView gvrSurfaceView = (GvrSurfaceView)((Object)this.mGvrSurfaceViewWeakRef.get());
            if (gvrSurfaceView != null) {
                if (gvrSurfaceView.mGLWrapper != null) {
                    gL = gvrSurfaceView.mGLWrapper.wrap(gL);
                }
                if ((gvrSurfaceView.mDebugFlags & 3) != 0) {
                    int n = 0;
                    LogWriter logWriter = null;
                    if ((gvrSurfaceView.mDebugFlags & 1) != 0) {
                        n = 1;
                    }
                    if ((gvrSurfaceView.mDebugFlags & 2) != 0) {
                        logWriter = new LogWriter();
                    }
                    gL = GLDebugHelper.wrap((GL)gL, (int)n, (Writer)logWriter);
                }
            }
            return gL;
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }

        public void destroySurface() {
            this.destroySurfaceImp();
        }

        public void setEglSurfaceAttrib(int n, int n2) {
            android.opengl.EGLSurface eGLSurface;
            if (Build.VERSION.SDK_INT < 17) {
                Log.e((String)"EglHelper", (String)"Cannot call eglSurfaceAttrib. API version is too low.");
                return;
            }
            EGLDisplay eGLDisplay = EGL14.eglGetCurrentDisplay();
            boolean bl = EGL14.eglSurfaceAttrib((EGLDisplay)eGLDisplay, (android.opengl.EGLSurface)(eGLSurface = EGL14.eglGetCurrentSurface((int)12377)), (int)n, (int)n2);
            if (!bl) {
                Log.e((String)"EglHelper", (String)new StringBuilder(66).append("eglSurfaceAttrib() failed. attribute=").append(n).append(" value=").append(n2).toString());
            }
        }

        private void destroySurfaceImp() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GvrSurfaceView gvrSurfaceView = (GvrSurfaceView)((Object)this.mGvrSurfaceViewWeakRef.get());
                if (gvrSurfaceView != null) {
                    gvrSurfaceView.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        public void finish() {
            if (this.mEglContext != null) {
                GvrSurfaceView gvrSurfaceView = (GvrSurfaceView)((Object)this.mGvrSurfaceViewWeakRef.get());
                if (gvrSurfaceView != null) {
                    gvrSurfaceView.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }

        private void throwEglException(String string2) {
            EglHelper.throwEglException(string2, this.mEgl.eglGetError());
        }

        public static void throwEglException(String string2, int n) {
            String string3 = EglHelper.formatEglError(string2, n);
            throw new RuntimeException(string3);
        }

        public static void logEglErrorAsWarning(String string2, String string3, int n) {
            Log.w((String)string2, (String)EglHelper.formatEglError(string3, n));
        }

        public static String formatEglError(String string2, int n) {
            String string3 = EglHelper.getErrorString(n);
            return new StringBuilder(9 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" failed: ").append(string3).toString();
        }

        private static String getHex(int n) {
            String string2 = String.valueOf(Integer.toHexString(n));
            if (string2.length() != 0) {
                return "0x".concat(string2);
            }
            return new String("0x");
        }

        private static String getErrorString(int n) {
            switch (n) {
                case 12288: {
                    return "EGL_SUCCESS";
                }
                case 12289: {
                    return "EGL_NOT_INITIALIZED";
                }
                case 12290: {
                    return "EGL_BAD_ACCESS";
                }
                case 12291: {
                    return "EGL_BAD_ALLOC";
                }
                case 12292: {
                    return "EGL_BAD_ATTRIBUTE";
                }
                case 12293: {
                    return "EGL_BAD_CONFIG";
                }
                case 12294: {
                    return "EGL_BAD_CONTEXT";
                }
                case 12295: {
                    return "EGL_BAD_CURRENT_SURFACE";
                }
                case 12296: {
                    return "EGL_BAD_DISPLAY";
                }
                case 12297: {
                    return "EGL_BAD_MATCH";
                }
                case 12298: {
                    return "EGL_BAD_NATIVE_PIXMAP";
                }
                case 12299: {
                    return "EGL_BAD_NATIVE_WINDOW";
                }
                case 12300: {
                    return "EGL_BAD_PARAMETER";
                }
                case 12301: {
                    return "EGL_BAD_SURFACE";
                }
                case 12302: {
                    return "EGL_CONTEXT_LOST";
                }
            }
            return EglHelper.getHex(n);
        }
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser {
        public SimpleEGLConfigChooser(GvrSurfaceView gvrSurfaceView, boolean bl) {
            super(gvrSurfaceView, 8, 8, 8, 0, bl ? 16 : 0, 0);
        }
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser {
        private int[] mValue = new int[1];
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;

        public ComponentSizeChooser(GvrSurfaceView gvrSurfaceView, int n, int n2, int n3, int n4, int n5, int n6) {
            super(new int[]{12324, n, 12323, n2, 12322, n3, 12321, n4, 12325, n5, 12326, n6, 12344});
            this.mRedSize = n;
            this.mGreenSize = n2;
            this.mBlueSize = n3;
            this.mAlphaSize = n4;
            this.mDepthSize = n5;
            this.mStencilSize = n6;
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, javax.microedition.khronos.egl.EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            EGLConfig[] eGLConfigArray2 = eGLConfigArray;
            int n = eGLConfigArray.length;
            for (int i = 0; i < n; ++i) {
                EGLConfig eGLConfig = eGLConfigArray2[i];
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
                if (n2 < this.mDepthSize || n3 < this.mStencilSize) continue;
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
                int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
                if (n4 != this.mRedSize || n5 != this.mGreenSize || n6 != this.mBlueSize || n7 != this.mAlphaSize) continue;
                return eGLConfig;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 eGL10, javax.microedition.khronos.egl.EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.mValue)) {
                return this.mValue[0];
            }
            return n2;
        }
    }

    private abstract class BaseConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        protected int[] mConfigSpec;

        public BaseConfigChooser(int[] nArray) {
            this.mConfigSpec = this.filterConfigSpec(nArray);
        }

        public EGLConfig chooseConfig(EGL10 eGL10, javax.microedition.khronos.egl.EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            if (!eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, null, 0, nArray)) {
                for (int i = 1; i < this.mConfigSpec.length; ++i) {
                    if (this.mConfigSpec[i - 1] != 12352 || this.mConfigSpec[i] != 64) continue;
                    Log.w((String)GvrSurfaceView.TAG, (String)"Failed to choose GLES 3 config, will try 2.");
                    this.mConfigSpec[i] = 4;
                    return this.chooseConfig(eGL10, eGLDisplay);
                }
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int n = nArray[0];
            if (n <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            if (!eGL10.eglChooseConfig(eGLDisplay, this.mConfigSpec, eGLConfigArray, n, nArray)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig eGLConfig = this.chooseConfig(eGL10, eGLDisplay, eGLConfigArray);
            if (eGLConfig == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return eGLConfig;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, javax.microedition.khronos.egl.EGLDisplay var2, EGLConfig[] var3);

        private int[] filterConfigSpec(int[] nArray) {
            if (GvrSurfaceView.this.mEGLContextClientVersion != 2 && GvrSurfaceView.this.mEGLContextClientVersion != 3) {
                return nArray;
            }
            int n = nArray.length;
            int[] nArray2 = new int[n + 2];
            System.arraycopy(nArray, 0, nArray2, 0, n - 1);
            nArray2[n - 1] = 12352;
            nArray2[n] = GvrSurfaceView.this.mEGLContextClientVersion == 2 ? 4 : 64;
            nArray2[n + 1] = 12344;
            return nArray2;
        }
    }

    private static class DefaultWindowSurfaceFactory
    implements GLSurfaceView.EGLWindowSurfaceFactory {
        private DefaultWindowSurfaceFactory() {
        }

        public EGLSurface createWindowSurface(EGL10 eGL10, javax.microedition.khronos.egl.EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
            EGLSurface eGLSurface = null;
            try {
                eGLSurface = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)GvrSurfaceView.TAG, (String)"eglCreateWindowSurface", (Throwable)illegalArgumentException);
            }
            return eGLSurface;
        }

        public void destroySurface(EGL10 eGL10, javax.microedition.khronos.egl.EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
            eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
        }
    }

    private class DefaultContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private DefaultContextFactory() {
        }

        public EGLContext createContext(EGL10 eGL10, javax.microedition.khronos.egl.EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{12440, GvrSurfaceView.this.mEGLContextClientVersion, 12344};
            return eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, (int[])(GvrSurfaceView.this.mEGLContextClientVersion != 0 ? nArray : null));
        }

        public void destroyContext(EGL10 eGL10, javax.microedition.khronos.egl.EGLDisplay eGLDisplay, EGLContext eGLContext) {
            if (!eGL10.eglDestroyContext(eGLDisplay, eGLContext)) {
                String string2 = String.valueOf(eGLDisplay);
                String string3 = String.valueOf(eGLContext);
                Log.e((String)"DefaultContextFactory", (String)new StringBuilder(18 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("display:").append(string2).append(" context: ").append(string3).toString());
                EglHelper.throwEglException("eglDestroyContext", eGL10.eglGetError());
            }
        }
    }

    public static interface GLWrapper {
        public GL wrap(GL var1);
    }
}

