/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.library.api;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.IBinder;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.library.api.IVrCreator;

public class VrCoreLoader {
    private static final String TAG = VrCoreLoader.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final String LIBRARY_APK_PACKAGE = "com.google.vr.vrcore";
    private static final String CREATOR_NAME = "com.google.vr.vrcore.library.VrCreator";
    static final int MIN_TARGET_API_VERSION = 9;
    private static Context sRemoteContext;
    private static int sRemoteContextApiVersion;
    private static IVrCreator sCreator;

    public VrCoreLoader() {
    }

    public static IVrCreator getRemoteCreator(Context context) throws VrCoreNotAvailableException {
        if (sCreator == null) {
            ClassLoader classLoader = VrCoreLoader.getRemoteContext(context).getClassLoader();
            IBinder iBinder = VrCoreLoader.newBinderInstance(classLoader, CREATOR_NAME);
            sCreator = IVrCreator.Stub.asInterface(iBinder);
        }
        return sCreator;
    }

    public static Context getRemoteContext(Context context) throws VrCoreNotAvailableException {
        if (sRemoteContext == null) {
            int n = VrCoreUtils.getVrCoreClientApiVersion(context);
            if (n < 9) {
                throw new VrCoreNotAvailableException(4);
            }
            try {
                sRemoteContext = context.createPackageContext(LIBRARY_APK_PACKAGE, 3);
                sRemoteContextApiVersion = n;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                throw new VrCoreNotAvailableException(1);
            }
        }
        return sRemoteContext;
    }

    public static int getRemoteContextClientApiVersion(Context context) throws VrCoreNotAvailableException {
        VrCoreLoader.getRemoteContext(context);
        return sRemoteContextApiVersion;
    }

    static void resetForTesting() {
        sRemoteContext = null;
        sRemoteContextApiVersion = 0;
        sCreator = null;
    }

    private static IBinder newBinderInstance(ClassLoader classLoader, String string2) {
        try {
            Class<?> clazz = classLoader.loadClass(string2);
            return (IBinder)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = String.valueOf(string2);
            throw new IllegalStateException(string3.length() != 0 ? "Unable to find dynamic class ".concat(string3) : new String("Unable to find dynamic class "));
        }
        catch (InstantiationException instantiationException) {
            String string4 = String.valueOf(string2);
            throw new IllegalStateException(string4.length() != 0 ? "Unable to instantiate the remote class ".concat(string4) : new String("Unable to instantiate the remote class "));
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = String.valueOf(string2);
            throw new IllegalStateException(string5.length() != 0 ? "Unable to call the default constructor of ".concat(string5) : new String("Unable to call the default constructor of "));
        }
    }
}

