/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.library.api;

import android.os.IBinder;
import com.google.vr.cardboard.annotations.UsedByReflection;
import com.google.vr.vrcore.library.api.IObjectWrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

@UsedByReflection(value="ObjectWrapper.java")
public final class ObjectWrapper<T>
extends IObjectWrapper.Stub {
    @UsedByReflection(value="ObjectWrapper.java")
    private final T wrappedObject;

    private ObjectWrapper(T t) {
        this.wrappedObject = t;
    }

    public static <T> IObjectWrapper wrap(T t) {
        return new ObjectWrapper<T>(t);
    }

    public static <T> T unwrap(IObjectWrapper iObjectWrapper, Class<T> clazz) {
        if (iObjectWrapper == null) {
            return null;
        }
        if (iObjectWrapper instanceof ObjectWrapper) {
            return ((ObjectWrapper)iObjectWrapper).wrappedObject;
        }
        IBinder iBinder = iObjectWrapper.asBinder();
        Class<?> clazz2 = iBinder.getClass();
        AccessibleObject accessibleObject = null;
        for (Field field : clazz2.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            if (accessibleObject != null) {
                accessibleObject = null;
                break;
            }
            accessibleObject = field;
        }
        if (accessibleObject != null) {
            if (!accessibleObject.isAccessible()) {
                ((Field)accessibleObject).setAccessible(true);
                try {
                    Object nullPointerException = ((Field)accessibleObject).get(iBinder);
                    if (nullPointerException == null) {
                        return null;
                    }
                    if (!clazz.isInstance(nullPointerException)) {
                        throw new IllegalArgumentException("remoteBinder is the wrong class.");
                    }
                    return clazz.cast(nullPointerException);
                }
                catch (NullPointerException illegalArgumentException) {
                    throw new IllegalArgumentException("Binder object is null.", illegalArgumentException);
                }
                catch (IllegalArgumentException illegalAccessException) {
                    throw new IllegalArgumentException("remoteBinder is the wrong class.", illegalAccessException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Could not access the field in remoteBinder.", illegalAccessException);
                }
            }
            throw new IllegalArgumentException("The concrete class implementing IObjectWrapper must have exactly one declared *private* field for the wrapped object. Preferably, this is an instance of the ObjectWrapper<T> class.");
        }
        throw new IllegalArgumentException("The concrete class implementing IObjectWrapper must have exactly *one* declared private field for the wrapped object.  Preferably, this is an instance of the ObjectWrapper<T> class.");
    }
}

