/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.os.Handler;
import android.os.Looper;

public class ThreadUtils {
    private static final Handler uiHandler = new Handler(Looper.getMainLooper());
    static final /* synthetic */ boolean $assertionsDisabled;

    public ThreadUtils() {
    }

    public static void runOnUiThread(Runnable runnable) {
        if (ThreadUtils.runningOnUiThread()) {
            runnable.run();
            return;
        }
        uiHandler.post(runnable);
    }

    public static void postOnUiThread(Runnable runnable) {
        uiHandler.post(runnable);
    }

    public static boolean runningOnUiThread() {
        return uiHandler.getLooper() == Looper.myLooper();
    }

    public static void assertOnUiThread() {
    }

    public static void throwIfNotOnUiThread() {
        if (!ThreadUtils.runningOnUiThread()) {
            throw new IllegalStateException("Call was not made on the UI thread.");
        }
    }

    public static Handler getUiThreadHandler() {
        return uiHandler;
    }
}

