/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.vr.vrcore.base.api.ParcelableProto;
import com.google.vr.vrcore.controller.api.nano.Proto;
import java.util.Arrays;

public class ControllerRequest
extends ParcelableProto<Proto.Request> {
    private static final int MAX_VIBRATION_DURATION_MS = 10000;
    public static final Parcelable.Creator<ControllerRequest> CREATOR = new Parcelable.Creator<ControllerRequest>(){

        public ControllerRequest createFromParcel(Parcel parcel) {
            return new ControllerRequest(parcel);
        }

        public ControllerRequest[] newArray(int n) {
            return new ControllerRequest[n];
        }
    };

    public ControllerRequest() {
    }

    public ControllerRequest(byte[] byArray) {
        super(byArray);
    }

    public ControllerRequest(Parcel parcel) {
        super(parcel);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ControllerRequest) {
            return Arrays.equals(((ControllerRequest)object).getData(), this.getData());
        }
        return false;
    }

    public Proto.Request getValidatedRequest() {
        Proto.Request request = this.parseToProto(Proto.Request.class);
        ControllerRequest.checkArgument(request != null, "Failed to parse request proto data.", new Object[0]);
        if (request.vibration != null) {
            Proto.Request.Vibration vibration = request.vibration;
            ControllerRequest.checkArgument(vibration.getDurationMs() >= 0, "Vibration duration should be non-negative", new Object[0]);
            ControllerRequest.checkArgument(vibration.getDurationMs() <= 10000, "Vibration duration can be at most %d", 10000);
            ControllerRequest.checkArgument(vibration.getVolumePercentage() >= 0, "Volume should be positive", new Object[0]);
            ControllerRequest.checkArgument(vibration.getVolumePercentage() <= 100, "Volume should be at most 100.", new Object[0]);
            ControllerRequest.checkArgument(vibration.getFrequencyHz() > 0, "Vibration frequency be positive", new Object[0]);
        }
        return request;
    }

    private static void checkArgument(boolean bl, String string2, Object ... objectArray) {
        if (!bl) {
            if (objectArray.length == 0) {
                throw new IllegalArgumentException(string2);
            }
            throw new IllegalArgumentException(String.format(string2, objectArray));
        }
    }
}

