/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.base.api;

import android.content.Context;
import android.content.pm.PackageManager;
import com.google.vr.vrcore.base.api.SignatureUtils;

public class BuildUtils {
    private static volatile Boolean isDebug;

    public BuildUtils() {
    }

    public static boolean isDebugBuild(Context context) {
        if (isDebug != null) {
            return isDebug;
        }
        return BuildUtils.computeIsDebugBuild(context);
    }

    public static synchronized void setIsDebugBuild(boolean bl) {
        isDebug = bl;
    }

    private static synchronized boolean computeIsDebugBuild(Context context) {
        if (isDebug == null) {
            try {
                PackageManager packageManager = context.getPackageManager();
                isDebug = SignatureUtils.verifySignature(packageManager.getPackageInfo(context.getPackageName(), 64), SignatureUtils.BLAZE_DEBUG_SIGNATURE, SignatureUtils.ANDROID_DEBUG_SIGNATURE, SignatureUtils.VRCORE_DEBUG_SIGNATURE);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                throw new IllegalStateException("Unable to find self package info", nameNotFoundException);
            }
        }
        return isDebug;
    }
}

