/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayout;

public class ExternalSurface {
    private static final String TAG = ExternalSurface.class.getSimpleName();
    private long nativeExternalSurface;

    ExternalSurface(long l) {
        this.nativeExternalSurface = l;
    }

    ExternalSurface(GvrApi gvrApi, final GvrLayout.ExternalSurfaceListener externalSurfaceListener, Handler handler) {
        if (externalSurfaceListener == null) {
            throw new IllegalArgumentException("ExternalSurface creation requires a valid listener.");
        }
        if (handler == null) {
            throw new IllegalArgumentException("ExternalSurface creation requires a valid Handler.");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Surface surface = ExternalSurface.this.getSurface();
                if (surface == null || !surface.isValid()) {
                    Log.w((String)TAG, (String)"No valid Surface during onSurfaceAvailable callback. The native GvrContext might have been shut down already.");
                    return;
                }
                externalSurfaceListener.onSurfaceAvailable(surface);
            }
        };
        Runnable runnable2 = new Runnable(this){

            @Override
            public void run() {
                externalSurfaceListener.onFrameAvailable();
            }
        };
        this.nativeExternalSurface = GvrApi.nativeExternalSurfaceCreateWithListeners(gvrApi.getNativeGvrContext(), runnable, runnable2, handler);
        if (this.nativeExternalSurface == 0L) {
            throw new IllegalStateException("ExternalSurface creation failed. Is reprojection enabled?");
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nativeExternalSurface != 0L) {
                Log.w((String)TAG, (String)"ExternalSurface.shutdown() should be called to ensure resource cleanup");
                this.shutdown();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public Surface getSurface() {
        return GvrApi.nativeExternalSurfaceGetSurface(this.nativeExternalSurface);
    }

    public int getId() {
        return GvrApi.nativeExternalSurfaceGetId(this.nativeExternalSurface);
    }

    public void shutdown() {
        if (this.nativeExternalSurface != 0L) {
            GvrApi.nativeExternalSurfaceDestroy(this.nativeExternalSurface);
            this.nativeExternalSurface = 0L;
        }
    }

    long getNativeExternalSurface() {
        return this.nativeExternalSurface;
    }
}

