/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.util.Log;
import com.google.vr.ndk.base.GvrApi;

public final class Event
implements AutoCloseable {
    private static final String TAG = "Event";
    long nativeEvent = GvrApi.nativeCreateEvent();

    public Event() {
    }

    @Override
    public final void close() {
        GvrApi.nativeDestroyEvent(this.nativeEvent);
        this.nativeEvent = 0L;
    }

    protected final void finalize() {
        if (this.nativeEvent != 0L) {
            Log.e((String)TAG, (String)"Event.close() should be called when done with the event.");
            this.close();
        }
    }

    public final long getTimestamp() {
        return GvrApi.nativeGetEventTimestamp(this.nativeEvent);
    }

    public final int getType() {
        return GvrApi.nativeGetEventType(this.nativeEvent);
    }

    public final long getFlags() {
        return GvrApi.nativeGetEventFlags(this.nativeEvent);
    }

    public final int getRecenterEventType() {
        return GvrApi.nativeGetRecenterEventType(this.nativeEvent);
    }

    public final long getRecenterEventFlags() {
        return GvrApi.nativeGetRecenterEventFlags(this.nativeEvent);
    }

    public final void getRecenterEventStartSpaceFromTrackingSpaceTransform(float[] fArray) {
        GvrApi.nativeGetRecenterEventStartSpaceFromTrackingSpaceTransform(this.nativeEvent, fArray);
    }

    public static final class RecenterType {
        public static final int RESTART = 1;
        public static final int ALIGNED = 2;
        public static final int DON = 3;

        private RecenterType() {
        }
    }

    public static final class EventType {
        public static final int RECENTER = 1;
        public static final int SAFETY_REGION_EXIT = 2;
        public static final int SAFETY_REGION_ENTER = 3;
        public static final int HEAD_TRACKING_RESUMED = 4;
        public static final int HEAD_TRACKING_PAUSED = 5;

        private EventType() {
        }
    }
}

