/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.internal.controller.ControllerServiceBridge;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerEventPacket;
import com.google.vr.vrcore.controller.api.ControllerEventPacket2;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;

class CardboardEmulator {
    private static final String TAG = CardboardEmulator.class.getSimpleName();
    private static final boolean DEBUG = false;
    private final ControllerServiceBridge controllerServiceBridge;
    private boolean resumed;

    public CardboardEmulator(Context context, Runnable runnable) {
        this.controllerServiceBridge = this.createServiceBridge(context, new ControllerCallbacks(runnable));
    }

    public void onResume() {
        if (!this.resumed) {
            this.resumed = true;
            this.controllerServiceBridge.requestBind();
        }
    }

    public void onPause() {
        if (this.resumed) {
            this.resumed = false;
            this.controllerServiceBridge.requestUnbind();
        }
    }

    protected ControllerServiceBridge createServiceBridge(Context context, ControllerServiceBridge.Callbacks callbacks) {
        return new ControllerServiceBridge(context, callbacks, 0);
    }

    private static class ControllerCallbacks
    implements ControllerServiceBridge.Callbacks {
        private final Runnable cardboardTriggerCallback;

        ControllerCallbacks(Runnable runnable) {
            this.cardboardTriggerCallback = runnable;
        }

        @Override
        public void onServiceConnected(int n) {
        }

        @Override
        public void onServiceDisconnected() {
        }

        @Override
        public void onServiceUnavailable() {
        }

        @Override
        public void onServiceFailed() {
        }

        @Override
        public void onServiceInitFailed(int n) {
        }

        @Override
        public void onControllerStateChanged(int n, int n2) {
        }

        @Override
        public void onControllerEventPacket(ControllerEventPacket controllerEventPacket) {
            for (int i = 0; i < controllerEventPacket.getButtonEventCount(); ++i) {
                ControllerButtonEvent controllerButtonEvent = controllerEventPacket.getButtonEvent(i);
                if (!controllerButtonEvent.down) continue;
                switch (controllerButtonEvent.button) {
                    case 1: 
                    case 3: {
                        ThreadUtils.runOnUiThread(this.cardboardTriggerCallback);
                    }
                }
            }
        }

        @Override
        public void onControllerRecentered(ControllerOrientationEvent controllerOrientationEvent) {
        }

        @Override
        public void onControllerEventPacket2(ControllerEventPacket2 controllerEventPacket2) {
            this.onControllerEventPacket(controllerEventPacket2);
        }
    }
}

