/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.vr.cardboard.R;
import com.google.vr.cardboard.UiUtils;

public class TransitionView
extends FrameLayout
implements View.OnTouchListener {
    public static final int TRANSITION_BACKGROUND_COLOR = -12232092;
    public static final int ALREADY_LANDSCAPE_LEFT_TRANSITION_DELAY_MS = 2000;
    public static final int TRANSITION_ANIMATION_DURATION_MS = 500;
    private static final int VIEW_CORRECTION_ROTATION_DEGREES = 90;
    private static final int PORTRAIT_TOLERANCE_DEGREES = 45;
    private static final int LANDSCAPE_TOLERANCE_DEGREES = 5;
    private int orientation = -1;
    private OrientationEventListener orientationEventListener;
    private boolean rotationChecked;
    private Runnable transitionListener;
    private ImageButton backButton;
    private Runnable backButtonListener;

    public TransitionView(Context context) {
        super(context);
        this.setOnTouchListener(this);
        this.setBackground((Drawable)new ColorDrawable(-12232092));
        this.inflateContentView(R.layout.transition_view);
        super.setVisibility(8);
    }

    private void inflateContentView(int n) {
        this.removeAllViews();
        LayoutInflater.from((Context)this.getContext()).inflate(n, (ViewGroup)this, true);
        View view = this.findViewById(R.id.transition_switch_action);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                UiUtils.launchOrInstallCardboard(TransitionView.this.getContext());
            }
        });
        ImageView imageView = (ImageView)this.findViewById(R.id.transition_icon);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TransitionView.this.fadeOutAndRemove(false);
            }
        });
        this.updateBackButtonVisibility();
        if (this.getResources().getConfiguration().orientation == 2) {
            this.findViewById(R.id.transition_bottom_frame).setVisibility(8);
        }
    }

    public void setViewerName(String string2) {
        TextView textView = (TextView)this.findViewById(R.id.transition_text);
        if (string2 != null) {
            textView.setText((CharSequence)this.getContext().getString(R.string.place_your_viewer_into_viewer_format, new Object[]{string2}));
            return;
        }
        textView.setText((CharSequence)this.getContext().getString(R.string.place_your_phone_into_cardboard));
    }

    public void setBackButtonListener(Runnable runnable) {
        this.backButtonListener = runnable;
        this.updateBackButtonVisibility();
    }

    public void setVisibility(int n) {
        int n2 = this.getVisibility();
        super.setVisibility(n);
        if (n2 != n) {
            if (n == 0) {
                this.startOrientationMonitor();
                return;
            }
            this.stopOrientationMonitor();
        }
    }

    public void setTransitionListener(Runnable runnable) {
        this.transitionListener = runnable;
    }

    private void startOrientationMonitor() {
        if (this.orientationEventListener != null) {
            return;
        }
        this.orientationEventListener = new OrientationEventListener(this.getContext()){

            public void onOrientationChanged(int n) {
                TransitionView.this.orientation = n;
                if (!TransitionView.this.rotationChecked) {
                    TransitionView.this.rotateViewIfNeeded();
                    return;
                }
                if (TransitionView.isLandscapeLeft(n)) {
                    TransitionView.this.fadeOutAndRemove(false);
                    return;
                }
                TransitionView.isLandscapeRight(n);
            }
        };
        this.orientationEventListener.enable();
    }

    private void stopOrientationMonitor() {
        if (this.orientationEventListener == null) {
            return;
        }
        this.orientation = -1;
        this.orientationEventListener.disable();
        this.orientationEventListener = null;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.orientationEventListener != null) {
            this.orientationEventListener.enable();
        }
        this.rotateViewIfNeeded();
    }

    protected void onDetachedFromWindow() {
        if (this.orientationEventListener != null) {
            this.orientation = -1;
            this.orientationEventListener.disable();
        }
        super.onDetachedFromWindow();
    }

    private void rotateViewIfNeeded() {
        boolean bl;
        if (this.getWidth() <= 0 || this.getHeight() <= 0 || this.orientation == -1 || this.orientationEventListener == null || this.rotationChecked) {
            return;
        }
        boolean bl2 = this.getWidth() < this.getHeight();
        if (bl2 != (bl = TransitionView.isPortrait(this.orientation))) {
            View view = this.findViewById(R.id.transition_frame);
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (Build.VERSION.SDK_INT >= 17 && this.getLayoutDirection() == 1) {
                view.setPivotX((float)n2 - view.getPivotX());
                view.setPivotY((float)n - view.getPivotY());
            }
            if (bl2) {
                view.setRotation(90.0f);
            } else {
                view.setRotation(-90.0f);
            }
            view.setTranslationX((float)((n - n2) / 2));
            view.setTranslationY((float)((n2 - n) / 2));
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            view.getLayoutParams().height = n;
            layoutParams.width = n2;
            view.requestLayout();
        }
        if (!bl) {
            this.findViewById(R.id.transition_bottom_frame).setVisibility(8);
        } else {
            this.findViewById(R.id.transition_bottom_frame).setVisibility(0);
        }
        this.rotationChecked = true;
        if (TransitionView.isLandscapeLeft(this.orientation)) {
            this.fadeOutAndRemove(true);
        }
    }

    private void fadeOutAndRemove(boolean bl) {
        this.stopOrientationMonitor();
        Animation animation = this.getAnimation();
        if (animation != null) {
            if (bl || animation.getStartOffset() == 0L) {
                return;
            }
            animation.setAnimationListener(null);
            this.clearAnimation();
        }
        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        alphaAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        alphaAnimation.setRepeatCount(0);
        alphaAnimation.setDuration(500L);
        if (bl) {
            alphaAnimation.setStartOffset(2000L);
        }
        alphaAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                TransitionView.this.setVisibility(8);
                ((ViewGroup)TransitionView.this.getParent()).removeView((View)TransitionView.this);
                if (TransitionView.this.transitionListener != null) {
                    TransitionView.this.transitionListener.run();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation((Animation)alphaAnimation);
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        return true;
    }

    private void updateBackButtonVisibility() {
        ViewGroup viewGroup = (ViewGroup)this.findViewById(R.id.transition_frame);
        this.backButton = (ImageButton)viewGroup.findViewById(R.id.back_button);
        if (this.backButtonListener == null) {
            this.backButton.setVisibility(8);
            this.backButton.setTag(null);
            this.backButton.setOnClickListener(null);
            return;
        }
        this.backButton.setTag((Object)this.backButtonListener);
        this.backButton.setVisibility(0);
        this.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TransitionView.this.backButtonListener.run();
            }
        });
    }

    private static boolean isPortrait(int n) {
        return Math.abs(n - 180) > 135;
    }

    private static boolean isLandscapeLeft(int n) {
        return Math.abs(n - 270) < 5;
    }

    private static boolean isLandscapeRight(int n) {
        return Math.abs(n - 90) < 5;
    }
}

