/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.view.Display;
import android.view.WindowManager;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.cardboard.ConfigUtils;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.sdk.proto.nano.Display;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PpiOverrides {
    private static final boolean DEBUG = false;
    private static final String TAG = PpiOverrides.class.getSimpleName();
    private static ArrayList<Size> supportedDisplaySizes = null;
    private static final List<PpiOverride> PPI_OVERRIDES = Arrays.asList(new PpiOverride("Micromax", null, "4560MMX", null, 217.0f, 217.0f), new PpiOverride("HTC", "endeavoru", "HTC One X", null, 312.0f, 312.0f), new PpiOverride("samsung", null, "SM-G920P", null, 575.0f, 575.0f), new PpiOverride("samsung", null, "SM-G930", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G9300", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930A", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930F", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930P", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930R4", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930T", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930V", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930W8", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-N915FY", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915A", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915T", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915K", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915T", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915G", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915D", null, 541.0f, 541.0f), new PpiOverride("BLU", "BLU", "Studio 5.0 HD LTE", "qcom", 294.0f, 294.0f), new PpiOverride("OnePlus", "A0001", "A0001", "bacon", 401.0f, 401.0f), new PpiOverride("THL", "THL", "thl 5000", "mt6592", 441.0f, 441.0f), new PpiOverride("Google", "sailfish", "Pixel", "sailfish", 441.74f, 441.74f), new PpiOverride("Google", "marlin", "Pixel XL", "marlin", 537.57f, 537.57f), new PpiOverride("Google", "walleye", null, "walleye", 441.74f, 441.74f));

    private PpiOverrides() {
    }

    static boolean getPpiOverride(List<PpiOverride> list, String string2, String string3, String string4, String string5, Display.DisplayParams displayParams) {
        for (PpiOverride ppiOverride : list) {
            if (!ppiOverride.isMatching(string2, string3, string4, string5)) continue;
            Log.d((String)TAG, (String)String.format("Found override: {MANUFACTURER=%s, DEVICE=%s, MODEL=%s, HARDWARE=%s} : x_ppi=%f, y_ppi=%f", ppiOverride.manufacturer, ppiOverride.device, ppiOverride.model, ppiOverride.hardware, Float.valueOf(ppiOverride.xPpi), Float.valueOf(ppiOverride.yPpi)));
            displayParams.setXPpi(ppiOverride.xPpi);
            displayParams.setYPpi(ppiOverride.yPpi);
            return true;
        }
        return false;
    }

    public static Display.DisplayParams getPpiOverride(Context context) {
        Display.DisplayParams displayParams = new Display.DisplayParams();
        if (PpiOverrides.getPpiOverride(PPI_OVERRIDES, Build.MANUFACTURER, Build.DEVICE, Build.MODEL, Build.HARDWARE, displayParams)) {
            if ("samsung".equals(Build.MANUFACTURER) && Build.VERSION.SDK_INT >= 23) {
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display display = windowManager.getDefaultDisplay();
                DisplayMetrics displayMetrics = DisplayUtils.getDisplayMetricsLandscape(display);
                int n = displayMetrics.widthPixels;
                ArrayList<Size> arrayList = PpiOverrides.getSupportedDisplaySizes(display);
                if (arrayList != null) {
                    ArrayList<Size> arrayList2 = arrayList;
                    int n2 = arrayList2.size();
                    Object var7_10 = null;
                    for (int i = 0; i < n2; ++i) {
                        Size size = arrayList2.get(i);
                        Size size2 = size;
                        n = Math.max(n, Math.max(size2.getWidth(), size2.getHeight()));
                    }
                    if (displayMetrics.widthPixels != n) {
                        float f = (float)displayMetrics.widthPixels / (float)n;
                        Log.i((String)TAG, (String)new StringBuilder(61).append("Non-native screen resolution; scaling DPI by: ").append(f).toString());
                        displayParams.setXPpi(displayParams.getXPpi() * f);
                        displayParams.setYPpi(displayParams.getYPpi() * f);
                    }
                }
            }
            return displayParams;
        }
        return null;
    }

    static void registerOverridesInternal(List<PpiOverride> list, String string2, String string3, String string4, String string5) {
        Display.DisplayParams displayParams;
        Display.DisplayParams displayParams2 = ConfigUtils.readDisplayParamsFromExternalStorage();
        Display.DisplayParams displayParams3 = displayParams = displayParams2 == null ? new Display.DisplayParams() : displayParams2.clone();
        if (PpiOverrides.getPpiOverride(list, string2, string3, string4, string5, displayParams) && !MessageNano.messageNanoEquals((MessageNano)displayParams2, (MessageNano)displayParams)) {
            Log.i((String)TAG, (String)"Applying display param override.");
            ConfigUtils.writeDisplayParamsToExternalStorage(displayParams);
        }
    }

    public static void registerOverrides() {
        PpiOverrides.registerOverridesInternal(PPI_OVERRIDES, Build.MANUFACTURER, Build.DEVICE, Build.MODEL, Build.HARDWARE);
    }

    public static void setSupportedDisplaySizesForTesting(ArrayList<Size> arrayList) {
        supportedDisplaySizes = arrayList;
    }

    private static ArrayList<Size> getSupportedDisplaySizes(Display display) {
        if (display == null) {
            return null;
        }
        if (supportedDisplaySizes != null) {
            return supportedDisplaySizes;
        }
        supportedDisplaySizes = new ArrayList();
        Display.Mode[] modeArray = display.getSupportedModes();
        if (modeArray != null) {
            Display.Mode[] modeArray2 = modeArray;
            int n = modeArray.length;
            for (int i = 0; i < n; ++i) {
                Display.Mode mode = modeArray2[i];
                supportedDisplaySizes.add(new Size(mode.getPhysicalWidth(), mode.getPhysicalHeight()));
            }
        }
        return supportedDisplaySizes;
    }

    static class PpiOverride {
        String manufacturer;
        String device;
        String model;
        String hardware;
        float xPpi;
        float yPpi;

        PpiOverride(String string2, String string3, String string4, String string5, float f, float f2) {
            this.manufacturer = string2;
            this.device = string3;
            this.model = string4;
            this.hardware = string5;
            this.xPpi = f;
            this.yPpi = f2;
        }

        boolean isMatching(String string2, String string3, String string4, String string5) {
            return !(this.manufacturer != null && !this.manufacturer.equals(string2) || this.device != null && !this.device.equals(string3) || this.model != null && !this.model.equals(string4) || this.hardware != null && !this.hardware.equals(string5));
        }
    }
}

