/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import com.google.vr.cardboard.EglFactory;
import com.google.vr.ndk.base.GvrSurfaceView;
import java.util.ArrayList;

public class CardboardGLSurfaceView
extends GvrSurfaceView {
    private static final String TAG = CardboardGLSurfaceView.class.getSimpleName();
    private final DetachListener listener;
    private boolean isRendererSet;
    private boolean isDetached;
    private ArrayList<Runnable> eventQueueWhileDetached;
    private final EglFactory eglFactory;

    public CardboardGLSurfaceView(Context context, DetachListener detachListener) {
        super(context);
        this.listener = detachListener;
        this.eglFactory = new EglFactory();
        this.setEGLContextFactory(this.eglFactory);
        this.setEGLWindowSurfaceFactory(this.eglFactory);
    }

    public CardboardGLSurfaceView(Context context, AttributeSet attributeSet, DetachListener detachListener) {
        super(context, attributeSet);
        this.listener = detachListener;
        this.eglFactory = new EglFactory();
        this.setEGLContextFactory(this.eglFactory);
        this.setEGLWindowSurfaceFactory(this.eglFactory);
    }

    @Override
    public void onPause() {
        if (this.isRendererSet) {
            super.onPause();
        }
    }

    @Override
    public void onResume() {
        if (this.isRendererSet) {
            super.onResume();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isDetached = false;
        if (this.eventQueueWhileDetached != null) {
            ArrayList<Runnable> arrayList = this.eventQueueWhileDetached;
            int n = arrayList.size();
            Object var1_4 = null;
            for (int i = 0; i < n; ++i) {
                Runnable runnable = arrayList.get(i);
                Runnable runnable2 = runnable;
                super.queueEvent(runnable2);
            }
            this.eventQueueWhileDetached.clear();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        if (this.isRendererSet && this.listener != null) {
            this.listener.onSurfaceViewDetachedFromWindow();
        }
        super.onDetachedFromWindow();
        this.isDetached = true;
    }

    @Override
    public void setRenderer(GLSurfaceView.Renderer renderer) {
        super.setRenderer(renderer);
        this.isRendererSet = true;
    }

    @Override
    public void setEGLContextClientVersion(int n) {
        super.setEGLContextClientVersion(n);
        this.eglFactory.setEGLContextClientVersion(n);
    }

    @Override
    public void queueEvent(Runnable runnable) {
        if (!this.isRendererSet) {
            runnable.run();
            return;
        }
        if (this.isDetached) {
            if (this.eventQueueWhileDetached == null) {
                this.eventQueueWhileDetached = new ArrayList();
            }
            this.eventQueueWhileDetached.add(runnable);
            return;
        }
        super.queueEvent(runnable);
    }

    public boolean isDetached() {
        return this.isDetached;
    }

    public static interface DetachListener {
        public void onSurfaceViewDetachedFromWindow();
    }
}

