/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.aidl.BaseProxy;
import com.google.android.aidl.BaseStub;
import com.google.android.aidl.Codecs;
import com.google.vr.vrcore.controller.api.ControllerRequest;
import com.google.vr.vrcore.controller.api.IControllerListener;
import com.google.vr.vrcore.controller.api.IControllerServiceListener;

public interface IControllerService
extends IInterface {
    public int initialize(int var1) throws RemoteException;

    public boolean registerListener(int var1, String var2, IControllerListener var3) throws RemoteException;

    public boolean unregisterListener(String var1) throws RemoteException;

    public void onHeadTrackingRecentered(float[] var1, float[] var2) throws RemoteException;

    public boolean registerServiceListener(IControllerServiceListener var1) throws RemoteException;

    public boolean unregisterServiceListener(IControllerServiceListener var1) throws RemoteException;

    public int getNumberOfControllers() throws RemoteException;

    public void request(int var1, ControllerRequest var2) throws RemoteException;

    public static abstract class Stub
    extends BaseStub
    implements IControllerService {
        private static final String DESCRIPTOR = "com.google.vr.vrcore.controller.api.IControllerService";
        static final int TRANSACTION_initialize = 1;
        static final int TRANSACTION_registerListener = 5;
        static final int TRANSACTION_unregisterListener = 6;
        static final int TRANSACTION_onHeadTrackingRecentered = 7;
        static final int TRANSACTION_registerServiceListener = 8;
        static final int TRANSACTION_unregisterServiceListener = 9;
        static final int TRANSACTION_getNumberOfControllers = 10;
        static final int TRANSACTION_request = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IControllerService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface instanceof IControllerService) {
                return (IControllerService)iInterface;
            }
            return new Proxy(iBinder);
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            if (this.routeToSuperOrEnforceInterface(n, parcel, parcel2, n2)) {
                return true;
            }
            switch (n) {
                case 1: {
                    int n3 = parcel.readInt();
                    int n4 = this.initialize(n3);
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    break;
                }
                case 5: {
                    int n5 = parcel.readInt();
                    String string2 = parcel.readString();
                    IControllerListener iControllerListener = IControllerListener.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.registerListener(n5, string2, iControllerListener);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 6: {
                    String string3 = parcel.readString();
                    boolean bl = this.unregisterListener(string3);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 7: {
                    float[] fArray = parcel.createFloatArray();
                    float[] fArray2 = parcel.createFloatArray();
                    this.onHeadTrackingRecentered(fArray, fArray2);
                    break;
                }
                case 8: {
                    IControllerServiceListener iControllerServiceListener = IControllerServiceListener.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.registerServiceListener(iControllerServiceListener);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 9: {
                    IControllerServiceListener iControllerServiceListener = IControllerServiceListener.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = this.unregisterServiceListener(iControllerServiceListener);
                    parcel2.writeNoException();
                    Codecs.writeBoolean(parcel2, bl);
                    break;
                }
                case 10: {
                    int n6 = this.getNumberOfControllers();
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    break;
                }
                case 11: {
                    int n7 = parcel.readInt();
                    ControllerRequest controllerRequest = Codecs.createParcelable(parcel, ControllerRequest.CREATOR);
                    this.request(n7, controllerRequest);
                    parcel2.writeNoException();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public static class Proxy
        extends BaseProxy
        implements IControllerService {
            Proxy(IBinder iBinder) {
                super(iBinder, Stub.DESCRIPTOR);
            }

            @Override
            public int initialize(int n) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeInt(n);
                Parcel parcel2 = this.transactAndReadException(1, parcel);
                int n2 = parcel2.readInt();
                parcel2.recycle();
                return n2;
            }

            @Override
            public boolean registerListener(int n, String string2, IControllerListener iControllerListener) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeInt(n);
                parcel.writeString(string2);
                Codecs.writeStrongBinder(parcel, iControllerListener);
                Parcel parcel2 = this.transactAndReadException(5, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean unregisterListener(String string2) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeString(string2);
                Parcel parcel2 = this.transactAndReadException(6, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public void onHeadTrackingRecentered(float[] fArray, float[] fArray2) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeFloatArray(fArray);
                parcel.writeFloatArray(fArray2);
                this.transactOneway(7, parcel);
            }

            @Override
            public boolean registerServiceListener(IControllerServiceListener iControllerServiceListener) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeStrongBinder(parcel, iControllerServiceListener);
                Parcel parcel2 = this.transactAndReadException(8, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean unregisterServiceListener(IControllerServiceListener iControllerServiceListener) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeStrongBinder(parcel, iControllerServiceListener);
                Parcel parcel2 = this.transactAndReadException(9, parcel);
                boolean bl = Codecs.createBoolean(parcel2);
                parcel2.recycle();
                return bl;
            }

            @Override
            public int getNumberOfControllers() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Parcel parcel2 = this.transactAndReadException(10, parcel);
                int n = parcel2.readInt();
                parcel2.recycle();
                return n;
            }

            @Override
            public void request(int n, ControllerRequest controllerRequest) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeInt(n);
                Codecs.writeParcelable(parcel, controllerRequest);
                this.transactAndReadExceptionReturnVoid(11, parcel);
            }
        }
    }
}

