/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.sdk.proto.nano;

import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.ExtendableMessageNano;
import com.google.protobuf.nano.InternalNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.NanoEnumValue;
import com.google.protobuf.nano.WireFormatNano;
import java.io.IOException;

public class CardboardDevice {
    private CardboardDevice() {
    }

    public static final class ScreenAlignmentMarker
    extends ExtendableMessageNano<ScreenAlignmentMarker>
    implements Cloneable {
        private static volatile ScreenAlignmentMarker[] _emptyArray;
        private int bitField0_;
        private float horizontal_;
        private float vertical_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ScreenAlignmentMarker[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ScreenAlignmentMarker[0];
                    }
                }
            }
            return _emptyArray;
        }

        public final float getHorizontal() {
            return this.horizontal_;
        }

        public final boolean hasHorizontal() {
            return (this.bitField0_ & 1) != 0;
        }

        public final ScreenAlignmentMarker clearHorizontal() {
            this.horizontal_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public final ScreenAlignmentMarker setHorizontal(float f) {
            this.bitField0_ |= 1;
            this.horizontal_ = f;
            return this;
        }

        public final float getVertical() {
            return this.vertical_;
        }

        public final boolean hasVertical() {
            return (this.bitField0_ & 2) != 0;
        }

        public final ScreenAlignmentMarker clearVertical() {
            this.vertical_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public final ScreenAlignmentMarker setVertical(float f) {
            this.bitField0_ |= 2;
            this.vertical_ = f;
            return this;
        }

        public ScreenAlignmentMarker() {
            this.clear();
        }

        public final ScreenAlignmentMarker clear() {
            this.bitField0_ = 0;
            this.horizontal_ = 0.0f;
            this.vertical_ = 0.0f;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final ScreenAlignmentMarker clone() {
            ScreenAlignmentMarker screenAlignmentMarker;
            try {
                screenAlignmentMarker = (ScreenAlignmentMarker)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            return screenAlignmentMarker;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeFloat(1, this.horizontal_);
            }
            if ((this.bitField0_ & 2) != 0) {
                codedOutputByteBufferNano.writeFloat(2, this.vertical_);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n += CodedOutputByteBufferNano.computeFloatSize((int)1, (float)this.horizontal_);
            }
            if ((this.bitField0_ & 2) != 0) {
                n += CodedOutputByteBufferNano.computeFloatSize((int)2, (float)this.vertical_);
            }
            return n;
        }

        public final ScreenAlignmentMarker mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block5: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block5;
                        return this;
                    }
                    case 13: {
                        this.horizontal_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 1;
                        continue block5;
                    }
                    case 21: 
                }
                this.vertical_ = codedInputByteBufferNano.readFloat();
                this.bitField0_ |= 2;
            }
        }

        public static ScreenAlignmentMarker parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (ScreenAlignmentMarker)MessageNano.mergeFrom((MessageNano)new ScreenAlignmentMarker(), (byte[])byArray);
        }

        public static ScreenAlignmentMarker parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new ScreenAlignmentMarker().mergeFrom(codedInputByteBufferNano);
        }
    }

    public static final class VignetteParams
    extends ExtendableMessageNano<VignetteParams>
    implements Cloneable {
        private static volatile VignetteParams[] _emptyArray;
        private int bitField0_;
        private int condition_;
        private float value_;

        @NanoEnumValue(value=VignetteParamsCondition.class, legacy=false)
        public static int checkVignetteParamsConditionOrThrow(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    return n;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(55).append(n).append(" is not a valid enum VignetteParamsCondition").toString());
        }

        @NanoEnumValue(value=VignetteParamsCondition.class, legacy=false)
        public static int[] checkVignetteParamsConditionOrThrow(int[] nArray) {
            int[] nArray2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray2[i];
                VignetteParams.checkVignetteParamsConditionOrThrow(n2);
            }
            return nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static VignetteParams[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new VignetteParams[0];
                    }
                }
            }
            return _emptyArray;
        }

        @NanoEnumValue(value=VignetteParamsCondition.class, legacy=false)
        public final int getCondition() {
            return this.condition_;
        }

        public final VignetteParams setCondition(@NanoEnumValue(value=VignetteParamsCondition.class, legacy=false) int n) {
            this.condition_ = n;
            this.bitField0_ |= 1;
            return this;
        }

        public final boolean hasCondition() {
            return (this.bitField0_ & 1) != 0;
        }

        public final VignetteParams clearCondition() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.condition_ = 0;
            return this;
        }

        public final float getValue() {
            return this.value_;
        }

        public final boolean hasValue() {
            return (this.bitField0_ & 2) != 0;
        }

        public final VignetteParams clearValue() {
            this.value_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public final VignetteParams setValue(float f) {
            this.bitField0_ |= 2;
            this.value_ = f;
            return this;
        }

        public VignetteParams() {
            this.clear();
        }

        public final VignetteParams clear() {
            this.bitField0_ = 0;
            this.condition_ = 0;
            this.value_ = 0.0f;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final VignetteParams clone() {
            VignetteParams vignetteParams;
            try {
                vignetteParams = (VignetteParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            return vignetteParams;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeInt32(2, this.condition_);
            }
            if ((this.bitField0_ & 2) != 0) {
                codedOutputByteBufferNano.writeFloat(3, this.value_);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n += CodedOutputByteBufferNano.computeInt32Size((int)2, (int)this.condition_);
            }
            if ((this.bitField0_ & 2) != 0) {
                n += CodedOutputByteBufferNano.computeFloatSize((int)3, (float)this.value_);
            }
            return n;
        }

        public final VignetteParams mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block7: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block7;
                        return this;
                    }
                    case 16: {
                        this.bitField0_ |= 1;
                        int n2 = codedInputByteBufferNano.getPosition();
                        try {
                            this.condition_ = VignetteParams.checkVignetteParamsConditionOrThrow(codedInputByteBufferNano.readInt32());
                            this.bitField0_ |= 1;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            codedInputByteBufferNano.rewindToPosition(n2);
                            this.storeUnknownField(codedInputByteBufferNano, n);
                        }
                        continue block7;
                    }
                    case 29: 
                }
                this.value_ = codedInputByteBufferNano.readFloat();
                this.bitField0_ |= 2;
            }
        }

        public static VignetteParams parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (VignetteParams)MessageNano.mergeFrom((MessageNano)new VignetteParams(), (byte[])byArray);
        }

        public static VignetteParams parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new VignetteParams().mergeFrom(codedInputByteBufferNano);
        }

        public static interface VignetteParamsCondition {
            @NanoEnumValue(value=VignetteParamsCondition.class, legacy=false)
            public static final int NO_VIGNETTE_CONDITION = 0;
            @NanoEnumValue(value=VignetteParamsCondition.class, legacy=false)
            public static final int HORIZ_DIMEN_LESS_THAN_METER = 1;
        }
    }

    public static final class DaydreamInternalParams
    extends ExtendableMessageNano<DaydreamInternalParams>
    implements Cloneable {
        private static volatile DaydreamInternalParams[] _emptyArray;
        private int bitField0_;
        private int version_;
        public ScreenAlignmentMarker[] alignmentMarkers;
        private boolean useRotationalAlignmentCorrection_;
        private boolean sensorOrientationIndependentOfDisplay_;
        public VignetteParams vignetteParams;
        private int distortionMeshResolution_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DaydreamInternalParams[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DaydreamInternalParams[0];
                    }
                }
            }
            return _emptyArray;
        }

        public final int getVersion() {
            return this.version_;
        }

        public final boolean hasVersion() {
            return (this.bitField0_ & 1) != 0;
        }

        public final DaydreamInternalParams clearVersion() {
            this.version_ = 0;
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public final DaydreamInternalParams setVersion(int n) {
            this.bitField0_ |= 1;
            this.version_ = n;
            return this;
        }

        public final boolean getUseRotationalAlignmentCorrection() {
            return this.useRotationalAlignmentCorrection_;
        }

        public final boolean hasUseRotationalAlignmentCorrection() {
            return (this.bitField0_ & 2) != 0;
        }

        public final DaydreamInternalParams clearUseRotationalAlignmentCorrection() {
            this.useRotationalAlignmentCorrection_ = false;
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public final DaydreamInternalParams setUseRotationalAlignmentCorrection(boolean bl) {
            this.bitField0_ |= 2;
            this.useRotationalAlignmentCorrection_ = bl;
            return this;
        }

        public final boolean getSensorOrientationIndependentOfDisplay() {
            return this.sensorOrientationIndependentOfDisplay_;
        }

        public final boolean hasSensorOrientationIndependentOfDisplay() {
            return (this.bitField0_ & 4) != 0;
        }

        public final DaydreamInternalParams clearSensorOrientationIndependentOfDisplay() {
            this.sensorOrientationIndependentOfDisplay_ = false;
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public final DaydreamInternalParams setSensorOrientationIndependentOfDisplay(boolean bl) {
            this.bitField0_ |= 4;
            this.sensorOrientationIndependentOfDisplay_ = bl;
            return this;
        }

        public final int getDistortionMeshResolution() {
            return this.distortionMeshResolution_;
        }

        public final boolean hasDistortionMeshResolution() {
            return (this.bitField0_ & 8) != 0;
        }

        public final DaydreamInternalParams clearDistortionMeshResolution() {
            this.distortionMeshResolution_ = 40;
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        public final DaydreamInternalParams setDistortionMeshResolution(int n) {
            this.bitField0_ |= 8;
            this.distortionMeshResolution_ = n;
            return this;
        }

        public DaydreamInternalParams() {
            this.clear();
        }

        public final DaydreamInternalParams clear() {
            this.bitField0_ = 0;
            this.version_ = 0;
            this.alignmentMarkers = ScreenAlignmentMarker.emptyArray();
            this.useRotationalAlignmentCorrection_ = false;
            this.sensorOrientationIndependentOfDisplay_ = false;
            this.vignetteParams = null;
            this.distortionMeshResolution_ = 40;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final DaydreamInternalParams clone() {
            DaydreamInternalParams daydreamInternalParams;
            try {
                daydreamInternalParams = (DaydreamInternalParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.alignmentMarkers != null && this.alignmentMarkers.length > 0) {
                daydreamInternalParams.alignmentMarkers = new ScreenAlignmentMarker[this.alignmentMarkers.length];
                for (int i = 0; i < this.alignmentMarkers.length; ++i) {
                    if (this.alignmentMarkers[i] == null) continue;
                    daydreamInternalParams.alignmentMarkers[i] = this.alignmentMarkers[i].clone();
                }
            }
            if (this.vignetteParams != null) {
                daydreamInternalParams.vignetteParams = this.vignetteParams.clone();
            }
            return daydreamInternalParams;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeInt32(1, this.version_);
            }
            if (this.alignmentMarkers != null && this.alignmentMarkers.length > 0) {
                for (int i = 0; i < this.alignmentMarkers.length; ++i) {
                    ScreenAlignmentMarker screenAlignmentMarker = this.alignmentMarkers[i];
                    if (screenAlignmentMarker == null) continue;
                    codedOutputByteBufferNano.writeMessage(2, (MessageNano)screenAlignmentMarker);
                }
            }
            if ((this.bitField0_ & 2) != 0) {
                codedOutputByteBufferNano.writeBool(3, this.useRotationalAlignmentCorrection_);
            }
            if ((this.bitField0_ & 4) != 0) {
                codedOutputByteBufferNano.writeBool(4, this.sensorOrientationIndependentOfDisplay_);
            }
            if (this.vignetteParams != null) {
                codedOutputByteBufferNano.writeMessage(5, (MessageNano)this.vignetteParams);
            }
            if ((this.bitField0_ & 8) != 0) {
                codedOutputByteBufferNano.writeInt32(6, this.distortionMeshResolution_);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n += CodedOutputByteBufferNano.computeInt32Size((int)1, (int)this.version_);
            }
            if (this.alignmentMarkers != null && this.alignmentMarkers.length > 0) {
                for (int i = 0; i < this.alignmentMarkers.length; ++i) {
                    ScreenAlignmentMarker screenAlignmentMarker = this.alignmentMarkers[i];
                    if (screenAlignmentMarker == null) continue;
                    n += CodedOutputByteBufferNano.computeMessageSize((int)2, (MessageNano)screenAlignmentMarker);
                }
            }
            if ((this.bitField0_ & 2) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)3, (boolean)this.useRotationalAlignmentCorrection_);
            }
            if ((this.bitField0_ & 4) != 0) {
                n += CodedOutputByteBufferNano.computeBoolSize((int)4, (boolean)this.sensorOrientationIndependentOfDisplay_);
            }
            if (this.vignetteParams != null) {
                n += CodedOutputByteBufferNano.computeMessageSize((int)5, (MessageNano)this.vignetteParams);
            }
            if ((this.bitField0_ & 8) != 0) {
                n += CodedOutputByteBufferNano.computeInt32Size((int)6, (int)this.distortionMeshResolution_);
            }
            return n;
        }

        public final DaydreamInternalParams mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block9: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block9;
                        return this;
                    }
                    case 8: {
                        this.version_ = codedInputByteBufferNano.readInt32();
                        this.bitField0_ |= 1;
                        continue block9;
                    }
                    case 18: {
                        int n2 = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)codedInputByteBufferNano, (int)18);
                        int n3 = this.alignmentMarkers == null ? 0 : this.alignmentMarkers.length;
                        ScreenAlignmentMarker[] screenAlignmentMarkerArray = new ScreenAlignmentMarker[n3 + n2];
                        if (n3 != 0) {
                            System.arraycopy(this.alignmentMarkers, 0, screenAlignmentMarkerArray, 0, n3);
                        }
                        while (n3 < screenAlignmentMarkerArray.length - 1) {
                            screenAlignmentMarkerArray[n3] = new ScreenAlignmentMarker();
                            codedInputByteBufferNano.readMessage((MessageNano)screenAlignmentMarkerArray[n3]);
                            codedInputByteBufferNano.readTag();
                            ++n3;
                        }
                        screenAlignmentMarkerArray[n3] = new ScreenAlignmentMarker();
                        codedInputByteBufferNano.readMessage((MessageNano)screenAlignmentMarkerArray[n3]);
                        this.alignmentMarkers = screenAlignmentMarkerArray;
                        continue block9;
                    }
                    case 24: {
                        this.useRotationalAlignmentCorrection_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 2;
                        continue block9;
                    }
                    case 32: {
                        this.sensorOrientationIndependentOfDisplay_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 4;
                        continue block9;
                    }
                    case 42: {
                        if (this.vignetteParams == null) {
                            this.vignetteParams = new VignetteParams();
                        }
                        codedInputByteBufferNano.readMessage((MessageNano)this.vignetteParams);
                        continue block9;
                    }
                    case 48: 
                }
                this.distortionMeshResolution_ = codedInputByteBufferNano.readInt32();
                this.bitField0_ |= 8;
            }
        }

        public static DaydreamInternalParams parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (DaydreamInternalParams)MessageNano.mergeFrom((MessageNano)new DaydreamInternalParams(), (byte[])byArray);
        }

        public static DaydreamInternalParams parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new DaydreamInternalParams().mergeFrom(codedInputByteBufferNano);
        }
    }

    public static final class CardboardInternalParams
    extends ExtendableMessageNano<CardboardInternalParams>
    implements Cloneable {
        private static volatile CardboardInternalParams[] _emptyArray;
        private int bitField0_;
        @NanoEnumValue(value=OrientationType.class, legacy=false)
        public int[] eyeOrientations;
        private float screenCenterToLensDistance_;
        private float xPpiOverride_;
        private float yPpiOverride_;
        private String accelerometer_;
        private String gyroscope_;

        @NanoEnumValue(value=OrientationType.class, legacy=false)
        public static int checkOrientationTypeOrThrow(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return n;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(47).append(n).append(" is not a valid enum OrientationType").toString());
        }

        @NanoEnumValue(value=OrientationType.class, legacy=false)
        public static int[] checkOrientationTypeOrThrow(int[] nArray) {
            int[] nArray2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray2[i];
                CardboardInternalParams.checkOrientationTypeOrThrow(n2);
            }
            return nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CardboardInternalParams[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new CardboardInternalParams[0];
                    }
                }
            }
            return _emptyArray;
        }

        public final float getScreenCenterToLensDistance() {
            return this.screenCenterToLensDistance_;
        }

        public final boolean hasScreenCenterToLensDistance() {
            return (this.bitField0_ & 1) != 0;
        }

        public final CardboardInternalParams clearScreenCenterToLensDistance() {
            this.screenCenterToLensDistance_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public final CardboardInternalParams setScreenCenterToLensDistance(float f) {
            this.bitField0_ |= 1;
            this.screenCenterToLensDistance_ = f;
            return this;
        }

        public final float getXPpiOverride() {
            return this.xPpiOverride_;
        }

        public final boolean hasXPpiOverride() {
            return (this.bitField0_ & 2) != 0;
        }

        public final CardboardInternalParams clearXPpiOverride() {
            this.xPpiOverride_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public final CardboardInternalParams setXPpiOverride(float f) {
            this.bitField0_ |= 2;
            this.xPpiOverride_ = f;
            return this;
        }

        public final float getYPpiOverride() {
            return this.yPpiOverride_;
        }

        public final boolean hasYPpiOverride() {
            return (this.bitField0_ & 4) != 0;
        }

        public final CardboardInternalParams clearYPpiOverride() {
            this.yPpiOverride_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public final CardboardInternalParams setYPpiOverride(float f) {
            this.bitField0_ |= 4;
            this.yPpiOverride_ = f;
            return this;
        }

        public final String getAccelerometer() {
            return this.accelerometer_;
        }

        public final boolean hasAccelerometer() {
            return (this.bitField0_ & 8) != 0;
        }

        public final CardboardInternalParams clearAccelerometer() {
            this.accelerometer_ = "";
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        public final CardboardInternalParams setAccelerometer(String string2) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.accelerometer_ = string2;
            return this;
        }

        public final String getGyroscope() {
            return this.gyroscope_;
        }

        public final boolean hasGyroscope() {
            return (this.bitField0_ & 0x10) != 0;
        }

        public final CardboardInternalParams clearGyroscope() {
            this.gyroscope_ = "";
            this.bitField0_ &= 0xFFFFFFEF;
            return this;
        }

        public final CardboardInternalParams setGyroscope(String string2) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.gyroscope_ = string2;
            return this;
        }

        public CardboardInternalParams() {
            this.clear();
        }

        public final CardboardInternalParams clear() {
            this.bitField0_ = 0;
            this.eyeOrientations = WireFormatNano.EMPTY_INT_ARRAY;
            this.screenCenterToLensDistance_ = 0.0f;
            this.xPpiOverride_ = 0.0f;
            this.yPpiOverride_ = 0.0f;
            this.accelerometer_ = "";
            this.gyroscope_ = "";
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final CardboardInternalParams clone() {
            CardboardInternalParams cardboardInternalParams;
            try {
                cardboardInternalParams = (CardboardInternalParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.eyeOrientations != null && this.eyeOrientations.length > 0) {
                cardboardInternalParams.eyeOrientations = (int[])this.eyeOrientations.clone();
            }
            return cardboardInternalParams;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            if (this.eyeOrientations != null && this.eyeOrientations.length > 0) {
                int n;
                int n2 = 0;
                for (n = 0; n < this.eyeOrientations.length; ++n) {
                    int n3 = this.eyeOrientations[n];
                    n2 += CodedOutputByteBufferNano.computeInt32SizeNoTag((int)n3);
                }
                codedOutputByteBufferNano.writeRawVarint32(10);
                codedOutputByteBufferNano.writeRawVarint32(n2);
                for (n = 0; n < this.eyeOrientations.length; ++n) {
                    codedOutputByteBufferNano.writeRawVarint32(this.eyeOrientations[n]);
                }
            }
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeFloat(2, this.screenCenterToLensDistance_);
            }
            if ((this.bitField0_ & 2) != 0) {
                codedOutputByteBufferNano.writeFloat(3, this.xPpiOverride_);
            }
            if ((this.bitField0_ & 4) != 0) {
                codedOutputByteBufferNano.writeFloat(4, this.yPpiOverride_);
            }
            if ((this.bitField0_ & 8) != 0) {
                codedOutputByteBufferNano.writeString(5, this.accelerometer_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                codedOutputByteBufferNano.writeString(6, this.gyroscope_);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n = super.computeSerializedSize();
            if (this.eyeOrientations != null && this.eyeOrientations.length > 0) {
                int n2 = 0;
                for (int i = 0; i < this.eyeOrientations.length; ++i) {
                    int n3 = this.eyeOrientations[i];
                    n2 += CodedOutputByteBufferNano.computeInt32SizeNoTag((int)n3);
                }
                n += n2;
                ++n;
                n += CodedOutputByteBufferNano.computeRawVarint32Size((int)n2);
            }
            if ((this.bitField0_ & 1) != 0) {
                n += CodedOutputByteBufferNano.computeFloatSize((int)2, (float)this.screenCenterToLensDistance_);
            }
            if ((this.bitField0_ & 2) != 0) {
                n += CodedOutputByteBufferNano.computeFloatSize((int)3, (float)this.xPpiOverride_);
            }
            if ((this.bitField0_ & 4) != 0) {
                n += CodedOutputByteBufferNano.computeFloatSize((int)4, (float)this.yPpiOverride_);
            }
            if ((this.bitField0_ & 8) != 0) {
                n += CodedOutputByteBufferNano.computeStringSize((int)5, (String)this.accelerometer_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                n += CodedOutputByteBufferNano.computeStringSize((int)6, (String)this.gyroscope_);
            }
            return n;
        }

        public final CardboardInternalParams mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block16: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block16;
                        return this;
                    }
                    case 8: {
                        int n2;
                        int n3 = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)codedInputByteBufferNano, (int)8);
                        int[] nArray = new int[n3];
                        int n4 = 0;
                        for (n2 = 0; n2 < n3; ++n2) {
                            if (n2 != 0) {
                                codedInputByteBufferNano.readTag();
                            }
                            int n5 = codedInputByteBufferNano.getPosition();
                            try {
                                nArray[n4] = CardboardInternalParams.checkOrientationTypeOrThrow(codedInputByteBufferNano.readInt32());
                                ++n4;
                                continue;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                codedInputByteBufferNano.rewindToPosition(n5);
                                this.storeUnknownField(codedInputByteBufferNano, n);
                            }
                        }
                        if (n4 == 0) continue block16;
                        n2 = this.eyeOrientations == null ? 0 : this.eyeOrientations.length;
                        if (n2 == 0 && n4 == n3) {
                            this.eyeOrientations = nArray;
                            continue block16;
                        }
                        int[] nArray2 = new int[n2 + n4];
                        if (n2 != 0) {
                            System.arraycopy(this.eyeOrientations, 0, nArray2, 0, n2);
                        }
                        System.arraycopy(nArray, 0, nArray2, n2, n4);
                        this.eyeOrientations = nArray2;
                        continue block16;
                    }
                    case 10: {
                        int n3 = codedInputByteBufferNano.readRawVarint32();
                        int n6 = codedInputByteBufferNano.pushLimit(n3);
                        int n4 = 0;
                        int n2 = codedInputByteBufferNano.getPosition();
                        while (codedInputByteBufferNano.getBytesUntilLimit() > 0) {
                            try {
                                CardboardInternalParams.checkOrientationTypeOrThrow(codedInputByteBufferNano.readInt32());
                                ++n4;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        if (n4 != 0) {
                            codedInputByteBufferNano.rewindToPosition(n2);
                            int n7 = this.eyeOrientations == null ? 0 : this.eyeOrientations.length;
                            int[] nArray = new int[n7 + n4];
                            if (n7 != 0) {
                                System.arraycopy(this.eyeOrientations, 0, nArray, 0, n7);
                            }
                            while (codedInputByteBufferNano.getBytesUntilLimit() > 0) {
                                int n8 = codedInputByteBufferNano.getPosition();
                                try {
                                    nArray[n7] = CardboardInternalParams.checkOrientationTypeOrThrow(codedInputByteBufferNano.readInt32());
                                    ++n7;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    codedInputByteBufferNano.rewindToPosition(n8);
                                    this.storeUnknownField(codedInputByteBufferNano, 8);
                                }
                            }
                            this.eyeOrientations = nArray;
                        }
                        codedInputByteBufferNano.popLimit(n6);
                        continue block16;
                    }
                    case 21: {
                        this.screenCenterToLensDistance_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 1;
                        continue block16;
                    }
                    case 29: {
                        this.xPpiOverride_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 2;
                        continue block16;
                    }
                    case 37: {
                        this.yPpiOverride_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 4;
                        continue block16;
                    }
                    case 42: {
                        this.accelerometer_ = codedInputByteBufferNano.readString();
                        this.bitField0_ |= 8;
                        continue block16;
                    }
                    case 50: 
                }
                this.gyroscope_ = codedInputByteBufferNano.readString();
                this.bitField0_ |= 0x10;
            }
        }

        public static CardboardInternalParams parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (CardboardInternalParams)MessageNano.mergeFrom((MessageNano)new CardboardInternalParams(), (byte[])byArray);
        }

        public static CardboardInternalParams parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new CardboardInternalParams().mergeFrom(codedInputByteBufferNano);
        }

        public static interface OrientationType {
            @NanoEnumValue(value=OrientationType.class, legacy=false)
            public static final int CCW_0_DEGREES = 0;
            @NanoEnumValue(value=OrientationType.class, legacy=false)
            public static final int CCW_90_DEGREES = 1;
            @NanoEnumValue(value=OrientationType.class, legacy=false)
            public static final int CCW_180_DEGREES = 2;
            @NanoEnumValue(value=OrientationType.class, legacy=false)
            public static final int CCW_270_DEGREES = 3;
            @NanoEnumValue(value=OrientationType.class, legacy=false)
            public static final int CCW_0_DEGREES_MIRRORED = 4;
            @NanoEnumValue(value=OrientationType.class, legacy=false)
            public static final int CCW_90_DEGREES_MIRRORED = 5;
            @NanoEnumValue(value=OrientationType.class, legacy=false)
            public static final int CCW_180_DEGREES_MIRRORED = 6;
            @NanoEnumValue(value=OrientationType.class, legacy=false)
            public static final int CCW_270_DEGREES_MIRRORED = 7;
        }
    }

    public static final class DeviceParams
    extends ExtendableMessageNano<DeviceParams>
    implements Cloneable {
        private static volatile DeviceParams[] _emptyArray;
        private int bitField0_;
        private String vendor_;
        private String model_;
        private float screenToLensDistance_;
        private float interLensDistance_;
        public float[] leftEyeFieldOfViewAngles;
        private int verticalAlignment_;
        private float trayToLensDistance_;
        public float[] distortionCoefficients;
        public float[] greenDistortionCoefficients;
        public float[] blueDistortionCoefficients;
        private boolean hasMagnet_;
        private int primaryButton_;
        public CardboardInternalParams internal;
        public DaydreamInternalParams daydreamInternal;

        @NanoEnumValue(value=VerticalAlignmentType.class, legacy=false)
        public static int checkVerticalAlignmentTypeOrThrow(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    return n;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(53).append(n).append(" is not a valid enum VerticalAlignmentType").toString());
        }

        @NanoEnumValue(value=VerticalAlignmentType.class, legacy=false)
        public static int[] checkVerticalAlignmentTypeOrThrow(int[] nArray) {
            int[] nArray2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray2[i];
                DeviceParams.checkVerticalAlignmentTypeOrThrow(n2);
            }
            return nArray;
        }

        @NanoEnumValue(value=ButtonType.class, legacy=false)
        public static int checkButtonTypeOrThrow(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return n;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(42).append(n).append(" is not a valid enum ButtonType").toString());
        }

        @NanoEnumValue(value=ButtonType.class, legacy=false)
        public static int[] checkButtonTypeOrThrow(int[] nArray) {
            int[] nArray2 = nArray;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray2[i];
                DeviceParams.checkButtonTypeOrThrow(n2);
            }
            return nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DeviceParams[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DeviceParams[0];
                    }
                }
            }
            return _emptyArray;
        }

        public final String getVendor() {
            return this.vendor_;
        }

        public final boolean hasVendor() {
            return (this.bitField0_ & 1) != 0;
        }

        public final DeviceParams clearVendor() {
            this.vendor_ = "";
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public final DeviceParams setVendor(String string2) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.vendor_ = string2;
            return this;
        }

        public final String getModel() {
            return this.model_;
        }

        public final boolean hasModel() {
            return (this.bitField0_ & 2) != 0;
        }

        public final DeviceParams clearModel() {
            this.model_ = "";
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public final DeviceParams setModel(String string2) {
            if (string2 == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.model_ = string2;
            return this;
        }

        public final float getScreenToLensDistance() {
            return this.screenToLensDistance_;
        }

        public final boolean hasScreenToLensDistance() {
            return (this.bitField0_ & 4) != 0;
        }

        public final DeviceParams clearScreenToLensDistance() {
            this.screenToLensDistance_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public final DeviceParams setScreenToLensDistance(float f) {
            this.bitField0_ |= 4;
            this.screenToLensDistance_ = f;
            return this;
        }

        public final float getInterLensDistance() {
            return this.interLensDistance_;
        }

        public final boolean hasInterLensDistance() {
            return (this.bitField0_ & 8) != 0;
        }

        public final DeviceParams clearInterLensDistance() {
            this.interLensDistance_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        public final DeviceParams setInterLensDistance(float f) {
            this.bitField0_ |= 8;
            this.interLensDistance_ = f;
            return this;
        }

        @NanoEnumValue(value=VerticalAlignmentType.class, legacy=false)
        public final int getVerticalAlignment() {
            return this.verticalAlignment_;
        }

        public final DeviceParams setVerticalAlignment(@NanoEnumValue(value=VerticalAlignmentType.class, legacy=false) int n) {
            this.verticalAlignment_ = n;
            this.bitField0_ |= 0x10;
            return this;
        }

        public final boolean hasVerticalAlignment() {
            return (this.bitField0_ & 0x10) != 0;
        }

        public final DeviceParams clearVerticalAlignment() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.verticalAlignment_ = 0;
            return this;
        }

        public final float getTrayToLensDistance() {
            return this.trayToLensDistance_;
        }

        public final boolean hasTrayToLensDistance() {
            return (this.bitField0_ & 0x20) != 0;
        }

        public final DeviceParams clearTrayToLensDistance() {
            this.trayToLensDistance_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFDF;
            return this;
        }

        public final DeviceParams setTrayToLensDistance(float f) {
            this.bitField0_ |= 0x20;
            this.trayToLensDistance_ = f;
            return this;
        }

        public final boolean getHasMagnet() {
            return this.hasMagnet_;
        }

        public final boolean hasHasMagnet() {
            return (this.bitField0_ & 0x40) != 0;
        }

        public final DeviceParams clearHasMagnet() {
            this.hasMagnet_ = false;
            this.bitField0_ &= 0xFFFFFFBF;
            return this;
        }

        public final DeviceParams setHasMagnet(boolean bl) {
            this.bitField0_ |= 0x40;
            this.hasMagnet_ = bl;
            return this;
        }

        @NanoEnumValue(value=ButtonType.class, legacy=false)
        public final int getPrimaryButton() {
            return this.primaryButton_;
        }

        public final DeviceParams setPrimaryButton(@NanoEnumValue(value=ButtonType.class, legacy=false) int n) {
            this.primaryButton_ = n;
            this.bitField0_ |= 0x80;
            return this;
        }

        public final boolean hasPrimaryButton() {
            return (this.bitField0_ & 0x80) != 0;
        }

        public final DeviceParams clearPrimaryButton() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.primaryButton_ = 1;
            return this;
        }

        public DeviceParams() {
            this.clear();
        }

        public final DeviceParams clear() {
            this.bitField0_ = 0;
            this.vendor_ = "";
            this.model_ = "";
            this.screenToLensDistance_ = 0.0f;
            this.interLensDistance_ = 0.0f;
            this.leftEyeFieldOfViewAngles = WireFormatNano.EMPTY_FLOAT_ARRAY;
            this.verticalAlignment_ = 0;
            this.trayToLensDistance_ = 0.0f;
            this.distortionCoefficients = WireFormatNano.EMPTY_FLOAT_ARRAY;
            this.greenDistortionCoefficients = WireFormatNano.EMPTY_FLOAT_ARRAY;
            this.blueDistortionCoefficients = WireFormatNano.EMPTY_FLOAT_ARRAY;
            this.hasMagnet_ = false;
            this.primaryButton_ = 1;
            this.internal = null;
            this.daydreamInternal = null;
            this.unknownFieldData = null;
            this.cachedSize = -1;
            return this;
        }

        public final DeviceParams clone() {
            DeviceParams deviceParams;
            try {
                deviceParams = (DeviceParams)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
            if (this.leftEyeFieldOfViewAngles != null && this.leftEyeFieldOfViewAngles.length > 0) {
                deviceParams.leftEyeFieldOfViewAngles = (float[])this.leftEyeFieldOfViewAngles.clone();
            }
            if (this.distortionCoefficients != null && this.distortionCoefficients.length > 0) {
                deviceParams.distortionCoefficients = (float[])this.distortionCoefficients.clone();
            }
            if (this.greenDistortionCoefficients != null && this.greenDistortionCoefficients.length > 0) {
                deviceParams.greenDistortionCoefficients = (float[])this.greenDistortionCoefficients.clone();
            }
            if (this.blueDistortionCoefficients != null && this.blueDistortionCoefficients.length > 0) {
                deviceParams.blueDistortionCoefficients = (float[])this.blueDistortionCoefficients.clone();
            }
            if (this.internal != null) {
                deviceParams.internal = this.internal.clone();
            }
            if (this.daydreamInternal != null) {
                deviceParams.daydreamInternal = this.daydreamInternal.clone();
            }
            return deviceParams;
        }

        public final void writeTo(CodedOutputByteBufferNano codedOutputByteBufferNano) throws IOException {
            int n;
            int n2;
            if ((this.bitField0_ & 1) != 0) {
                codedOutputByteBufferNano.writeString(1, this.vendor_);
            }
            if ((this.bitField0_ & 2) != 0) {
                codedOutputByteBufferNano.writeString(2, this.model_);
            }
            if ((this.bitField0_ & 4) != 0) {
                codedOutputByteBufferNano.writeFloat(3, this.screenToLensDistance_);
            }
            if ((this.bitField0_ & 8) != 0) {
                codedOutputByteBufferNano.writeFloat(4, this.interLensDistance_);
            }
            if (this.leftEyeFieldOfViewAngles != null && this.leftEyeFieldOfViewAngles.length > 0) {
                n2 = 4 * this.leftEyeFieldOfViewAngles.length;
                codedOutputByteBufferNano.writeRawVarint32(42);
                codedOutputByteBufferNano.writeRawVarint32(n2);
                for (n = 0; n < this.leftEyeFieldOfViewAngles.length; ++n) {
                    codedOutputByteBufferNano.writeFloatNoTag(this.leftEyeFieldOfViewAngles[n]);
                }
            }
            if ((this.bitField0_ & 0x20) != 0) {
                codedOutputByteBufferNano.writeFloat(6, this.trayToLensDistance_);
            }
            if (this.distortionCoefficients != null && this.distortionCoefficients.length > 0) {
                n2 = 4 * this.distortionCoefficients.length;
                codedOutputByteBufferNano.writeRawVarint32(58);
                codedOutputByteBufferNano.writeRawVarint32(n2);
                for (n = 0; n < this.distortionCoefficients.length; ++n) {
                    codedOutputByteBufferNano.writeFloatNoTag(this.distortionCoefficients[n]);
                }
            }
            if (this.greenDistortionCoefficients != null && this.greenDistortionCoefficients.length > 0) {
                n2 = 4 * this.greenDistortionCoefficients.length;
                codedOutputByteBufferNano.writeRawVarint32(66);
                codedOutputByteBufferNano.writeRawVarint32(n2);
                for (n = 0; n < this.greenDistortionCoefficients.length; ++n) {
                    codedOutputByteBufferNano.writeFloatNoTag(this.greenDistortionCoefficients[n]);
                }
            }
            if (this.blueDistortionCoefficients != null && this.blueDistortionCoefficients.length > 0) {
                n2 = 4 * this.blueDistortionCoefficients.length;
                codedOutputByteBufferNano.writeRawVarint32(74);
                codedOutputByteBufferNano.writeRawVarint32(n2);
                for (n = 0; n < this.blueDistortionCoefficients.length; ++n) {
                    codedOutputByteBufferNano.writeFloatNoTag(this.blueDistortionCoefficients[n]);
                }
            }
            if ((this.bitField0_ & 0x40) != 0) {
                codedOutputByteBufferNano.writeBool(10, this.hasMagnet_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                codedOutputByteBufferNano.writeInt32(11, this.verticalAlignment_);
            }
            if ((this.bitField0_ & 0x80) != 0) {
                codedOutputByteBufferNano.writeInt32(12, this.primaryButton_);
            }
            if (this.internal != null) {
                codedOutputByteBufferNano.writeMessage(1729, (MessageNano)this.internal);
            }
            if (this.daydreamInternal != null) {
                codedOutputByteBufferNano.writeMessage(196883, (MessageNano)this.daydreamInternal);
            }
            super.writeTo(codedOutputByteBufferNano);
        }

        protected final int computeSerializedSize() {
            int n;
            int n2 = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                n2 += CodedOutputByteBufferNano.computeStringSize((int)1, (String)this.vendor_);
            }
            if ((this.bitField0_ & 2) != 0) {
                n2 += CodedOutputByteBufferNano.computeStringSize((int)2, (String)this.model_);
            }
            if ((this.bitField0_ & 4) != 0) {
                n2 += CodedOutputByteBufferNano.computeFloatSize((int)3, (float)this.screenToLensDistance_);
            }
            if ((this.bitField0_ & 8) != 0) {
                n2 += CodedOutputByteBufferNano.computeFloatSize((int)4, (float)this.interLensDistance_);
            }
            if (this.leftEyeFieldOfViewAngles != null && this.leftEyeFieldOfViewAngles.length > 0) {
                n = 4 * this.leftEyeFieldOfViewAngles.length;
                n2 += n;
                ++n2;
                n2 += CodedOutputByteBufferNano.computeRawVarint32Size((int)n);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                n2 += CodedOutputByteBufferNano.computeFloatSize((int)6, (float)this.trayToLensDistance_);
            }
            if (this.distortionCoefficients != null && this.distortionCoefficients.length > 0) {
                n = 4 * this.distortionCoefficients.length;
                n2 += n;
                ++n2;
                n2 += CodedOutputByteBufferNano.computeRawVarint32Size((int)n);
            }
            if (this.greenDistortionCoefficients != null && this.greenDistortionCoefficients.length > 0) {
                n = 4 * this.greenDistortionCoefficients.length;
                n2 += n;
                ++n2;
                n2 += CodedOutputByteBufferNano.computeRawVarint32Size((int)n);
            }
            if (this.blueDistortionCoefficients != null && this.blueDistortionCoefficients.length > 0) {
                n = 4 * this.blueDistortionCoefficients.length;
                n2 += n;
                ++n2;
                n2 += CodedOutputByteBufferNano.computeRawVarint32Size((int)n);
            }
            if ((this.bitField0_ & 0x40) != 0) {
                n2 += CodedOutputByteBufferNano.computeBoolSize((int)10, (boolean)this.hasMagnet_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                n2 += CodedOutputByteBufferNano.computeInt32Size((int)11, (int)this.verticalAlignment_);
            }
            if ((this.bitField0_ & 0x80) != 0) {
                n2 += CodedOutputByteBufferNano.computeInt32Size((int)12, (int)this.primaryButton_);
            }
            if (this.internal != null) {
                n2 += CodedOutputByteBufferNano.computeMessageSize((int)1729, (MessageNano)this.internal);
            }
            if (this.daydreamInternal != null) {
                n2 += CodedOutputByteBufferNano.computeMessageSize((int)196883, (MessageNano)this.daydreamInternal);
            }
            return n2;
        }

        public final DeviceParams mergeFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            block25: while (true) {
                int n = codedInputByteBufferNano.readTag();
                switch (n) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (super.storeUnknownField(codedInputByteBufferNano, n)) continue block25;
                        return this;
                    }
                    case 10: {
                        this.vendor_ = codedInputByteBufferNano.readString();
                        this.bitField0_ |= 1;
                        continue block25;
                    }
                    case 18: {
                        this.model_ = codedInputByteBufferNano.readString();
                        this.bitField0_ |= 2;
                        continue block25;
                    }
                    case 29: {
                        this.screenToLensDistance_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 4;
                        continue block25;
                    }
                    case 37: {
                        this.interLensDistance_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 8;
                        continue block25;
                    }
                    case 45: {
                        int n2 = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)codedInputByteBufferNano, (int)45);
                        int n3 = this.leftEyeFieldOfViewAngles == null ? 0 : this.leftEyeFieldOfViewAngles.length;
                        float[] fArray = new float[n3 + n2];
                        if (n3 != 0) {
                            System.arraycopy(this.leftEyeFieldOfViewAngles, 0, fArray, 0, n3);
                        }
                        while (n3 < fArray.length - 1) {
                            fArray[n3] = codedInputByteBufferNano.readFloat();
                            codedInputByteBufferNano.readTag();
                            ++n3;
                        }
                        fArray[n3] = codedInputByteBufferNano.readFloat();
                        this.leftEyeFieldOfViewAngles = fArray;
                        continue block25;
                    }
                    case 42: {
                        int n2 = codedInputByteBufferNano.readRawVarint32();
                        int n3 = codedInputByteBufferNano.pushLimit(n2);
                        int n4 = n2 / 4;
                        int n5 = this.leftEyeFieldOfViewAngles == null ? 0 : this.leftEyeFieldOfViewAngles.length;
                        float[] fArray = new float[n5 + n4];
                        if (n5 != 0) {
                            System.arraycopy(this.leftEyeFieldOfViewAngles, 0, fArray, 0, n5);
                        }
                        while (n5 < fArray.length) {
                            fArray[n5] = codedInputByteBufferNano.readFloat();
                            ++n5;
                        }
                        this.leftEyeFieldOfViewAngles = fArray;
                        codedInputByteBufferNano.popLimit(n3);
                        continue block25;
                    }
                    case 53: {
                        this.trayToLensDistance_ = codedInputByteBufferNano.readFloat();
                        this.bitField0_ |= 0x20;
                        continue block25;
                    }
                    case 61: {
                        int n2 = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)codedInputByteBufferNano, (int)61);
                        int n3 = this.distortionCoefficients == null ? 0 : this.distortionCoefficients.length;
                        float[] fArray = new float[n3 + n2];
                        if (n3 != 0) {
                            System.arraycopy(this.distortionCoefficients, 0, fArray, 0, n3);
                        }
                        while (n3 < fArray.length - 1) {
                            fArray[n3] = codedInputByteBufferNano.readFloat();
                            codedInputByteBufferNano.readTag();
                            ++n3;
                        }
                        fArray[n3] = codedInputByteBufferNano.readFloat();
                        this.distortionCoefficients = fArray;
                        continue block25;
                    }
                    case 58: {
                        int n2 = codedInputByteBufferNano.readRawVarint32();
                        int n3 = codedInputByteBufferNano.pushLimit(n2);
                        int n6 = n2 / 4;
                        int n5 = this.distortionCoefficients == null ? 0 : this.distortionCoefficients.length;
                        float[] fArray = new float[n5 + n6];
                        if (n5 != 0) {
                            System.arraycopy(this.distortionCoefficients, 0, fArray, 0, n5);
                        }
                        while (n5 < fArray.length) {
                            fArray[n5] = codedInputByteBufferNano.readFloat();
                            ++n5;
                        }
                        this.distortionCoefficients = fArray;
                        codedInputByteBufferNano.popLimit(n3);
                        continue block25;
                    }
                    case 69: {
                        int n2 = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)codedInputByteBufferNano, (int)69);
                        int n3 = this.greenDistortionCoefficients == null ? 0 : this.greenDistortionCoefficients.length;
                        float[] fArray = new float[n3 + n2];
                        if (n3 != 0) {
                            System.arraycopy(this.greenDistortionCoefficients, 0, fArray, 0, n3);
                        }
                        while (n3 < fArray.length - 1) {
                            fArray[n3] = codedInputByteBufferNano.readFloat();
                            codedInputByteBufferNano.readTag();
                            ++n3;
                        }
                        fArray[n3] = codedInputByteBufferNano.readFloat();
                        this.greenDistortionCoefficients = fArray;
                        continue block25;
                    }
                    case 66: {
                        int n2 = codedInputByteBufferNano.readRawVarint32();
                        int n3 = codedInputByteBufferNano.pushLimit(n2);
                        int n7 = n2 / 4;
                        int n5 = this.greenDistortionCoefficients == null ? 0 : this.greenDistortionCoefficients.length;
                        float[] fArray = new float[n5 + n7];
                        if (n5 != 0) {
                            System.arraycopy(this.greenDistortionCoefficients, 0, fArray, 0, n5);
                        }
                        while (n5 < fArray.length) {
                            fArray[n5] = codedInputByteBufferNano.readFloat();
                            ++n5;
                        }
                        this.greenDistortionCoefficients = fArray;
                        codedInputByteBufferNano.popLimit(n3);
                        continue block25;
                    }
                    case 77: {
                        int n2 = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)codedInputByteBufferNano, (int)77);
                        int n3 = this.blueDistortionCoefficients == null ? 0 : this.blueDistortionCoefficients.length;
                        float[] fArray = new float[n3 + n2];
                        if (n3 != 0) {
                            System.arraycopy(this.blueDistortionCoefficients, 0, fArray, 0, n3);
                        }
                        while (n3 < fArray.length - 1) {
                            fArray[n3] = codedInputByteBufferNano.readFloat();
                            codedInputByteBufferNano.readTag();
                            ++n3;
                        }
                        fArray[n3] = codedInputByteBufferNano.readFloat();
                        this.blueDistortionCoefficients = fArray;
                        continue block25;
                    }
                    case 74: {
                        int n2 = codedInputByteBufferNano.readRawVarint32();
                        int n3 = codedInputByteBufferNano.pushLimit(n2);
                        int n8 = n2 / 4;
                        int n5 = this.blueDistortionCoefficients == null ? 0 : this.blueDistortionCoefficients.length;
                        float[] fArray = new float[n5 + n8];
                        if (n5 != 0) {
                            System.arraycopy(this.blueDistortionCoefficients, 0, fArray, 0, n5);
                        }
                        while (n5 < fArray.length) {
                            fArray[n5] = codedInputByteBufferNano.readFloat();
                            ++n5;
                        }
                        this.blueDistortionCoefficients = fArray;
                        codedInputByteBufferNano.popLimit(n3);
                        continue block25;
                    }
                    case 80: {
                        this.hasMagnet_ = codedInputByteBufferNano.readBool();
                        this.bitField0_ |= 0x40;
                        continue block25;
                    }
                    case 88: {
                        this.bitField0_ |= 0x10;
                        int n2 = codedInputByteBufferNano.getPosition();
                        try {
                            this.verticalAlignment_ = DeviceParams.checkVerticalAlignmentTypeOrThrow(codedInputByteBufferNano.readInt32());
                            this.bitField0_ |= 0x10;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            codedInputByteBufferNano.rewindToPosition(n2);
                            this.storeUnknownField(codedInputByteBufferNano, n);
                        }
                        continue block25;
                    }
                    case 96: {
                        this.bitField0_ |= 0x80;
                        int n2 = codedInputByteBufferNano.getPosition();
                        try {
                            this.primaryButton_ = DeviceParams.checkButtonTypeOrThrow(codedInputByteBufferNano.readInt32());
                            this.bitField0_ |= 0x80;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            codedInputByteBufferNano.rewindToPosition(n2);
                            this.storeUnknownField(codedInputByteBufferNano, n);
                        }
                        continue block25;
                    }
                    case 13834: {
                        if (this.internal == null) {
                            this.internal = new CardboardInternalParams();
                        }
                        codedInputByteBufferNano.readMessage((MessageNano)this.internal);
                        continue block25;
                    }
                    case 1575066: 
                }
                if (this.daydreamInternal == null) {
                    this.daydreamInternal = new DaydreamInternalParams();
                }
                codedInputByteBufferNano.readMessage((MessageNano)this.daydreamInternal);
            }
        }

        public static DeviceParams parseFrom(byte[] byArray) throws InvalidProtocolBufferNanoException {
            return (DeviceParams)MessageNano.mergeFrom((MessageNano)new DeviceParams(), (byte[])byArray);
        }

        public static DeviceParams parseFrom(CodedInputByteBufferNano codedInputByteBufferNano) throws IOException {
            return new DeviceParams().mergeFrom(codedInputByteBufferNano);
        }

        public static interface ButtonType {
            @NanoEnumValue(value=ButtonType.class, legacy=false)
            public static final int NONE = 0;
            @NanoEnumValue(value=ButtonType.class, legacy=false)
            public static final int MAGNET = 1;
            @NanoEnumValue(value=ButtonType.class, legacy=false)
            public static final int TOUCH = 2;
            @NanoEnumValue(value=ButtonType.class, legacy=false)
            public static final int INDIRECT_TOUCH = 3;
        }

        public static interface VerticalAlignmentType {
            @NanoEnumValue(value=VerticalAlignmentType.class, legacy=false)
            public static final int BOTTOM = 0;
            @NanoEnumValue(value=VerticalAlignmentType.class, legacy=false)
            public static final int CENTER = 1;
            @NanoEnumValue(value=VerticalAlignmentType.class, legacy=false)
            public static final int TOP = 2;
        }
    }
}

