/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.Activity;
import android.content.Context;
import android.os.RemoteException;
import android.view.View;
import com.google.vr.cardboard.UiUtils;
import com.google.vr.cardboard.annotations.UsedByReflection;
import com.google.vr.vrcore.library.api.IGvrUiLayout;
import com.google.vr.vrcore.library.api.ObjectWrapper;

@UsedByReflection(value="Unity")
public class GvrUiLayout {
    private final IGvrUiLayout impl;

    GvrUiLayout(IGvrUiLayout iGvrUiLayout) {
        this.impl = iGvrUiLayout;
    }

    public static void launchOrInstallGvrApp(Activity activity) {
        UiUtils.launchOrInstallCardboard((Context)activity);
    }

    public void setEnabled(boolean bl) {
        try {
            this.impl.setEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public boolean isEnabled() {
        try {
            return this.impl.isEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    @UsedByReflection(value="Unity")
    public void setCloseButtonListener(Runnable runnable) {
        try {
            this.impl.setCloseButtonListener(ObjectWrapper.wrap(runnable));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    @UsedByReflection(value="Unity")
    public void setTransitionViewEnabled(boolean bl) {
        try {
            this.impl.setTransitionViewEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setTransitionViewListener(Runnable runnable) {
        try {
            this.impl.setTransitionViewListener(ObjectWrapper.wrap(runnable));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setSettingsButtonEnabled(boolean bl) {
        try {
            this.impl.setSettingsButtonEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setSettingsButtonListener(Runnable runnable) {
        try {
            this.impl.setSettingsButtonListener(ObjectWrapper.wrap(runnable));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setViewerName(String string2) {
        try {
            this.impl.setViewerName(string2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        try {
            ObjectWrapper.unwrap(this.impl.getRootView(), View.class).setOnTouchListener(onTouchListener);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }
}

