/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import android.util.Log;
import com.google.common.logging.nano.Vr$VREvent$SdkConfigurationParams;
import com.google.vr.cardboard.VrContextWrapper;
import com.google.vr.ndk.base.ExtensionManager;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayoutImpl;
import com.google.vr.ndk.base.GvrLayoutImplWrapper;
import com.google.vr.ndk.base.SdkConfigurationReader;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.base.api.VrCoreUtils;
import com.google.vr.vrcore.library.api.IGvrLayout;
import com.google.vr.vrcore.library.api.IVrCreator;
import com.google.vr.vrcore.library.api.ObjectWrapper;
import com.google.vr.vrcore.library.api.VrCoreLoader;

public class GvrLayoutFactory {
    private static final String TAG = "GvrLayoutFactory";
    static final int MIN_VRCORE_API_VERSION = 17;

    public GvrLayoutFactory() {
    }

    public static IGvrLayout create(Context context) {
        IGvrLayout iGvrLayout = GvrLayoutFactory.tryCreateFromVrCorePackage(context);
        if (iGvrLayout == null) {
            if (GvrApi.usingShimLibrary()) {
                throw new IllegalStateException("Client shim failed to load GvrLayout from VrCore.");
            }
            iGvrLayout = GvrLayoutFactory.createFromCurrentPackage(context);
            Log.d((String)TAG, (String)"Loaded GvrLayout from SDK.");
        }
        return iGvrLayout;
    }

    public static IGvrLayout createFromCurrentPackageWithExtensions(Context context, ExtensionManager extensionManager) {
        return new GvrLayoutImplWrapper(new GvrLayoutImpl(context, extensionManager));
    }

    private static IGvrLayout createFromCurrentPackage(Context context) {
        return new GvrLayoutImplWrapper(new GvrLayoutImpl(context));
    }

    private static IGvrLayout tryCreateFromVrCorePackage(Context context) {
        if (VrCoreUtils.isVrCorePackage(context.getPackageName())) {
            return GvrLayoutFactory.createFromCurrentPackage(context);
        }
        if (context instanceof VrContextWrapper) {
            throw new IllegalArgumentException("VrContextWrapper only supported within VrCore.");
        }
        if (!GvrApi.usingDynamicLibrary(context)) {
            Log.v((String)TAG, (String)"Dynamic library loading disabled, using built-in GvrLayout implementation.");
            return null;
        }
        Vr$VREvent$SdkConfigurationParams vr$VREvent$SdkConfigurationParams = SdkConfigurationReader.getParams(context);
        if (!(vr$VREvent$SdkConfigurationParams.allowDynamicJavaLibraryLoading != null && vr$VREvent$SdkConfigurationParams.allowDynamicJavaLibraryLoading.booleanValue() || GvrApi.usingShimLibrary())) {
            Log.v((String)TAG, (String)"Dynamic Java library loading disabled, using built-in GvrLayout implementation.");
            return null;
        }
        try {
            if (VrCoreUtils.getVrCoreClientApiVersion(context) < 17) {
                Log.d((String)TAG, (String)"VrCore outdated, using built-in GvrLayout implementation.");
                return null;
            }
        }
        catch (VrCoreNotAvailableException vrCoreNotAvailableException) {
            Log.d((String)TAG, (String)"VrCore unavailable, using built-in GvrLayout implementation.");
            return null;
        }
        try {
            Context context2 = VrCoreLoader.getRemoteContext(context);
            IVrCreator iVrCreator = VrCoreLoader.getRemoteCreator(context);
            IGvrLayout iGvrLayout = iVrCreator.newGvrLayout(ObjectWrapper.wrap(context2), ObjectWrapper.wrap(context));
            if (iGvrLayout != null) {
                Log.i((String)TAG, (String)"Successfully loaded GvrLayout from VrCore.");
            } else {
                Log.w((String)TAG, (String)"GvrLayout creation from VrCore failed.");
            }
            return iGvrLayout;
        }
        catch (Exception exception) {
            String string2 = String.valueOf(exception);
            Log.e((String)TAG, (String)new StringBuilder(40 + String.valueOf(string2).length()).append("Failed to load GvrLayout from VrCore:\n  ").append(string2).toString());
            return null;
        }
    }
}

