/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.View;
import android.widget.FrameLayout;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.VrContextWrapper;
import com.google.vr.cardboard.annotations.UsedByReflection;
import com.google.vr.ndk.base.ExternalSurface;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrLayoutFactory;
import com.google.vr.ndk.base.GvrLayoutImpl;
import com.google.vr.ndk.base.GvrLayoutImplWrapper;
import com.google.vr.ndk.base.GvrUiLayout;
import com.google.vr.ndk.base.TraceCompat;
import com.google.vr.vrcore.library.api.IGvrLayout;
import com.google.vr.vrcore.library.api.ObjectWrapper;

@UsedByReflection(value="Unity")
public class GvrLayout
extends FrameLayout {
    private static final String TAG = "GvrLayout";
    private IGvrLayout impl;
    private GvrUiLayout uiLayout;
    private GvrApi gvrApi;
    private ExternalSurface videoSurface;

    public GvrLayout(Context context) {
        super(context);
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            throw new IllegalArgumentException("An Activity Context is required for VR functionality.");
        }
        this.init();
    }

    public GvrLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        Activity activity = ContextUtils.getActivity(context);
        if (activity == null) {
            throw new IllegalArgumentException("An Activity Context is required for VR functionality.");
        }
        this.init();
    }

    public GvrLayout(VrContextWrapper vrContextWrapper) {
        super((Context)vrContextWrapper);
        this.init();
    }

    GvrLayout(Context context, GvrLayoutImpl gvrLayoutImpl, GvrApi gvrApi) {
        super(context);
        this.impl = new GvrLayoutImplWrapper(gvrLayoutImpl);
        this.gvrApi = gvrApi;
        this.init();
    }

    private void init() {
        TraceCompat.beginSection("GvrLayout.init");
        try {
            if (this.impl == null) {
                this.impl = GvrLayoutFactory.create(this.getContext());
            }
            this.uiLayout = new GvrUiLayout(this.impl.getUiLayout());
            if (this.gvrApi == null) {
                this.gvrApi = new GvrApi(this.getContext(), this.impl.getNativeGvrContext());
            }
            this.addView(ObjectWrapper.unwrap(this.impl.getRootView(), View.class));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        finally {
            TraceCompat.endSection();
        }
    }

    @UsedByReflection(value="Unity")
    public GvrUiLayout getUiLayout() {
        return this.uiLayout;
    }

    @UsedByReflection(value="Unity")
    public void onPause() {
        TraceCompat.beginSection("GvrLayout.onPause");
        try {
            this.impl.onPause();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        finally {
            TraceCompat.endSection();
        }
    }

    @UsedByReflection(value="Unity")
    public void onResume() {
        TraceCompat.beginSection("GvrLayout.onResume");
        try {
            this.impl.onResume();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        finally {
            TraceCompat.endSection();
        }
    }

    public void onBackPressed() {
        try {
            this.impl.onBackPressed();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    @UsedByReflection(value="Unity")
    public void shutdown() {
        TraceCompat.beginSection("GvrLayout.shutdown");
        try {
            if (this.videoSurface != null) {
                this.videoSurface.shutdown();
                this.videoSurface = null;
            }
            this.impl.shutdown();
            this.gvrApi.shutdown();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        finally {
            TraceCompat.endSection();
        }
    }

    @UsedByReflection(value="Unity")
    public void setPresentationView(View view) {
        try {
            this.impl.setPresentationView(ObjectWrapper.wrap(view));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setFixedPresentationSurfaceSize(int n, int n2) {
        this.getGvrApi().setSurfaceSize(n, n2);
    }

    public boolean enableAsyncReprojectionVideoSurface(ExternalSurfaceListener externalSurfaceListener, Handler handler, boolean bl) {
        int n = bl ? 1 : 0;
        try {
            if (!this.impl.enableAsyncReprojection(n)) {
                return false;
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
        if (!this.gvrApi.isFeatureSupported(2)) {
            Log.e((String)TAG, (String)"External Surfaces are unsupported. Cannot enable video Surface.");
            return false;
        }
        this.videoSurface = this.gvrApi.createExternalSurface(externalSurfaceListener, handler);
        return true;
    }

    @UsedByReflection(value="Unity")
    public boolean setAsyncReprojectionEnabled(boolean bl) {
        if (!bl) {
            if (this.gvrApi.getAsyncReprojectionEnabled()) {
                throw new UnsupportedOperationException("Async reprojection cannot be disabled once enabled.");
            }
            return true;
        }
        try {
            return this.impl.enableAsyncReprojection(0);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    @UsedByReflection(value="Unity")
    public boolean enableAsyncReprojectionProtected() {
        try {
            return this.impl.enableAsyncReprojection(1);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public boolean enableCardboardTriggerEmulation(Runnable runnable) {
        try {
            return this.impl.enableCardboardTriggerEmulation(ObjectWrapper.wrap(runnable));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public int getAsyncReprojectionVideoSurfaceId() {
        if (this.videoSurface == null) {
            Log.w((String)TAG, (String)"Async reprojection video is not enabled. Did you call enableAsyncReprojectionVideoSurface()?");
            return -1;
        }
        return this.videoSurface.getId();
    }

    public Surface getAsyncReprojectionVideoSurface() {
        if (this.videoSurface == null) {
            Log.w((String)TAG, (String)"Async reprojection video is not enabled. Did you call enableAsyncReprojectionVideoSurface()?");
            return null;
        }
        return this.videoSurface.getSurface();
    }

    @UsedByReflection(value="Unity")
    public GvrApi getGvrApi() {
        return this.gvrApi;
    }

    public void setStereoModeEnabled(boolean bl) {
        try {
            this.impl.setStereoModeEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public void setReentryIntent(PendingIntent pendingIntent) {
        try {
            this.impl.setReentryIntent(ObjectWrapper.wrap(pendingIntent));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public int setOnDonNotNeededListener(Runnable runnable) {
        try {
            boolean bl = this.impl.setOnDonNotNeededListener(ObjectWrapper.wrap(runnable));
            if (bl) {
                return 3;
            }
            return 2;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Unable to call setOnDonNotNeededListener(); probably an old VrCore build.");
            return 1;
        }
    }

    public static final class SetOnDonNotNeededListenerResult {
        public static final int API_NOT_SUPPORTED = 1;
        public static final int DON_NOT_SUPPORTED = 2;
        public static final int SUCCESS = 3;

        private SetOnDonNotNeededListenerResult() {
        }
    }

    public static interface ExternalSurfaceListener {
        public void onSurfaceAvailable(Surface var1);

        public void onFrameAvailable();
    }
}

