/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.os.Build;
import android.util.Log;
import com.google.protobuf.nano.MessageNano;
import com.google.vr.cardboard.ConfigUtils;
import com.google.vr.sdk.proto.nano.Phone;
import java.util.Arrays;
import java.util.List;

public class PhoneParams {
    private static final boolean DEBUG = false;
    private static final String TAG = PhoneParams.class.getSimpleName();
    private static final List<PpiOverride> PPI_OVERRIDES = Arrays.asList(new PpiOverride("Micromax", null, "4560MMX", null, 217.0f, 217.0f), new PpiOverride("HTC", "endeavoru", "HTC One X", null, 312.0f, 312.0f), new PpiOverride("samsung", null, "SM-G920P", null, 575.0f, 575.0f), new PpiOverride("samsung", null, "SM-G930", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G9300", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930A", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930F", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930P", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930R4", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930T", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930V", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-G930W8", null, 581.0f, 580.0f), new PpiOverride("samsung", null, "SM-N915FY", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915A", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915T", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915K", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915T", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915G", null, 541.0f, 541.0f), new PpiOverride("samsung", null, "SM-N915D", null, 541.0f, 541.0f), new PpiOverride("BLU", "BLU", "Studio 5.0 HD LTE", "qcom", 294.0f, 294.0f), new PpiOverride("OnePlus", "A0001", "A0001", "bacon", 401.0f, 401.0f), new PpiOverride("THL", "THL", "thl 5000", "mt6592", 441.0f, 441.0f), new PpiOverride("Google", "sailfish", "Pixel", "sailfish", 441.74f, 441.74f), new PpiOverride("Google", "marlin", "Pixel XL", "marlin", 537.57f, 537.57f), new PpiOverride("Google", "walleye", null, "walleye", 441.74f, 441.74f));

    private PhoneParams() {
    }

    static boolean getPpiOverride(List<PpiOverride> list, String string2, String string3, String string4, String string5, Phone.PhoneParams phoneParams) {
        for (PpiOverride ppiOverride : list) {
            if (!ppiOverride.isMatching(string2, string3, string4, string5)) continue;
            Log.d((String)TAG, (String)String.format("Found override: {MANUFACTURER=%s, DEVICE=%s, MODEL=%s, HARDWARE=%s} : x_ppi=%f, y_ppi=%f", ppiOverride.manufacturer, ppiOverride.device, ppiOverride.model, ppiOverride.hardware, Float.valueOf(ppiOverride.xPpi), Float.valueOf(ppiOverride.yPpi)));
            phoneParams.setXPpi(ppiOverride.xPpi);
            phoneParams.setYPpi(ppiOverride.yPpi);
            return true;
        }
        return false;
    }

    static void registerOverridesInternal(List<PpiOverride> list, String string2, String string3, String string4, String string5) {
        Phone.PhoneParams phoneParams;
        Phone.PhoneParams phoneParams2 = ConfigUtils.readPhoneParamsFromExternalStorage();
        Phone.PhoneParams phoneParams3 = phoneParams = phoneParams2 == null ? new Phone.PhoneParams() : phoneParams2.clone();
        if (PhoneParams.getPpiOverride(list, string2, string3, string4, string5, phoneParams) && !MessageNano.messageNanoEquals((MessageNano)phoneParams2, (MessageNano)phoneParams)) {
            Log.i((String)TAG, (String)"Applying phone param override.");
            ConfigUtils.writePhoneParamsToExternalStorage(phoneParams);
        }
    }

    public static void registerOverrides() {
        PhoneParams.registerOverridesInternal(PPI_OVERRIDES, Build.MANUFACTURER, Build.DEVICE, Build.MODEL, Build.HARDWARE);
    }

    public static Phone.PhoneParams getPpiOverride() {
        Phone.PhoneParams phoneParams = new Phone.PhoneParams();
        if (PhoneParams.getPpiOverride(PPI_OVERRIDES, Build.MANUFACTURER, Build.DEVICE, Build.MODEL, Build.HARDWARE, phoneParams)) {
            return phoneParams;
        }
        return null;
    }

    static class PpiOverride {
        String manufacturer;
        String device;
        String model;
        String hardware;
        float xPpi;
        float yPpi;

        PpiOverride(String string2, String string3, String string4, String string5, float f, float f2) {
            this.manufacturer = string2;
            this.device = string3;
            this.model = string4;
            this.hardware = string5;
            this.xPpi = f;
            this.yPpi = f2;
        }

        boolean isMatching(String string2, String string3, String string4, String string5) {
            return !(this.manufacturer != null && !this.manufacturer.equals(string2) || this.device != null && !this.device.equals(string3) || this.model != null && !this.model.equals(string4) || this.hardware != null && !this.hardware.equals(string5));
        }
    }
}

