/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.opengl.GLES20;
import android.util.Log;
import com.google.vr.cardboard.UsedByNative;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

@UsedByNative
public class EglReadyListener {
    private static final String TAG = "EglReadyListener";
    private static final int GL_CONTEXT_FLAGS = 33310;
    private static final int DEFAULT_GL_MAJOR_VERSION = 2;
    private volatile EGLContext eglContext;
    private volatile int eglContextFlags;
    private volatile int glVersion = 2;
    private final Object contextInfoLock = new Object();
    private volatile EventListener listener;
    private final Object listenerLock = new Object();

    public EglReadyListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventListener(EventListener eventListener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener = eventListener;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEventListener() {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listener = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByNative
    public void onEglReady() {
        Object object = this.contextInfoLock;
        synchronized (object) {
            this.eglContext = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
            if (this.eglContext == null || this.eglContext == EGL10.EGL_NO_CONTEXT) {
                Log.e((String)TAG, (String)"Unable to obtain the application's OpenGL context.");
            }
            String string2 = GLES20.glGetString((int)7938);
            this.glVersion = EglReadyListener.parseVersionString(string2);
            int[] nArray = new int[1];
            GLES20.glGetIntegerv((int)33310, (int[])nArray, (int)0);
            GLES20.glGetError();
            this.eglContextFlags = nArray[0];
        }
        object = this.listenerLock;
        synchronized (object) {
            if (this.listener != null) {
                this.listener.onEglReady();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContext() {
        Object object = this.contextInfoLock;
        synchronized (object) {
            this.eglContext = null;
            this.glVersion = 2;
            this.eglContextFlags = 0;
            return;
        }
    }

    public EGLContext getEGLContext() {
        return this.eglContext;
    }

    public int getEGLContextFlags() {
        return this.eglContextFlags;
    }

    public int getGLVersion() {
        return this.glVersion;
    }

    public static int parseVersionString(String string2) {
        if (string2 == null) {
            Log.e((String)TAG, (String)"Unable to determine the OpenGL major version.");
            return 2;
        }
        int n = string2.indexOf(46);
        if (n <= 0) {
            Log.e((String)TAG, (String)"Unable to determine the OpenGL major version.");
            return 2;
        }
        int n2 = Character.getNumericValue(string2.charAt(n - 1));
        if (n2 < 0) {
            Log.e((String)TAG, (String)"Unable to determine the OpenGL major version.");
            return 2;
        }
        return n2;
    }

    public static interface EventListener {
        public void onEglReady();
    }
}

