/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.Log;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EglFactory
implements GLSurfaceView.EGLContextFactory,
GLSurfaceView.EGLWindowSurfaceFactory {
    private static final String TAG = "GvrEglFactory";
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_CONTEXT_PRIORITY_LEVEL = 12544;
    private static final int EGL_CONTEXT_PRIORITY_HIGH = 12545;
    private static final int EGL_PROTECTED_CONTENT_EXT = 12992;
    private static final int EGL_CONTEXT_OPENGL_NO_ERROR_KHR = 12723;
    private static final int MIN_REQUIRED_CONTEXT_CLIENT_VERSION = 2;
    private boolean usePriority = false;
    private boolean useProtected = false;
    private boolean errorReportingEnabled = true;
    private int eglContextClientVersion = 2;
    private EGLContext sharedContext = EGL10.EGL_NO_CONTEXT;

    public EglFactory() {
    }

    public void setUsePriorityContext(boolean bl) {
        this.usePriority = bl;
    }

    public void setUseProtectedBuffers(boolean bl) {
        if (bl && Build.VERSION.SDK_INT < 17) {
            throw new RuntimeException("Protected buffer support requires EGL 1.4, available only on Jelly Bean MR1 and later.");
        }
        this.useProtected = bl;
    }

    public void setSharedContext(EGLContext eGLContext) {
        this.sharedContext = eGLContext;
    }

    public void setErrorReportingEnabled(boolean bl) {
        this.errorReportingEnabled = bl;
    }

    public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
        String string2;
        IntBuffer intBuffer = IntBuffer.allocate(8);
        intBuffer.put(12440);
        intBuffer.put(this.eglContextClientVersion);
        if (this.usePriority) {
            if (Build.FINGERPRINT.contains("generic_x86")) {
                Log.w((String)TAG, (String)"EGL_CONTEXT_PRIORITY_LEVEL not supported on emulators.");
            } else {
                intBuffer.put(12544);
                intBuffer.put(12545);
            }
        }
        if (this.useProtected && this.supportsProtectedContent(eGL10, eGLDisplay)) {
            intBuffer.put(12992);
            intBuffer.put(1);
        }
        if (!this.errorReportingEnabled && (string2 = eGL10.eglQueryString(eGLDisplay, 12373)).contains("EGL_KHR_create_context_no_error")) {
            intBuffer.put(12723);
            intBuffer.put(1);
        }
        while (intBuffer.hasRemaining()) {
            intBuffer.put(12344);
        }
        string2 = eGL10.eglCreateContext(eGLDisplay, eGLConfig, this.sharedContext, intBuffer.array());
        if ((string2 == null || string2 == EGL10.EGL_NO_CONTEXT) && this.eglContextClientVersion > 2) {
            int n = this.eglContextClientVersion;
            Log.w((String)TAG, (String)new StringBuilder(65).append("Failed to create EGL context with version ").append(n).append(", will try 2").toString());
            intBuffer.array()[1] = 2;
            string2 = eGL10.eglCreateContext(eGLDisplay, eGLConfig, this.sharedContext, intBuffer.array());
        }
        return string2;
    }

    public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
        eGL10.eglDestroyContext(eGLDisplay, eGLContext);
    }

    public EGLSurface createWindowSurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
        EGLSurface eGLSurface = null;
        int[] nArray = null;
        if (this.useProtected && this.supportsProtectedContent(eGL10, eGLDisplay)) {
            nArray = new int[]{12992, 1, 12344};
        }
        try {
            eGLSurface = eGL10.eglCreateWindowSurface(eGLDisplay, eGLConfig, object, nArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)TAG, (String)"eglCreateWindowSurface", (Throwable)illegalArgumentException);
        }
        return eGLSurface;
    }

    public void destroySurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
        eGL10.eglDestroySurface(eGLDisplay, eGLSurface);
    }

    public void setEGLContextClientVersion(int n) {
        this.eglContextClientVersion = n;
    }

    private boolean supportsProtectedContent(EGL10 eGL10, EGLDisplay eGLDisplay) {
        String string2 = eGL10.eglQueryString(eGLDisplay, 12373);
        return string2.contains("EGL_EXT_protected_content");
    }
}

