/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.Context;
import android.content.res.Resources;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.google.vr.sdk.proto.nano.Phone;

public class DisplayUtils {
    public static final String EXTERNAL_DISPLAY_RESOURCE_NAME = "display_manager_hdmi_display_name";
    private static final float METERS_PER_INCH = 0.0254f;
    private static final float DEFAULT_BORDER_SIZE_METERS = 0.003f;

    public DisplayUtils() {
    }

    public static Display getDefaultDisplay(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    public static DisplayMetrics getDisplayMetricsLandscape(Display display) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(displayMetrics);
        } else {
            display.getMetrics(displayMetrics);
        }
        if (displayMetrics.widthPixels < displayMetrics.heightPixels) {
            int n = displayMetrics.widthPixels;
            displayMetrics.widthPixels = displayMetrics.heightPixels;
            displayMetrics.heightPixels = n;
        }
        float f = displayMetrics.xdpi;
        displayMetrics.xdpi = displayMetrics.ydpi;
        displayMetrics.ydpi = f;
        return displayMetrics;
    }

    public static DisplayMetrics getDisplayMetricsLandscapeWithOverride(Display display, Phone.PhoneParams phoneParams) {
        DisplayMetrics displayMetrics = DisplayUtils.getDisplayMetricsLandscape(display);
        if (phoneParams != null) {
            if (phoneParams.hasXPpi()) {
                displayMetrics.xdpi = phoneParams.getXPpi();
            }
            if (phoneParams.hasYPpi()) {
                displayMetrics.ydpi = phoneParams.getYPpi();
            }
        }
        return displayMetrics;
    }

    public static float getBorderSizeMeters(Phone.PhoneParams phoneParams) {
        if (phoneParams != null && phoneParams.hasBottomBezelHeight()) {
            return phoneParams.getBottomBezelHeight();
        }
        return 0.003f;
    }

    public static float getMetersPerPixelFromDotsPerInch(float f) {
        return 0.0254f / f;
    }

    public static String getExternalDisplayName(Context context) {
        Resources resources = context.getResources();
        int n = resources.getIdentifier(EXTERNAL_DISPLAY_RESOURCE_NAME, "string", "android");
        try {
            return resources.getString(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            return null;
        }
    }

    public static boolean hasExternalDisplay(Context context) {
        if (Build.VERSION.SDK_INT <= 16) {
            return false;
        }
        String string2 = DisplayUtils.getExternalDisplayName(context);
        if (string2 == null) {
            return false;
        }
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        for (Display display : displayManager.getDisplays()) {
            if (!display.getName().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameDisplay(Display display, Display display2) {
        if (display == display2) {
            return true;
        }
        if (display == null || display2 == null) {
            return false;
        }
        if (display.getDisplayId() != display2.getDisplayId() || display.getFlags() != display2.getFlags() || display.isValid() != display2.isValid() || !display.getName().equals(display2.getName())) {
            return false;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        DisplayMetrics displayMetrics2 = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        display2.getMetrics(displayMetrics2);
        return displayMetrics.equals(displayMetrics2);
    }
}

