/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.audio;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.util.Log;
import com.google.vr.cardboard.annotations.UsedByNative;

@UsedByNative
public class DeviceInfo {
    private static final String TAG = "DeviceInfo";
    private static final int DEFAULT_SAMPLE_RATE = 48000;
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private final long nativeObject;
    private final Context context;
    private final BroadcastReceiver headphoneStateReceiver;

    private DeviceInfo(long l, Context context) {
        this.nativeObject = l;
        this.context = context;
        this.headphoneStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.HEADSET_PLUG")) {
                    int n = intent.getIntExtra("state", -1);
                    switch (n) {
                        case 0: {
                            DeviceInfo.this.nativeUpdateHeadphoneStateChange(DeviceInfo.this.nativeObject, 2);
                            return;
                        }
                        case 1: {
                            DeviceInfo.this.nativeUpdateHeadphoneStateChange(DeviceInfo.this.nativeObject, 1);
                            return;
                        }
                    }
                    DeviceInfo.this.nativeUpdateHeadphoneStateChange(DeviceInfo.this.nativeObject, 0);
                }
            }
        };
    }

    @UsedByNative
    private static DeviceInfo createDeviceInfo(long l, Context context) {
        return new DeviceInfo(l, context);
    }

    @UsedByNative
    private void registerHandlers() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        this.context.registerReceiver(this.headphoneStateReceiver, intentFilter);
    }

    @UsedByNative
    private void unregisterHandlers() {
        this.context.unregisterReceiver(this.headphoneStateReceiver);
    }

    @UsedByNative
    private boolean isHeadphonePluggedIn() {
        AudioDeviceInfo[] audioDeviceInfoArray;
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        AudioDeviceInfo[] audioDeviceInfoArray2 = audioDeviceInfoArray = audioManager.getDevices(2);
        int n = audioDeviceInfoArray.length;
        for (int i = 0; i < n; ++i) {
            AudioDeviceInfo audioDeviceInfo = audioDeviceInfoArray2[i];
            if (audioDeviceInfo.getType() != 4 && audioDeviceInfo.getType() != 3 && audioDeviceInfo.getType() != 22) continue;
            return true;
        }
        return false;
    }

    @UsedByNative
    private int getSystemSampleRate() {
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        String string2 = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        if (string2 == null) {
            Log.w((String)TAG, (String)"Could not obtain system sample rate, defaulting to 48000");
            return 48000;
        }
        return Integer.parseInt(string2);
    }

    @UsedByNative
    private int getSystemBufferSize() {
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        String string2 = audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        if (string2 == null) {
            Log.w((String)TAG, (String)"Could not obtain system buffer size, defaulting to 256");
            return 256;
        }
        return Integer.parseInt(string2);
    }

    @UsedByNative
    private boolean isBluetoothAudioDevicePluggedIn() {
        AudioDeviceInfo[] audioDeviceInfoArray;
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        AudioDeviceInfo[] audioDeviceInfoArray2 = audioDeviceInfoArray = audioManager.getDevices(2);
        int n = audioDeviceInfoArray.length;
        for (int i = 0; i < n; ++i) {
            AudioDeviceInfo audioDeviceInfo = audioDeviceInfoArray2[i];
            if (audioDeviceInfo.getType() != 8) continue;
            return true;
        }
        return false;
    }

    private native void nativeUpdateHeadphoneStateChange(long var1, int var3);

    static abstract class HeadphoneState {
        public static final int UNKNOWN = 0;
        public static final int PLUGGEDIN = 1;
        public static final int UNPLUGGED = 2;

        private HeadphoneState() {
        }
    }
}

