/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.performance.api;

import android.content.ComponentName;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.aidl.BaseProxy;
import com.google.android.aidl.BaseStub;
import com.google.android.aidl.Codecs;
import com.google.vr.vrcore.performance.api.IThrottlingTriggerCallback;
import com.google.vr.vrcore.performance.api.TimestampedTemperature;

public interface IPerformanceService
extends IInterface {
    public void getCurrentThrottlingRelativeTemperature(TimestampedTemperature var1) throws RemoteException;

    public long getCurrentEstimatedThrottleWarningTime() throws RemoteException;

    public void addTrigger(ComponentName var1, IThrottlingTriggerCallback var2, long var3, float var5, int var6) throws RemoteException;

    public void removeAllTriggers(ComponentName var1) throws RemoteException;

    public static abstract class Stub
    extends BaseStub
    implements IPerformanceService {
        private static final String DESCRIPTOR = "com.google.vr.vrcore.performance.api.IPerformanceService";
        static final int TRANSACTION_getCurrentThrottlingRelativeTemperature = 1;
        static final int TRANSACTION_getCurrentEstimatedThrottleWarningTime = 2;
        static final int TRANSACTION_addTrigger = 3;
        static final int TRANSACTION_removeAllTriggers = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPerformanceService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface instanceof IPerformanceService) {
                return (IPerformanceService)iInterface;
            }
            return new Proxy(iBinder);
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            if (this.routeToSuperOrEnforceInterface(n, parcel, parcel2, n2)) {
                return true;
            }
            switch (n) {
                case 1: {
                    TimestampedTemperature timestampedTemperature = new TimestampedTemperature();
                    this.getCurrentThrottlingRelativeTemperature(timestampedTemperature);
                    parcel2.writeNoException();
                    Codecs.writeParcelableAsReturnValue(parcel2, timestampedTemperature);
                    break;
                }
                case 2: {
                    long l = this.getCurrentEstimatedThrottleWarningTime();
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    break;
                }
                case 3: {
                    ComponentName componentName = (ComponentName)Codecs.createParcelable(parcel, ComponentName.CREATOR);
                    IThrottlingTriggerCallback iThrottlingTriggerCallback = IThrottlingTriggerCallback.Stub.asInterface(parcel.readStrongBinder());
                    long l = parcel.readLong();
                    float f = parcel.readFloat();
                    int n3 = parcel.readInt();
                    this.addTrigger(componentName, iThrottlingTriggerCallback, l, f, n3);
                    parcel2.writeNoException();
                    break;
                }
                case 4: {
                    ComponentName componentName = (ComponentName)Codecs.createParcelable(parcel, ComponentName.CREATOR);
                    this.removeAllTriggers(componentName);
                    parcel2.writeNoException();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public static class Proxy
        extends BaseProxy
        implements IPerformanceService {
            Proxy(IBinder iBinder) {
                super(iBinder, Stub.DESCRIPTOR);
            }

            @Override
            public void getCurrentThrottlingRelativeTemperature(TimestampedTemperature timestampedTemperature) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Parcel parcel2 = this.transactAndReadException(1, parcel);
                if (parcel2.readInt() != 0) {
                    timestampedTemperature.readFromParcel(parcel2);
                }
                parcel2.recycle();
            }

            @Override
            public long getCurrentEstimatedThrottleWarningTime() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Parcel parcel2 = this.transactAndReadException(2, parcel);
                long l = parcel2.readLong();
                parcel2.recycle();
                return l;
            }

            @Override
            public void addTrigger(ComponentName componentName, IThrottlingTriggerCallback iThrottlingTriggerCallback, long l, float f, int n) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)componentName);
                Codecs.writeStrongBinder(parcel, iThrottlingTriggerCallback);
                parcel.writeLong(l);
                parcel.writeFloat(f);
                parcel.writeInt(n);
                this.transactAndReadExceptionReturnVoid(3, parcel);
            }

            @Override
            public void removeAllTriggers(ComponentName componentName) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, (Parcelable)componentName);
                this.transactAndReadExceptionReturnVoid(4, parcel);
            }
        }
    }
}

