/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.common.api;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.aidl.BaseProxy;
import com.google.android.aidl.BaseStub;
import com.google.android.aidl.Codecs;
import com.google.vr.vrcore.common.api.HeadTrackingState;

public interface IDaydreamListener
extends IInterface {
    public int getTargetApiVersion() throws RemoteException;

    public HeadTrackingState requestStopTracking() throws RemoteException;

    public void applyFade(int var1, long var2) throws RemoteException;

    public void recenterHeadTracking() throws RemoteException;

    public void dumpDebugData() throws RemoteException;

    public void resumeHeadTracking(HeadTrackingState var1) throws RemoteException;

    public void invokeCloseAction() throws RemoteException;

    public void deprecated_setLensOffsets(float var1, float var2, float var3, float var4) throws RemoteException;

    public void setLensOffset(float var1, float var2, float var3) throws RemoteException;

    public void applyColorfulFade(int var1, long var2, int var4) throws RemoteException;

    public static abstract class Stub
    extends BaseStub
    implements IDaydreamListener {
        private static final String DESCRIPTOR = "com.google.vr.vrcore.common.api.IDaydreamListener";
        static final int TRANSACTION_getTargetApiVersion = 1;
        static final int TRANSACTION_requestStopTracking = 2;
        static final int TRANSACTION_applyFade = 3;
        static final int TRANSACTION_recenterHeadTracking = 4;
        static final int TRANSACTION_dumpDebugData = 5;
        static final int TRANSACTION_resumeHeadTracking = 6;
        static final int TRANSACTION_invokeCloseAction = 7;
        static final int TRANSACTION_deprecated_setLensOffsets = 8;
        static final int TRANSACTION_setLensOffset = 9;
        static final int TRANSACTION_applyColorfulFade = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDaydreamListener asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface instanceof IDaydreamListener) {
                return (IDaydreamListener)iInterface;
            }
            return new Proxy(iBinder);
        }

        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            if (this.routeToSuperOrEnforceInterface(n, parcel, parcel2, n2)) {
                return true;
            }
            switch (n) {
                case 1: {
                    int n3 = this.getTargetApiVersion();
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    break;
                }
                case 2: {
                    HeadTrackingState headTrackingState = this.requestStopTracking();
                    parcel2.writeNoException();
                    Codecs.writeParcelableAsReturnValue(parcel2, headTrackingState);
                    break;
                }
                case 3: {
                    int n4 = parcel.readInt();
                    long l = parcel.readLong();
                    this.applyFade(n4, l);
                    break;
                }
                case 4: {
                    this.recenterHeadTracking();
                    break;
                }
                case 5: {
                    this.dumpDebugData();
                    break;
                }
                case 6: {
                    HeadTrackingState headTrackingState = Codecs.createParcelable(parcel, HeadTrackingState.CREATOR);
                    this.resumeHeadTracking(headTrackingState);
                    break;
                }
                case 7: {
                    this.invokeCloseAction();
                    break;
                }
                case 8: {
                    float f = parcel.readFloat();
                    float f2 = parcel.readFloat();
                    float f3 = parcel.readFloat();
                    float f4 = parcel.readFloat();
                    this.deprecated_setLensOffsets(f, f2, f3, f4);
                    break;
                }
                case 9: {
                    float f = parcel.readFloat();
                    float f5 = parcel.readFloat();
                    float f6 = parcel.readFloat();
                    this.setLensOffset(f, f5, f6);
                    break;
                }
                case 10: {
                    int n5 = parcel.readInt();
                    long l = parcel.readLong();
                    int n6 = parcel.readInt();
                    this.applyColorfulFade(n5, l, n6);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public static class Proxy
        extends BaseProxy
        implements IDaydreamListener {
            Proxy(IBinder iBinder) {
                super(iBinder, Stub.DESCRIPTOR);
            }

            @Override
            public int getTargetApiVersion() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Parcel parcel2 = this.transactAndReadException(1, parcel);
                int n = parcel2.readInt();
                parcel2.recycle();
                return n;
            }

            @Override
            public HeadTrackingState requestStopTracking() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Parcel parcel2 = this.transactAndReadException(2, parcel);
                HeadTrackingState headTrackingState = Codecs.createParcelable(parcel2, HeadTrackingState.CREATOR);
                parcel2.recycle();
                return headTrackingState;
            }

            @Override
            public void applyFade(int n, long l) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeInt(n);
                parcel.writeLong(l);
                this.transactOneway(3, parcel);
            }

            @Override
            public void recenterHeadTracking() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                this.transactOneway(4, parcel);
            }

            @Override
            public void dumpDebugData() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                this.transactOneway(5, parcel);
            }

            @Override
            public void resumeHeadTracking(HeadTrackingState headTrackingState) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                Codecs.writeParcelable(parcel, headTrackingState);
                this.transactOneway(6, parcel);
            }

            @Override
            public void invokeCloseAction() throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                this.transactOneway(7, parcel);
            }

            @Override
            public void deprecated_setLensOffsets(float f, float f2, float f3, float f4) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeFloat(f);
                parcel.writeFloat(f2);
                parcel.writeFloat(f3);
                parcel.writeFloat(f4);
                this.transactOneway(8, parcel);
            }

            @Override
            public void setLensOffset(float f, float f2, float f3) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeFloat(f);
                parcel.writeFloat(f2);
                parcel.writeFloat(f3);
                this.transactOneway(9, parcel);
            }

            @Override
            public void applyColorfulFade(int n, long l, int n2) throws RemoteException {
                Parcel parcel = this.obtainAndWriteInterfaceToken();
                parcel.writeInt(n);
                parcel.writeLong(l);
                parcel.writeInt(n2);
                this.transactOneway(10, parcel);
            }
        }
    }
}

