/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.vr.vrcore.performance.api.IPerformanceService;
import com.google.vr.vrcore.performance.api.IThrottlingTriggerCallback;
import com.google.vr.vrcore.performance.api.TimestampedTemperature;
import java.util.ArrayList;

public class ThrottlingMonitor
implements AutoCloseable {
    private static final String TAG = "ThrottlingMonitor";
    public static final int SUCCESS = 0;
    public static final int ERROR_NOT_SUPPORTED = -1;
    public static final int ERROR_NO_PERMISSION = -2;
    public static final int ERROR_NOT_CONNECTED = -3;
    public static final int ERROR_NOT_ACCURATE = -4;
    public static final int ERROR_UNKNOWN = -5;
    private final Object lock = new Object();
    private final Context context;
    private final Handler mainHandler;
    private IPerformanceService perfService;
    private final ArrayList<SetupCallback> setupCallbacks = new ArrayList();
    private final ServiceConnection connection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            ArrayList arrayList = new ArrayList();
            Object object = ThrottlingMonitor.this.lock;
            synchronized (object) {
                ThrottlingMonitor.this.perfService = IPerformanceService.Stub.asInterface(iBinder);
                arrayList.addAll(ThrottlingMonitor.this.setupCallbacks);
                ThrottlingMonitor.this.setupCallbacks.clear();
                ThrottlingMonitor.this.lock.notifyAll();
            }
            ArrayList arrayList2 = arrayList;
            int n = arrayList2.size();
            object = null;
            for (int i = 0; i < n; ++i) {
                Object e = arrayList2.get(i);
                SetupCallback setupCallback = (SetupCallback)e;
                setupCallback.onInitialized();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = ThrottlingMonitor.this.lock;
            synchronized (object) {
                ThrottlingMonitor.this.perfService = null;
                ThrottlingMonitor.this.lock.notifyAll();
                return;
            }
        }
    };

    private ThrottlingMonitor(Context context) {
        this.context = context;
        this.mainHandler = new Handler(context.getMainLooper());
    }

    public static ThrottlingMonitor create(Context context) {
        Intent intent = new Intent("com.google.vr.vrcore.performance.service.BIND");
        intent.setPackage("com.google.vr.vrcore");
        ThrottlingMonitor throttlingMonitor = new ThrottlingMonitor(context);
        if (!context.bindService(intent, throttlingMonitor.connection, 1)) {
            return null;
        }
        return throttlingMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSetupCallback(final SetupCallback setupCallback) {
        Object object = this.lock;
        synchronized (object) {
            if (this.perfService != null) {
                this.mainHandler.post(new Runnable(this){

                    @Override
                    public void run() {
                        setupCallback.onInitialized();
                    }
                });
                return;
            }
            this.setupCallbacks.add(setupCallback);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queryRelativeTemperature(TimestampedTemperature timestampedTemperature) {
        IPerformanceService iPerformanceService;
        Object object = this.lock;
        synchronized (object) {
            iPerformanceService = this.perfService;
        }
        if (iPerformanceService == null) {
            return -3;
        }
        try {
            iPerformanceService.getCurrentThrottlingRelativeTemperature(timestampedTemperature);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf((Object)remoteException);
            Log.e((String)TAG, (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Service failed unexpectedly: ").append(string2).toString());
            return -5;
        }
        catch (SecurityException securityException) {
            return -2;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.w((String)TAG, (String)"Throttling monitoring not supported on this device.");
            return -1;
        }
        if (timestampedTemperature.temperature == Float.MIN_VALUE) {
            return -4;
        }
        return 0;
    }

    public int addTrigger(ComponentName componentName, float f, TemperatureTrigger temperatureTrigger, long l, Handler handler) {
        return this.addTriggerInternal(componentName, 3, f, temperatureTrigger, l, handler);
    }

    public int addTrigger(ComponentName componentName, TemperatureTrigger temperatureTrigger, long l, Handler handler) {
        return this.addTriggerInternal(componentName, 1, 0.0f, temperatureTrigger, l, handler);
    }

    public int addTrigger(ComponentName componentName, float f, TemperatureTrigger temperatureTrigger, Handler handler) {
        return this.addTriggerInternal(componentName, 2, f, temperatureTrigger, 0L, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAllTriggers(ComponentName componentName) {
        IPerformanceService iPerformanceService;
        Object object = this.lock;
        synchronized (object) {
            iPerformanceService = this.perfService;
        }
        if (iPerformanceService == null) {
            return -3;
        }
        try {
            iPerformanceService.removeAllTriggers(componentName);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf((Object)remoteException);
            Log.e((String)TAG, (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Service failed unexpectedly: ").append(string2).toString());
            return -5;
        }
        catch (SecurityException securityException) {
            return -2;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.w((String)TAG, (String)"Throttling monitoring not supported on this device.");
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEstimatedThrottlingTimeNanos() {
        long l;
        IPerformanceService iPerformanceService;
        Object object = this.lock;
        synchronized (object) {
            iPerformanceService = this.perfService;
        }
        if (iPerformanceService == null) {
            return -3L;
        }
        try {
            l = iPerformanceService.getCurrentEstimatedThrottleWarningTime();
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf((Object)remoteException);
            Log.e((String)TAG, (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Service failed unexpectedly: ").append(string2).toString());
            return -5L;
        }
        catch (SecurityException securityException) {
            return -2L;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.w((String)TAG, (String)"Throttling monitoring not supported on this device.");
            return -1L;
        }
        if (l < 0L) {
            return -4L;
        }
        return l;
    }

    @Override
    public void close() {
        this.context.unbindService(this.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addTriggerInternal(ComponentName componentName, int n, float f, TemperatureTrigger temperatureTrigger, long l, Handler handler) {
        IPerformanceService iPerformanceService;
        if (temperatureTrigger == null) {
            throw new IllegalArgumentException("Argument 'trigger' cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            iPerformanceService = this.perfService;
        }
        if (iPerformanceService == null) {
            return -3;
        }
        object = new ThrottlingTriggerCallback(temperatureTrigger, handler);
        try {
            iPerformanceService.addTrigger(componentName, (IThrottlingTriggerCallback)object, l, f, n);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf((Object)remoteException);
            Log.e((String)TAG, (String)new StringBuilder(29 + String.valueOf(string2).length()).append("Service failed unexpectedly: ").append(string2).toString());
            return -5;
        }
        catch (SecurityException securityException) {
            return -2;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.w((String)TAG, (String)"Throttling monitoring not supported on this device.");
            return -1;
        }
        return 0;
    }

    public static interface TemperatureTrigger {
        public void onTemperatureEvent(float var1, long var2);
    }

    public static interface SetupCallback {
        public void onInitialized();
    }

    static class ThrottlingTriggerCallback
    extends IThrottlingTriggerCallback.Stub {
        private final TemperatureTrigger trigger;
        private final Handler handler;

        public ThrottlingTriggerCallback(TemperatureTrigger temperatureTrigger, Handler handler) {
            this.trigger = temperatureTrigger;
            this.handler = handler;
        }

        @Override
        public void onTriggerActivated(final float f, final long l) {
            if (this.handler == null) {
                this.trigger.onTemperatureEvent(f, l);
                return;
            }
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    ThrottlingTriggerCallback.this.trigger.onTemperatureEvent(f, l);
                }
            });
        }
    }
}

