/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import com.google.vr.sdk.proto.nano.CardboardDevice;
import java.util.List;

public class DaydreamUtils {
    static final String INTENT_CATEGORY_DAYDREAM = "com.google.intent.category.DAYDREAM";
    static final String INTENT_CATEGORY_CARDBOARD = "com.google.intent.category.CARDBOARD";
    public static final int DAYDREAM_NOT_SUPPORTED = 1;
    public static final int DAYDREAM_OPTIONAL = 2;
    public static final int DAYDREAM_REQUIRED = 3;
    private static boolean sDaydreamPhoneOverrideForTesting;

    public static boolean isDaydreamPhone(Context context) {
        if (sDaydreamPhoneOverrideForTesting) {
            return true;
        }
        if (Build.VERSION.SDK_INT < 24) {
            return false;
        }
        return context.getPackageManager().hasSystemFeature("android.hardware.vr.high_performance");
    }

    public static boolean isDaydreamViewer(CardboardDevice.DeviceParams deviceParams) {
        return deviceParams != null && deviceParams.daydreamInternal != null;
    }

    public static int getComponentDaydreamCompatibility(Context context, ComponentName componentName) {
        return DaydreamUtils.getComponentDaydreamCompatibility(context, context.getPackageManager(), componentName);
    }

    public static void setIsDaydreamPhoneForTesting(boolean bl) {
        sDaydreamPhoneOverrideForTesting = bl;
    }

    static int getComponentDaydreamCompatibility(Context context, PackageManager packageManager, ComponentName componentName) {
        Intent intent = new Intent();
        intent.setPackage(componentName.getPackageName());
        intent.addCategory(INTENT_CATEGORY_DAYDREAM);
        if (!DaydreamUtils.canResolveIntent(packageManager, componentName, intent)) {
            return 1;
        }
        Intent intent2 = new Intent();
        intent2.setPackage(componentName.getPackageName());
        intent2.addCategory(INTENT_CATEGORY_CARDBOARD);
        if (DaydreamUtils.canResolveIntent(packageManager, componentName, intent2)) {
            return 2;
        }
        return 3;
    }

    private static boolean canResolveIntent(PackageManager packageManager, ComponentName componentName, Intent intent) {
        List list = packageManager.queryIntentActivities(intent, 128);
        if (list != null) {
            for (ResolveInfo resolveInfo : list) {
                if (resolveInfo == null || resolveInfo.activityInfo == null || resolveInfo.activityInfo.name == null || !resolveInfo.activityInfo.name.equals(componentName.getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    protected DaydreamUtils() {
    }
}

