/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import com.google.vr.cardboard.R;
import com.google.vr.cardboard.ThreadUtils;
import com.google.vr.cardboard.TransitionView;
import com.google.vr.cardboard.UiUtils;

public class UiLayer {
    private static final String TAG = "UiLayer";
    private final Context context;
    private final FrameLayout rootOuterLayout;
    private ImageButton settingsButton;
    private ImageButton backButton;
    private RelativeLayout alignmentMarker;
    private TransitionView transitionView;
    private RelativeLayout rootInnerLayout;
    private volatile boolean isEnabled = true;
    private volatile boolean isSettingsButtonEnabled = true;
    private volatile boolean isAlignmentMarkerEnabled = true;
    private volatile Runnable buttonClickCallbackOverride = null;
    private volatile Runnable backButtonListener = null;
    private volatile Runnable settingsButtonListener;
    private volatile Runnable transitionListener = null;
    private volatile boolean transitionViewEnabled = false;
    private volatile String viewerName;
    private volatile float alignmentMarkerScale = 1.0f;
    private int currentLayoutId;

    public UiLayer(Context context) {
        this.context = context;
        this.rootOuterLayout = new RootOuterLayout(context);
        this.inflateViewsWithLayoutId(R.layout.ui_layer);
    }

    public void setPortraitSupportEnabled(boolean bl) {
        this.inflateViewsWithLayoutId(bl ? R.layout.ui_layer_with_portrait_support : R.layout.ui_layer);
    }

    private void inflateViewsWithLayoutId(int n) {
        this.currentLayoutId = n;
        boolean bl = this.transitionView != null && this.transitionView.getParent() != null;
        this.transitionView = null;
        if (this.rootInnerLayout != null) {
            this.rootOuterLayout.removeView((View)this.rootInnerLayout);
        }
        this.rootInnerLayout = (RelativeLayout)LayoutInflater.from((Context)this.context).inflate(n, null, false);
        this.rootOuterLayout.addView((View)this.rootInnerLayout);
        if (bl) {
            this.setTransitionViewEnabled(this.transitionViewEnabled);
        }
        this.settingsButtonListener = new Runnable(){

            @Override
            public void run() {
                UiUtils.launchOrInstallCardboard(UiLayer.this.context);
            }
        };
        this.settingsButton = (ImageButton)this.rootInnerLayout.findViewById(R.id.ui_settings_button);
        this.settingsButton.setVisibility(UiLayer.computeVisibility(this.isSettingsButtonEnabled));
        this.settingsButton.setContentDescription((CharSequence)"Settings");
        this.settingsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Runnable runnable = UiLayer.this.settingsButtonListener;
                Runnable runnable2 = UiLayer.this.buttonClickCallbackOverride;
                if (runnable2 != null) {
                    runnable2.run();
                    return;
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        this.backButton = (ImageButton)this.rootInnerLayout.findViewById(R.id.ui_back_button);
        this.backButton.setVisibility(UiLayer.computeVisibility(this.getBackButtonEnabled()));
        this.backButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Runnable runnable = UiLayer.this.backButtonListener;
                Runnable runnable2 = UiLayer.this.buttonClickCallbackOverride;
                if (runnable2 != null) {
                    runnable2.run();
                    return;
                }
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        this.alignmentMarker = (RelativeLayout)this.rootInnerLayout.findViewById(R.id.ui_alignment_marker);
        this.alignmentMarker.setVisibility(UiLayer.computeVisibility(this.getAlignmentMarkerEnabled()));
        this.setAlignmentMarkerScale(this.alignmentMarkerScale);
    }

    private TransitionView getTransitionView() {
        if (this.transitionView == null) {
            this.transitionView = new TransitionView(this.context);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            this.transitionView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.transitionView.setVisibility(UiLayer.computeVisibility(this.transitionViewEnabled));
            if (this.viewerName != null) {
                this.transitionView.setViewerName(this.viewerName);
            }
            if (this.transitionListener != null) {
                this.transitionView.setTransitionListener(this.transitionListener);
            }
            this.transitionView.setBackButtonListener(this.backButtonListener);
            this.rootInnerLayout.addView((View)this.transitionView);
        }
        return this.transitionView;
    }

    private static int computeVisibility(boolean bl) {
        if (bl) {
            return 0;
        }
        return 8;
    }

    public ViewGroup getView() {
        return this.rootOuterLayout;
    }

    public void setEnabled(final boolean bl) {
        this.isEnabled = bl;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UiLayer.this.rootOuterLayout.setVisibility(UiLayer.computeVisibility(bl));
            }
        });
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setSettingsButtonEnabled(final boolean bl) {
        this.isSettingsButtonEnabled = bl;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UiLayer.this.settingsButton.setVisibility(UiLayer.computeVisibility(bl));
            }
        });
    }

    public void setButtonClickCallbackOverride(Runnable runnable) {
        this.buttonClickCallbackOverride = runnable;
    }

    public void setSettingsButtonListener(Runnable runnable) {
        this.settingsButtonListener = runnable;
    }

    public void setBackButtonListener(final Runnable runnable) {
        this.backButtonListener = runnable;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                boolean bl = runnable != null;
                UiLayer.this.backButton.setVisibility(UiLayer.computeVisibility(bl));
                if (UiLayer.this.transitionView != null) {
                    UiLayer.this.transitionView.setBackButtonListener(runnable);
                }
            }
        });
    }

    public void setAlignmentMarkerEnabled(final boolean bl) {
        this.isAlignmentMarkerEnabled = bl;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                UiLayer.this.alignmentMarker.setVisibility(UiLayer.computeVisibility(bl));
            }
        });
    }

    @TargetApi(value=23)
    public static void scaleAlignmentMarkerLayoutParams(Context context, float f, RelativeLayout.LayoutParams layoutParams) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        int n = (int)context.getResources().getDimension(R.dimen.alignment_marker_height);
        int n2 = (int)((float)n * f);
        if (layoutParams.getRule(15) == -1) {
            layoutParams.width = n2;
            return;
        }
        layoutParams.height = n2;
    }

    @TargetApi(value=23)
    public void setAlignmentMarkerScale(final float f) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (this.alignmentMarkerScale == f && f == 1.0f) {
            return;
        }
        this.alignmentMarkerScale = f;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)UiLayer.this.alignmentMarker.getLayoutParams();
                UiLayer.scaleAlignmentMarkerLayoutParams(UiLayer.this.context, f, layoutParams);
                UiLayer.this.alignmentMarker.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        });
    }

    public void setTransitionViewEnabled(final boolean bl) {
        this.transitionViewEnabled = bl;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!bl && UiLayer.this.transitionView == null) {
                    return;
                }
                UiLayer.this.getTransitionView().setVisibility(UiLayer.computeVisibility(bl));
            }
        });
    }

    public boolean getTransitionViewEnabled() {
        return this.transitionViewEnabled;
    }

    public boolean isTransitionViewVisible() {
        return this.transitionView != null && this.transitionView.getVisibility() == 0;
    }

    public void setTransitionViewListener(final Runnable runnable) {
        this.transitionListener = runnable;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (runnable == null && UiLayer.this.transitionView == null) {
                    return;
                }
                UiLayer.this.getTransitionView().setTransitionListener(runnable);
            }
        });
    }

    public void setViewerName(final String string2) {
        this.viewerName = string2;
        ThreadUtils.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (UiLayer.this.transitionView != null) {
                    UiLayer.this.transitionView.setViewerName(string2);
                }
            }
        });
    }

    public String getViewerName() {
        return this.viewerName;
    }

    public boolean getSettingsButtonEnabled() {
        return this.isSettingsButtonEnabled;
    }

    public boolean getBackButtonEnabled() {
        return this.backButtonListener != null;
    }

    public Runnable getBackButtonListener() {
        return this.backButtonListener;
    }

    public boolean getAlignmentMarkerEnabled() {
        return this.isAlignmentMarkerEnabled;
    }

    class RootOuterLayout
    extends FrameLayout {
        private Configuration currentConfig;

        RootOuterLayout(Context context) {
            super(context);
            this.currentConfig = new Configuration(context.getResources().getConfiguration());
        }

        public void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.handlePotentialConfigurationChange(UiLayer.this.context.getResources().getConfiguration());
        }

        public void onConfigurationChanged(Configuration configuration) {
            super.onConfigurationChanged(configuration);
            this.handlePotentialConfigurationChange(configuration);
        }

        private void handlePotentialConfigurationChange(Configuration configuration) {
            int n = configuration.diff(this.currentConfig);
            if ((n & 0x1000) != 0 || (n & 0x80) != 0) {
                Log.d((String)UiLayer.TAG, (String)"Re-inflating UiLayer due to configuration change.");
                this.currentConfig = new Configuration(configuration);
                UiLayer.this.inflateViewsWithLayoutId(UiLayer.this.currentLayoutId);
            }
        }
    }
}

