/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.google.vr.cardboard.UsedByNative;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@UsedByNative
public class ExternalSurfaceManager {
    private static final String TAG = ExternalSurfaceManager.class.getSimpleName();
    private final UpdateSurfaceCallback updateSurfaceCallback;
    private volatile ExternalSurfaceData surfaceData = new ExternalSurfaceData();
    private final Object surfaceDataUpdateLock = new Object();
    private int nextID = 1;
    private boolean isAttachedToGlContext;

    @UsedByNative
    public ExternalSurfaceManager(final long l) {
        this(new UpdateSurfaceCallback(){

            @Override
            public void updateSurface(int n, int n2, long l2, float[] fArray) {
                ExternalSurfaceManager.nativeUpdateSurface(l, n, n2, l2, fArray);
            }
        });
    }

    public ExternalSurfaceManager(UpdateSurfaceCallback updateSurfaceCallback) {
        this.updateSurfaceCallback = updateSurfaceCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByNative
    public void shutdown() {
        Object object = this.surfaceDataUpdateLock;
        synchronized (object) {
            ExternalSurfaceData externalSurfaceData = this.surfaceData;
            this.surfaceData = new ExternalSurfaceData();
            for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
                externalSurface.shutdown(this.updateSurfaceCallback);
            }
            for (ExternalSurface externalSurface : externalSurfaceData.surfacesToRelease.values()) {
                externalSurface.shutdown(this.updateSurfaceCallback);
            }
            return;
        }
    }

    @UsedByNative
    public int createExternalSurface() {
        return this.createExternalSurfaceImpl(null);
    }

    @UsedByNative
    public int createExternalSurface(Runnable runnable, Runnable runnable2, Handler handler) {
        if (runnable == null || handler == null) {
            throw new IllegalArgumentException("Surface listener and handler must both be non-null for external Surface creation");
        }
        return this.createExternalSurfaceImpl(new ExternalSurfaceCallback(runnable, runnable2, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createExternalSurfaceImpl(ExternalSurfaceCallback externalSurfaceCallback) {
        Object object = this.surfaceDataUpdateLock;
        synchronized (object) {
            ExternalSurfaceData externalSurfaceData = new ExternalSurfaceData(this.surfaceData);
            int n = this.nextID++;
            externalSurfaceData.surfaces.put(n, new ExternalSurface(n, externalSurfaceCallback));
            this.surfaceData = externalSurfaceData;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UsedByNative
    public void releaseExternalSurface(int n) {
        Object object = this.surfaceDataUpdateLock;
        synchronized (object) {
            ExternalSurfaceData externalSurfaceData = new ExternalSurfaceData(this.surfaceData);
            ExternalSurface externalSurface = externalSurfaceData.surfaces.remove(n);
            if (externalSurface != null) {
                externalSurfaceData.surfacesToRelease.put(n, externalSurface);
                this.surfaceData = externalSurfaceData;
            } else {
                Log.e((String)TAG, (String)new StringBuilder(48).append("Not releasing nonexistent surface ID ").append(n).toString());
            }
            return;
        }
    }

    public int getSurfaceCount() {
        return this.surfaceData.surfaces.size();
    }

    @UsedByNative
    public Surface getSurface(int n) {
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        if (externalSurfaceData.surfaces.containsKey(n)) {
            return externalSurfaceData.surfaces.get(n).getSurface();
        }
        Log.e((String)TAG, (String)new StringBuilder(58).append("Surface with ID ").append(n).append(" does not exist, returning null").toString());
        return null;
    }

    @UsedByNative
    public void consumerAttachToCurrentGLContext() {
        this.isAttachedToGlContext = true;
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
            externalSurface.maybeAttachToCurrentGLContext();
        }
    }

    @UsedByNative
    public void consumerDetachFromCurrentGLContext() {
        this.isAttachedToGlContext = false;
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
            externalSurface.maybeDetachFromCurrentGLContext();
        }
    }

    @UsedByNative
    public void consumerUpdateManagedSurfaces() {
        ExternalSurfaceData externalSurfaceData = this.surfaceData;
        if (this.isAttachedToGlContext) {
            for (ExternalSurface externalSurface : externalSurfaceData.surfaces.values()) {
                externalSurface.maybeAttachToCurrentGLContext();
                externalSurface.updateSurfaceTexture(this.updateSurfaceCallback);
            }
        }
        for (ExternalSurface externalSurface : externalSurfaceData.surfacesToRelease.values()) {
            externalSurface.shutdown(this.updateSurfaceCallback);
        }
    }

    private static native void nativeUpdateSurface(long var0, int var2, int var3, long var4, float[] var6);

    static class ExternalSurface {
        private final int id;
        private final ExternalSurfaceCallback callback;
        private final float[] transformMatrix = new float[16];
        private final AtomicBoolean hasNewFrame = new AtomicBoolean(false);
        private final AtomicBoolean released = new AtomicBoolean(false);
        private final int[] glTextureId = new int[1];
        private volatile SurfaceTexture surfaceTexture;
        private volatile Surface surface;
        private volatile boolean isAttached = false;

        ExternalSurface(int n, ExternalSurfaceCallback externalSurfaceCallback) {
            this.id = n;
            this.callback = externalSurfaceCallback;
            Matrix.setIdentityM((float[])this.transformMatrix, (int)0);
        }

        void maybeAttachToCurrentGLContext() {
            if (this.isAttached) {
                return;
            }
            GLES20.glGenTextures((int)1, (int[])this.glTextureId, (int)0);
            if (this.surfaceTexture == null) {
                this.surfaceTexture = new SurfaceTexture(this.glTextureId[0]);
                this.surfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

                    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                        ExternalSurface.this.hasNewFrame.set(true);
                        if (ExternalSurface.this.callback != null) {
                            ExternalSurface.this.callback.postOnFrameAvailable();
                        }
                    }
                });
                this.surface = new Surface(this.surfaceTexture);
            } else {
                this.surfaceTexture.attachToGLContext(this.glTextureId[0]);
            }
            this.isAttached = true;
            if (this.callback != null) {
                this.callback.postOnSurfaceAvailable();
            }
        }

        void maybeDetachFromCurrentGLContext() {
            if (!this.isAttached) {
                return;
            }
            if (this.callback != null) {
                this.callback.cancelPosts();
            }
            this.surfaceTexture.detachFromGLContext();
            this.isAttached = false;
        }

        void updateSurfaceTexture(UpdateSurfaceCallback updateSurfaceCallback) {
            if (!this.isAttached) {
                return;
            }
            boolean bl = this.hasNewFrame.getAndSet(false);
            if (bl) {
                this.surfaceTexture.updateTexImage();
                this.surfaceTexture.getTransformMatrix(this.transformMatrix);
                long l = this.surfaceTexture.getTimestamp();
                updateSurfaceCallback.updateSurface(this.id, this.glTextureId[0], l, this.transformMatrix);
            }
        }

        Surface getSurface() {
            if (!this.isAttached) {
                return null;
            }
            return this.surface;
        }

        void shutdown(UpdateSurfaceCallback updateSurfaceCallback) {
            if (this.released.getAndSet(true)) {
                return;
            }
            if (this.surfaceTexture != null) {
                this.surfaceTexture.release();
                this.surfaceTexture = null;
                this.surface = null;
            }
            updateSurfaceCallback.updateSurface(this.id, 0, 0L, this.transformMatrix);
        }
    }

    static class ExternalSurfaceCallback {
        private final Runnable surfaceListener;
        private final Runnable frameListener;
        private final Handler handler;

        public ExternalSurfaceCallback(Runnable runnable, Runnable runnable2, Handler handler) {
            this.surfaceListener = runnable;
            this.frameListener = runnable2;
            this.handler = handler;
        }

        public void postOnSurfaceAvailable() {
            if (this.surfaceListener != null) {
                this.handler.post(this.surfaceListener);
            }
        }

        public void postOnFrameAvailable() {
            if (this.frameListener != null) {
                this.handler.post(this.frameListener);
            }
        }

        public void cancelPosts() {
            if (this.surfaceListener != null) {
                this.handler.removeCallbacks(this.surfaceListener);
            }
            if (this.frameListener != null) {
                this.handler.removeCallbacks(this.frameListener);
            }
        }
    }

    static class ExternalSurfaceData {
        final HashMap<Integer, ExternalSurface> surfaces;
        final HashMap<Integer, ExternalSurface> surfacesToRelease;

        ExternalSurfaceData() {
            this.surfaces = new HashMap();
            this.surfacesToRelease = new HashMap();
        }

        ExternalSurfaceData(ExternalSurfaceData externalSurfaceData) {
            this.surfaces = new HashMap<Integer, ExternalSurface>(externalSurfaceData.surfaces);
            this.surfacesToRelease = new HashMap<Integer, ExternalSurface>(externalSurfaceData.surfacesToRelease);
            Iterator<Map.Entry<Integer, ExternalSurface>> iterator = this.surfacesToRelease.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, ExternalSurface> entry = iterator.next();
                if (!entry.getValue().released.get()) continue;
                iterator.remove();
            }
        }
    }

    public static interface UpdateSurfaceCallback {
        public void updateSurface(int var1, int var2, long var3, float[] var5);
    }
}

