/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.android.desugar.runtime;

import com.google.devtools.build.android.desugar.runtime.ThrowableExtension$AbstractDesugaringStrategy;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension$MimicDesugaringStrategy;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension$ReuseDesugaringStrategy;
import java.lang.reflect.Field;

public final class ThrowableExtension {
    private static ThrowableExtension$AbstractDesugaringStrategy STRATEGY;

    public static void printStackTrace(Throwable throwable) {
        STRATEGY.printStackTrace(throwable);
    }

    private static Integer readApiLevelFromBuildVersion() {
        try {
            Class<?> clazz = Class.forName("android.os.Build$VERSION");
            Field field = clazz.getField("SDK_INT");
            return (Integer)field.get(null);
        }
        catch (Exception exception) {
            System.err.println("Failed to retrieve value from android.os.Build$VERSION.SDK_INT due to the following exception.");
            exception.printStackTrace(System.err);
            return null;
        }
    }

    static {
        ThrowableExtension$AbstractDesugaringStrategy throwableExtension$AbstractDesugaringStrategy;
        Integer n = null;
        try {
            n = ThrowableExtension.readApiLevelFromBuildVersion();
            throwableExtension$AbstractDesugaringStrategy = n != null && n >= 19 ? new ThrowableExtension$ReuseDesugaringStrategy() : (!Boolean.getBoolean("com.google.devtools.build.android.desugar.runtime.twr_disable_mimic") ? new ThrowableExtension$MimicDesugaringStrategy() : new NullDesugaringStrategy());
        }
        catch (Throwable throwable) {
            String string2 = NullDesugaringStrategy.class.getName();
            System.err.println(new StringBuilder(132 + String.valueOf(string2).length()).append("An error has occured when initializing the try-with-resources desuguring strategy. The default strategy ").append(string2).append("will be used. The error is: ").toString());
            throwable.printStackTrace(System.err);
            throwableExtension$AbstractDesugaringStrategy = new NullDesugaringStrategy();
        }
        STRATEGY = throwableExtension$AbstractDesugaringStrategy;
        if (n != null) {
            n.intValue();
        }
    }

    static final class NullDesugaringStrategy
    extends ThrowableExtension$AbstractDesugaringStrategy {
        NullDesugaringStrategy() {
        }

        @Override
        public final void printStackTrace(Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

