/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.widget.FrameLayout;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.UiLayer;
import com.google.vr.cardboard.UiUtils;
import com.google.vr.ndk.base.DaydreamUtilsWrapper;

public class GvrUiLayout
extends FrameLayout {
    private static final float DAYDREAM_ALIGNMENT_MARKER_SCALE = 0.35f;
    private final UiLayer uiLayer;
    private final Runnable defaultCloseButtonRunnable;
    private boolean daydreamModeEnabled = false;

    GvrUiLayout(Context context) {
        this(context, new DaydreamUtilsWrapper());
    }

    GvrUiLayout(Context context, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        super(context);
        if (!ContextUtils.canGetActivity(context)) {
            throw new IllegalArgumentException("An Activity Context is required for VR functionality.");
        }
        this.defaultCloseButtonRunnable = GvrUiLayout.createDefaultCloseButtonRunnable(context, daydreamUtilsWrapper);
        this.uiLayer = new UiLayer(context);
        this.uiLayer.setBackButtonListener(this.defaultCloseButtonRunnable);
        this.addView(this.uiLayer.getView());
    }

    public static void launchOrInstallGvrApp(Activity activity) {
        UiUtils.launchOrInstallCardboard((Context)activity);
    }

    public void setEnabled(boolean bl) {
        this.uiLayer.setEnabled(bl);
    }

    public void setCloseButtonListener(Runnable runnable) {
        this.uiLayer.setBackButtonListener(runnable != null ? runnable : this.defaultCloseButtonRunnable);
    }

    public void setTransitionViewEnabled(boolean bl) {
        this.uiLayer.setTransitionViewEnabled(bl && !this.daydreamModeEnabled);
    }

    public void setViewerName(String string2) {
        this.uiLayer.setViewerName(string2);
    }

    public UiLayer getUiLayer() {
        return this.uiLayer;
    }

    void invokeCloseButtonListener() {
        Runnable runnable = this.uiLayer.getBackButtonRunnable();
        if (runnable != null) {
            runnable.run();
        }
    }

    void setDaydreamModeEnabled(boolean bl) {
        if (this.daydreamModeEnabled == bl) {
            return;
        }
        this.daydreamModeEnabled = bl;
        if (bl) {
            this.uiLayer.setAlignmentMarkerScale(0.35f);
            this.uiLayer.setTransitionViewEnabled(false);
            return;
        }
        this.uiLayer.setAlignmentMarkerScale(1.0f);
    }

    boolean isDaydreamModeEnabled() {
        return this.daydreamModeEnabled;
    }

    private static Runnable createDefaultCloseButtonRunnable(Context context, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        final Activity activity = ContextUtils.getActivity(context);
        if (daydreamUtilsWrapper.isDaydreamActivity(activity)) {
            return new Runnable(){

                @Override
                public final void run() {
                    Intent intent = new Intent("android.intent.action.MAIN");
                    intent.addCategory("android.intent.category.HOME");
                    intent.setFlags(0x10000000);
                    activity.startActivity(intent);
                    activity.finish();
                }
            };
        }
        return new Runnable(){

            @Override
            public final void run() {
                activity.onBackPressed();
            }
        };
    }
}

