/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.app.Activity;
import android.app.PendingIntent;
import android.app.Presentation;
import android.content.ComponentName;
import android.content.Context;
import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Display;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.vr.cardboard.ContextUtils;
import com.google.vr.cardboard.DisplaySynchronizer;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.cardboard.EglFactory;
import com.google.vr.cardboard.MutableEglConfigChooser;
import com.google.vr.cardboard.ScanlineRacingRenderer;
import com.google.vr.ndk.base.CardboardEmulator;
import com.google.vr.ndk.base.DaydreamAlignment;
import com.google.vr.ndk.base.DaydreamUtilsWrapper;
import com.google.vr.ndk.base.FadeOverlayView;
import com.google.vr.ndk.base.GvrApi;
import com.google.vr.ndk.base.GvrSurfaceView;
import com.google.vr.ndk.base.GvrUiLayout;
import com.google.vr.ndk.base.TraceCompat;
import com.google.vr.ndk.base.VrCoreSdkClient;
import java.util.ArrayList;
import java.util.List;

public class GvrLayout
extends FrameLayout {
    private static final String TAG = "GvrLayout";
    private static final boolean DEBUG = false;
    private static final int EXTERNAL_PRESENTATION_MIN_API = 16;
    private static final int SHOW_RENDERING_VIEWS_DELAY_FOR_FADE = 50;
    private static PresentationFactory sOptionalPresentationFactory = null;
    private DaydreamUtilsWrapper daydreamUtils;
    private FrameLayout presentationLayout;
    private GvrUiLayout uiLayout;
    private DisplaySynchronizer displaySynchronizer;
    private View presentationView;
    private boolean isAsyncReprojectionVideoEnabled;
    private boolean isAsyncReprojectionUsingProtectedBuffers;
    private GvrSurfaceView scanlineRacingView;
    private ScanlineRacingRenderer scanlineRacingRenderer;
    private EglFactory eglFactory;
    private FadeOverlayView fadeOverlayView;
    private PresentationHelper presentationHelper;
    private VrCoreSdkClient vrCoreSdkClient;
    private DaydreamAlignment daydreamAlignment;
    private CardboardEmulator cardboardEmulator;
    private GvrApi gvrApi;
    private boolean isResumed = false;
    private int videoSurfaceId = -1;
    private boolean stereoModeEnabled = true;
    private final Runnable showRenderingViewsRunnable = new Runnable(){

        @Override
        public void run() {
            GvrLayout.this.updateRenderingViewsVisibility(0);
        }
    };

    public GvrLayout(Context context) {
        super(context);
        this.init(null, null, null, null);
    }

    public GvrLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.init(null, null, null, null);
    }

    GvrLayout(Context context, GvrApi gvrApi, DisplaySynchronizer displaySynchronizer, FadeOverlayView fadeOverlayView, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        super(context);
        this.init(gvrApi, displaySynchronizer, fadeOverlayView, daydreamUtilsWrapper);
    }

    private void init(GvrApi gvrApi, DisplaySynchronizer displaySynchronizer, FadeOverlayView fadeOverlayView, DaydreamUtilsWrapper daydreamUtilsWrapper) {
        Activity activity = ContextUtils.getActivity(this.getContext());
        if (activity == null) {
            throw new IllegalArgumentException("An Activity Context is required for VR functionality.");
        }
        TraceCompat.beginSection("GvrLayout.init");
        try {
            int n;
            displaySynchronizer = displaySynchronizer != null ? displaySynchronizer : GvrApi.createDefaultDisplaySynchronizer(this.getContext());
            gvrApi = gvrApi != null ? gvrApi : new GvrApi(this.getContext(), displaySynchronizer);
            this.daydreamUtils = daydreamUtilsWrapper = daydreamUtilsWrapper != null ? daydreamUtilsWrapper : new DaydreamUtilsWrapper();
            this.presentationLayout = new FrameLayout(this.getContext());
            this.uiLayout = new GvrUiLayout(this.getContext());
            this.gvrApi = gvrApi;
            this.displaySynchronizer = displaySynchronizer;
            this.presentationHelper = this.tryCreatePresentationHelper();
            this.addView((View)this.presentationLayout, 0);
            this.addView((View)this.uiLayout, 1);
            this.updateUiLayout();
            boolean bl = daydreamUtilsWrapper.isDaydreamPhone(this.getContext());
            if (bl) {
                this.daydreamAlignment = this.createDaydreamAlignment();
                this.uiLayout.setOnTouchListener(new DaydreamAlignment.DefaultTouchListener(this.daydreamAlignment, gvrApi));
            }
            boolean bl2 = (n = daydreamUtilsWrapper.getActivityDaydreamCompatibility(activity)) != 0;
            boolean bl3 = n == 2;
            boolean bl4 = bl || bl3;
            if (bl4) {
                if (bl2) {
                    this.fadeOverlayView = fadeOverlayView != null ? fadeOverlayView : new FadeOverlayView(this.getContext());
                    this.addView(this.fadeOverlayView, 2);
                }
                this.vrCoreSdkClient = this.createVrCoreSdkClient(this.getContext(), gvrApi, daydreamUtilsWrapper, this.fadeOverlayView);
            }
            return;
        }
        finally {
            TraceCompat.endSection();
        }
    }

    public GvrUiLayout getUiLayout() {
        return this.uiLayout;
    }

    public void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        this.updateFadeVisibility();
    }

    public void onPause() {
        TraceCompat.beginSection("GvrLayout.onPause");
        try {
            this.gvrApi.pause();
            if (this.scanlineRacingView != null) {
                this.scanlineRacingView.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        GvrLayout.this.scanlineRacingRenderer.onPause();
                    }
                });
                this.scanlineRacingView.onPause();
            }
            if (this.presentationHelper != null) {
                this.presentationHelper.onPause();
            }
            this.displaySynchronizer.onPause();
            if (this.vrCoreSdkClient != null) {
                this.vrCoreSdkClient.onPause();
            }
            if (this.cardboardEmulator != null) {
                this.cardboardEmulator.onPause();
            }
            this.isResumed = false;
            this.updateFadeVisibility();
            return;
        }
        finally {
            TraceCompat.endSection();
        }
    }

    public void onResume() {
        TraceCompat.beginSection("GvrLayout.onResume");
        try {
            this.gvrApi.resume();
            if (this.daydreamAlignment != null) {
                this.daydreamAlignment.refreshViewerProfile();
            }
            this.displaySynchronizer.onResume();
            if (this.presentationHelper != null) {
                this.presentationHelper.onResume();
            }
            if (this.scanlineRacingView != null) {
                this.scanlineRacingView.onResume();
            }
            if (this.vrCoreSdkClient != null) {
                this.vrCoreSdkClient.onResume();
            }
            if (this.cardboardEmulator != null && this.gvrApi.getViewerType() == 1) {
                this.cardboardEmulator.onResume();
            }
            this.isResumed = true;
            this.updateFadeVisibility();
            this.updateUiLayout();
            return;
        }
        finally {
            TraceCompat.endSection();
        }
    }

    public void shutdown() {
        TraceCompat.beginSection("GvrLayout.shutdown");
        try {
            this.displaySynchronizer.shutdown();
            if (this.daydreamAlignment != null) {
                this.daydreamAlignment.shutdown();
            }
            this.removeView((View)this.presentationLayout);
            this.removeView((View)this.uiLayout);
            if (this.scanlineRacingRenderer != null) {
                this.scanlineRacingRenderer.shutdown();
                this.scanlineRacingRenderer = null;
            }
            this.scanlineRacingView = null;
            this.presentationView = null;
            if (this.presentationHelper != null) {
                this.presentationHelper.shutdown();
                this.presentationHelper = null;
            }
            if (this.vrCoreSdkClient != null) {
                this.vrCoreSdkClient.onPause();
                this.vrCoreSdkClient = null;
            }
            if (this.cardboardEmulator != null) {
                this.cardboardEmulator.onPause();
                this.cardboardEmulator = null;
            }
            if (this.gvrApi != null) {
                this.gvrApi.shutdown();
                this.gvrApi = null;
            }
            return;
        }
        finally {
            TraceCompat.endSection();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.presentationHelper != null) {
            this.presentationHelper.onDetachedFromWindow();
        }
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.displaySynchronizer.onConfigurationChanged();
    }

    public void setPresentationView(View view) {
        if (this.presentationView != null) {
            this.presentationLayout.removeView(this.presentationView);
        }
        this.presentationLayout.addView(view, 0);
        this.presentationView = view;
    }

    public void setFixedPresentationSurfaceSize(int n, int n2) {
        this.gvrApi.setSurfaceSize(n, n2);
    }

    public boolean enableAsyncReprojectionVideoSurface(ExternalSurfaceListener externalSurfaceListener, Handler handler, boolean bl) {
        if (!this.daydreamUtils.isDaydreamPhone(this.getContext())) {
            Log.e((String)TAG, (String)"Only Daydream devices support async reprojection. Cannot enable video Surface.");
            return false;
        }
        if (this.scanlineRacingView != null) {
            Log.e((String)TAG, (String)"Async reprojection is already enabled. Cannot call enableAsyncReprojectionVideoSurface after calling setAsyncReprojectionEnabled.");
            return false;
        }
        if (this.gvrApi.usingVrDisplayService()) {
            Log.e((String)TAG, (String)"Async reprojection video is not supported on this device.");
            return false;
        }
        this.isAsyncReprojectionVideoEnabled = true;
        this.isAsyncReprojectionUsingProtectedBuffers = bl;
        this.scanlineRacingRenderer = new ScanlineRacingRenderer(this.gvrApi);
        ExternalSurfaceManager externalSurfaceManager = this.scanlineRacingRenderer.getExternalSurfaceManager();
        this.videoSurfaceId = externalSurfaceManager.createExternalSurface(externalSurfaceListener, handler);
        return true;
    }

    public boolean setAsyncReprojectionEnabled(boolean bl) {
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("setAsyncReprojectionEnabled may only be called from the UI thread");
        }
        if (this.scanlineRacingView != null && !bl) {
            throw new UnsupportedOperationException("Async reprojection cannot be disabled once enabled");
        }
        if (bl && !this.daydreamUtils.isDaydreamPhone(this.getContext())) {
            return false;
        }
        boolean bl2 = this.gvrApi.setAsyncReprojectionEnabled(bl);
        if (bl) {
            if (bl2) {
                if (!this.gvrApi.usingVrDisplayService()) {
                    this.addScanlineRacingView();
                }
            } else {
                Log.e((String)TAG, (String)"Failed to initialize async reprojection, unsupported device.");
                this.isAsyncReprojectionVideoEnabled = false;
                this.scanlineRacingRenderer = null;
            }
        }
        return bl2;
    }

    public boolean enableCardboardTriggerEmulation(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("The Cardboard trigger listener must not be null.");
        }
        if (this.cardboardEmulator != null) {
            return true;
        }
        if (!this.daydreamUtils.isDaydreamPhone(this.getContext())) {
            return false;
        }
        this.cardboardEmulator = new CardboardEmulator(this.getContext(), runnable);
        return true;
    }

    private void addScanlineRacingView() {
        if (this.scanlineRacingView != null) {
            return;
        }
        this.eglFactory = new EglFactory();
        this.eglFactory.setUsePriorityContext(true);
        this.eglFactory.setUseProtectedBuffers(this.isAsyncReprojectionUsingProtectedBuffers);
        this.eglFactory.setEGLContextClientVersion(2);
        this.scanlineRacingView = new GvrSurfaceView(this.getContext());
        this.scanlineRacingView.setEGLContextClientVersion(2);
        this.scanlineRacingView.setEGLConfigChooser(new MutableEglConfigChooser());
        this.scanlineRacingView.setZOrderMediaOverlay(true);
        this.scanlineRacingView.setEGLContextFactory(this.eglFactory);
        this.scanlineRacingView.setEGLWindowSurfaceFactory(this.eglFactory);
        if (!this.stereoModeEnabled) {
            Log.w((String)TAG, (String)"Disabling stereo mode with async reprojection enabled may not work properly.");
            this.scanlineRacingView.setVisibility(8);
        }
        if (this.scanlineRacingRenderer == null) {
            this.scanlineRacingRenderer = new ScanlineRacingRenderer(this.gvrApi);
        }
        this.scanlineRacingRenderer.setSurfaceView(this.scanlineRacingView);
        this.scanlineRacingView.setRenderer(this.scanlineRacingRenderer);
        this.scanlineRacingView.setSwapMode(1);
        this.presentationLayout.addView((View)this.scanlineRacingView, 0);
    }

    public int getAsyncReprojectionVideoSurfaceId() {
        if (!this.isAsyncReprojectionVideoEnabled) {
            Log.w((String)TAG, (String)"Async reprojection video is not enabled. Did you call enableAsyncReprojectionVideoSurface()?");
        }
        return this.videoSurfaceId;
    }

    public Surface getAsyncReprojectionVideoSurface() {
        if (!this.isAsyncReprojectionVideoEnabled) {
            Log.w((String)TAG, (String)"Async reprojection video is not enabled. Did you call enableAsyncReprojectionVideoSurface()?");
            return null;
        }
        if (this.scanlineRacingView == null) {
            Log.w((String)TAG, (String)"No async reprojection view has been set. Cannot get async reprojection managed Surfaces. Have you called setAsyncReprojectionEnabled()?");
        }
        return this.scanlineRacingRenderer.getExternalSurfaceManager().getSurface(this.videoSurfaceId);
    }

    public GvrApi getGvrApi() {
        return this.gvrApi;
    }

    public void addPresentationListener(PresentationListener presentationListener) {
        if (this.presentationHelper != null) {
            this.presentationHelper.addListener(presentationListener);
        }
    }

    protected VrCoreSdkClient createVrCoreSdkClient(Context context, GvrApi gvrApi, DaydreamUtilsWrapper daydreamUtilsWrapper, FadeOverlayView fadeOverlayView) {
        ComponentName componentName = ContextUtils.getActivity(context).getComponentName();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GvrLayout.this.uiLayout.invokeCloseButtonListener();
            }
        };
        return new VrCoreSdkClient(context, gvrApi, componentName, daydreamUtilsWrapper, runnable, fadeOverlayView);
    }

    public void launchInVr(PendingIntent pendingIntent) {
        if (this.vrCoreSdkClient == null || !this.vrCoreSdkClient.launchInVr(pendingIntent)) {
            try {
                pendingIntent.send();
                return;
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Error launching PendingIntent.", (Throwable)exception);
            }
        }
    }

    public void setStereoModeEnabled(boolean bl) {
        if (this.stereoModeEnabled == bl) {
            return;
        }
        this.stereoModeEnabled = bl;
        this.uiLayout.setEnabled(bl);
        if (this.vrCoreSdkClient != null) {
            this.vrCoreSdkClient.setEnabled(bl);
        }
        if (this.fadeOverlayView != null) {
            this.fadeOverlayView.setEnabled(bl);
        }
        if (this.daydreamAlignment != null) {
            this.daydreamAlignment.setEnabled(bl);
        }
        this.updateRenderingViewsVisibility(0);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.presentationView != null && this.isPresenting() && this.presentationView.dispatchTouchEvent(motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public boolean isPresenting() {
        return this.presentationView != null && this.presentationHelper != null && this.presentationHelper.isPresenting();
    }

    static void setPresentationFactory(PresentationFactory presentationFactory) {
        sOptionalPresentationFactory = presentationFactory;
    }

    VrCoreSdkClient getVrCoreSdkClient() {
        return this.vrCoreSdkClient;
    }

    FadeOverlayView getFadeOverlayView() {
        return this.fadeOverlayView;
    }

    DaydreamAlignment createDaydreamAlignment() {
        return new DaydreamAlignment(this.getContext(), this.gvrApi);
    }

    private PresentationHelper tryCreatePresentationHelper() {
        if (Build.VERSION.SDK_INT <= 16) {
            return null;
        }
        String string2 = DisplayUtils.getExternalDisplayName(this.getContext());
        if (string2 == null) {
            Log.e((String)TAG, (String)"HDMI display name could not be found, disabling external presentation support");
            return null;
        }
        return new PresentationHelper(this.getContext(), this, (View)this.presentationLayout, this.displaySynchronizer, string2);
    }

    private void updateRenderingViewsVisibility(int n) {
        if (this.presentationView != null) {
            this.presentationView.setVisibility(this.stereoModeEnabled ? n : 0);
        }
        if (this.scanlineRacingView != null) {
            this.scanlineRacingView.setVisibility(this.stereoModeEnabled ? n : 8);
        }
    }

    private void updateFadeVisibility() {
        boolean bl;
        boolean bl2 = bl = this.getWindowVisibility() == 0;
        if (this.fadeOverlayView != null) {
            if (bl && this.isResumed) {
                this.fadeOverlayView.onVisible();
                this.removeCallbacks(this.showRenderingViewsRunnable);
                this.postDelayed(this.showRenderingViewsRunnable, 50L);
                return;
            }
            if (!bl && !this.isResumed) {
                this.fadeOverlayView.onInvisible();
                this.updateRenderingViewsVisibility(4);
                this.removeCallbacks(this.showRenderingViewsRunnable);
            }
        }
    }

    private void updateUiLayout() {
        boolean bl = this.gvrApi.getViewerType() == 1;
        this.uiLayout.setDaydreamModeEnabled(bl);
    }

    private static class PresentationHelper
    implements DisplayManager.DisplayListener {
        private final RelativeLayout.LayoutParams layout = new RelativeLayout.LayoutParams(-1, -1);
        private final Context context;
        private final DisplayManager displayManager;
        private final DisplaySynchronizer displaySynchronizer;
        private final FrameLayout originalParent;
        private final View view;
        private final List<PresentationListener> listeners;
        private String externalDisplayName;
        private Presentation presentation;

        PresentationHelper(Context context, FrameLayout frameLayout, View view, DisplaySynchronizer displaySynchronizer, String string2) {
            this.context = context;
            this.originalParent = frameLayout;
            this.view = view;
            this.displaySynchronizer = displaySynchronizer;
            this.externalDisplayName = string2;
            this.displayManager = (DisplayManager)context.getSystemService("display");
            this.listeners = new ArrayList<PresentationListener>();
        }

        public boolean isPresenting() {
            return this.presentation != null && this.presentation.isShowing();
        }

        public void onPause() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
        }

        public void onResume() {
            this.externalDisplayName = DisplayUtils.getExternalDisplayName(this.context);
            if (this.externalDisplayName == null) {
                this.setDisplay(null);
                return;
            }
            this.displayManager.registerDisplayListener((DisplayManager.DisplayListener)this, null);
            Display display = null;
            for (Display display2 : this.displayManager.getDisplays()) {
                if (!this.isValidExternalDisplay(display2)) continue;
                display = display2;
                break;
            }
            this.setDisplay(display);
        }

        public void shutdown() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
            if (this.presentation != null) {
                this.presentation.cancel();
                this.presentation = null;
                for (PresentationListener presentationListener : this.listeners) {
                    presentationListener.onPresentationStopped();
                }
            }
        }

        public void onDetachedFromWindow() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
            this.setDisplay(null);
        }

        public void addListener(PresentationListener presentationListener) {
            if (this.listeners.contains(presentationListener)) {
                return;
            }
            this.listeners.add(presentationListener);
            if (this.presentation != null) {
                presentationListener.onPresentationStarted(this.presentation.getDisplay());
            }
        }

        public void onDisplayAdded(int n) {
            Display display = this.displayManager.getDisplay(n);
            if (this.isValidExternalDisplay(display)) {
                this.setDisplay(display);
            }
        }

        public void onDisplayRemoved(int n) {
            if (this.presentation != null && this.presentation.getDisplay().getDisplayId() == n) {
                this.setDisplay(null);
            }
        }

        public void onDisplayChanged(int n) {
        }

        private void setDisplay(Display display) {
            Presentation presentation;
            block9: {
                Display display2;
                Display display3 = display2 = this.presentation != null ? this.presentation.getDisplay() : null;
                if (!this.hasCurrentPresentationExpired() && DisplayUtils.isSameDisplay(display, display2)) {
                    return;
                }
                presentation = this.presentation;
                if (this.presentation != null) {
                    this.presentation.dismiss();
                    this.presentation = null;
                }
                PresentationHelper.detachViewFromParent(this.view);
                if (display != null) {
                    this.presentation = sOptionalPresentationFactory != null ? sOptionalPresentationFactory.create(this.context, display) : new Presentation(this.context, display);
                    this.presentation.addContentView(this.view, (ViewGroup.LayoutParams)this.layout);
                    try {
                        this.presentation.show();
                        break block9;
                    }
                    catch (WindowManager.InvalidDisplayException invalidDisplayException) {
                        String object = String.valueOf((Object)invalidDisplayException);
                        Log.e((String)GvrLayout.TAG, (String)new StringBuilder(57 + String.valueOf(object).length()).append("Attaching Cardboard View to the external display failed: ").append(object).toString());
                        this.presentation.cancel();
                        this.presentation = null;
                        PresentationHelper.detachViewFromParent(this.view);
                    }
                }
                this.originalParent.addView(this.view, 0);
            }
            this.displaySynchronizer.setDisplay(this.presentation != null ? this.presentation.getDisplay() : DisplayUtils.getDefaultDisplay(this.context));
            if (presentation != null) {
                for (PresentationListener presentationListener : this.listeners) {
                    presentationListener.onPresentationStopped();
                }
            }
            if (this.presentation != null) {
                for (PresentationListener presentationListener : this.listeners) {
                    presentationListener.onPresentationStarted(this.presentation.getDisplay());
                }
            }
        }

        private static void detachViewFromParent(View view) {
            ViewGroup viewGroup = (ViewGroup)view.getParent();
            if (viewGroup != null) {
                viewGroup.removeView(view);
            }
        }

        private boolean isValidExternalDisplay(Display display) {
            return display.isValid() && display.getName().equals(this.externalDisplayName);
        }

        private boolean hasCurrentPresentationExpired() {
            if (this.presentation == null) {
                return false;
            }
            return !this.presentation.isShowing() || !this.presentation.getDisplay().isValid();
        }
    }

    static interface PresentationFactory {
        public Presentation create(Context var1, Display var2);
    }

    public static interface PresentationListener {
        public void onPresentationStarted(Display var1);

        public void onPresentationStopped();
    }

    public static interface ExternalSurfaceManager {
        public int createExternalSurface();

        public int createExternalSurface(ExternalSurfaceListener var1, Handler var2);

        public void releaseExternalSurface(int var1);

        public Surface getSurface(int var1);

        public int getSurfaceCount();
    }

    public static interface ExternalSurfaceListener {
        public void onSurfaceAvailable(Surface var1);

        public void onFrameAvailable();
    }
}

