/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import android.os.AsyncTask;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import com.google.vr.cardboard.DisplayUtils;
import com.google.vr.cardboard.VrParamsProvider;
import com.google.vr.cardboard.VrParamsProviderFactory;
import com.google.vr.ndk.base.GvrApi;
import com.google.vrtoolkit.cardboard.proto.nano.CardboardDevice;
import com.google.vrtoolkit.cardboard.proto.nano.Phone;

class DaydreamAlignment {
    private static final String TAG = "DaydreamAlignment";
    private static final double MAX_TOUCH_DISTANCE_SQUARED_METERS = 2.25E-4;
    private final VrParamsProvider vrParamsProvider;
    private DisplayMetrics displayMetrics;
    private float xMetersPerPixel;
    private float yMetersPerPixel;
    private float borderSizeMeters;
    private float[][] markersInPixels;
    private int mostTouchesSeen;
    private int[] touchBestMarker;
    private int[] markerBestTouch;
    private double[] currentMarkerBestDists;
    private float[] pixelTranslation = new float[2];
    private boolean lastMotionEventInHeadset;
    private boolean enabled = true;
    private final boolean isDaydreamImageAlignmentEnabled;

    public DaydreamAlignment(Context context, GvrApi gvrApi) {
        this.isDaydreamImageAlignmentEnabled = gvrApi.getSdkConfigurationParams().daydreamImageAlignment != 1;
        this.vrParamsProvider = VrParamsProviderFactory.create(context);
        FinishInitilizationTask finishInitilizationTask = new FinishInitilizationTask();
        new FinishInitilizationTask().display = DisplayUtils.getDefaultDisplay(context);
        finishInitilizationTask.execute(new Void[0]);
    }

    DaydreamAlignment(VrParamsProvider vrParamsProvider, DisplayMetrics displayMetrics, Phone.PhoneParams phoneParams, boolean bl) {
        this.isDaydreamImageAlignmentEnabled = bl;
        this.vrParamsProvider = vrParamsProvider;
        this.init(displayMetrics, phoneParams);
    }

    private void init(DisplayMetrics displayMetrics, Phone.PhoneParams phoneParams) {
        this.displayMetrics = displayMetrics;
        this.borderSizeMeters = DisplayUtils.getBorderSizeMeters(phoneParams);
        this.xMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(this.displayMetrics.xdpi);
        this.yMetersPerPixel = DisplayUtils.getMetersPerPixelFromDotsPerInch(this.displayMetrics.ydpi);
        this.resetTrackingState();
        this.refreshViewerProfile();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.resetTrackingState();
        }
    }

    public boolean processMotionEvent(MotionEvent motionEvent) {
        int n;
        int n2;
        if (!this.viewerNeedsTouchProcessing()) {
            this.lastMotionEventInHeadset = false;
            return false;
        }
        if (!this.isDaydreamImageAlignmentEnabled()) {
            return true;
        }
        int n3 = motionEvent.getPointerCount();
        if (n3 > this.mostTouchesSeen) {
            this.touchBestMarker = new int[n3];
            this.mostTouchesSeen = n3;
        }
        for (n2 = 0; n2 < this.markersInPixels.length; ++n2) {
            this.markerBestTouch[n2] = -1;
            this.currentMarkerBestDists[n2] = 2.25E-4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            double d = 2.25E-4;
            this.touchBestMarker[n2] = -1;
            for (n = 0; n < this.markersInPixels.length; ++n) {
                double d2;
                float f = (this.markersInPixels[n][0] - motionEvent.getX(n2)) * this.xMetersPerPixel;
                float f2 = (this.markersInPixels[n][1] - motionEvent.getY(n2)) * this.yMetersPerPixel;
                double d3 = f * f + f2 * f2;
                if (d2 < d) {
                    d = d3;
                    this.touchBestMarker[n2] = n;
                }
                if (!(d3 < this.currentMarkerBestDists[n])) continue;
                this.currentMarkerBestDists[n] = d3;
                this.markerBestTouch[n] = n2;
            }
        }
        float f = 0.0f;
        float f3 = 0.0f;
        int n4 = 0;
        for (n = 0; n < this.markerBestTouch.length; ++n) {
            if (this.markerBestTouch[n] == -1) continue;
            if (this.touchBestMarker[this.markerBestTouch[n]] != n) {
                this.markerBestTouch[n] = -1;
                continue;
            }
            ++n4;
            f += motionEvent.getX(this.markerBestTouch[n]) - this.markersInPixels[n][0];
            f3 += motionEvent.getY(this.markerBestTouch[n]) - this.markersInPixels[n][1];
        }
        if (n4 > 0) {
            this.lastMotionEventInHeadset = true;
            this.pixelTranslation[0] = f / (float)n4;
            this.pixelTranslation[1] = f3 / (float)n4;
        } else {
            this.lastMotionEventInHeadset = false;
        }
        return true;
    }

    void getTranslationInPixels(float[] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("Translation array too small");
        }
        fArray[0] = this.pixelTranslation[0];
        fArray[1] = this.pixelTranslation[1];
    }

    public void getTranslationInScreenSpace(float[] fArray) {
        if (fArray.length < 2) {
            throw new IllegalArgumentException("Translation array too small");
        }
        fArray[0] = this.pixelTranslation[0] / (float)this.displayMetrics.widthPixels;
        fArray[1] = this.pixelTranslation[1] / (float)this.displayMetrics.heightPixels;
        fArray[0] = fArray[0] * 4.0f;
        fArray[1] = fArray[1] * -2.0f;
    }

    boolean viewerNeedsTouchProcessing() {
        return this.enabled && this.markersInPixels != null && this.markersInPixels.length > 0;
    }

    boolean isDaydreamImageAlignmentEnabled() {
        return this.isDaydreamImageAlignmentEnabled;
    }

    public boolean wasLastMotionEventInViewer() {
        return this.lastMotionEventInHeadset;
    }

    public void refreshViewerProfile() {
        new RefreshViewerProfileTask().execute(new Void[0]);
    }

    public void shutdown() {
        this.vrParamsProvider.close();
    }

    private void resetTrackingState() {
        this.lastMotionEventInHeadset = false;
        this.pixelTranslation[0] = 0.0f;
        this.pixelTranslation[1] = 0.0f;
        this.mostTouchesSeen = 0;
    }

    static /* synthetic */ float[][] access$302(DaydreamAlignment daydreamAlignment, float[][] fArray) {
        daydreamAlignment.markersInPixels = fArray;
        return fArray;
    }

    static /* synthetic */ double[] access$402(DaydreamAlignment daydreamAlignment, double[] dArray) {
        daydreamAlignment.currentMarkerBestDists = dArray;
        return dArray;
    }

    static /* synthetic */ int[] access$502(DaydreamAlignment daydreamAlignment, int[] nArray) {
        daydreamAlignment.markerBestTouch = nArray;
        return nArray;
    }

    private class FinishInitilizationTask
    extends AsyncTask<Void, Void, Phone.PhoneParams> {
        public Display display;

        private FinishInitilizationTask() {
        }

        protected Phone.PhoneParams doInBackground(Void ... voidArray) {
            return DaydreamAlignment.this.vrParamsProvider.readPhoneParams();
        }

        protected void onProgressUpdate(Void ... voidArray) {
        }

        protected void onPostExecute(Phone.PhoneParams phoneParams) {
            DisplayMetrics displayMetrics = DisplayUtils.getDisplayMetricsLandscapeWithOverride(this.display, phoneParams);
            DaydreamAlignment.this.init(displayMetrics, phoneParams);
        }
    }

    private class RefreshViewerProfileTask
    extends AsyncTask<Void, Void, CardboardDevice.DeviceParams> {
        private RefreshViewerProfileTask() {
        }

        protected CardboardDevice.DeviceParams doInBackground(Void ... voidArray) {
            return DaydreamAlignment.this.vrParamsProvider.readDeviceParams();
        }

        protected void onProgressUpdate(Void ... voidArray) {
        }

        protected void onPostExecute(CardboardDevice.DeviceParams deviceParams) {
            if (deviceParams == null || deviceParams.daydreamInternal == null || deviceParams.daydreamInternal.alignmentMarkers == null) {
                DaydreamAlignment.access$302(DaydreamAlignment.this, null);
                return;
            }
            CardboardDevice.ScreenAlignmentMarker[] screenAlignmentMarkerArray = deviceParams.daydreamInternal.alignmentMarkers;
            DaydreamAlignment.access$302(DaydreamAlignment.this, new float[screenAlignmentMarkerArray.length][]);
            DaydreamAlignment.access$402(DaydreamAlignment.this, new double[screenAlignmentMarkerArray.length]);
            DaydreamAlignment.access$502(DaydreamAlignment.this, new int[screenAlignmentMarkerArray.length]);
            for (int i = 0; i < screenAlignmentMarkerArray.length; ++i) {
                CardboardDevice.ScreenAlignmentMarker screenAlignmentMarker = screenAlignmentMarkerArray[i];
                ((DaydreamAlignment)DaydreamAlignment.this).markersInPixels[i] = new float[2];
                ((DaydreamAlignment)DaydreamAlignment.this).markersInPixels[i][0] = (float)(((DaydreamAlignment)DaydreamAlignment.this).displayMetrics.widthPixels / 2) + screenAlignmentMarker.getHorizontal() / DaydreamAlignment.this.xMetersPerPixel;
                ((DaydreamAlignment)DaydreamAlignment.this).markersInPixels[i][1] = (float)((DaydreamAlignment)DaydreamAlignment.this).displayMetrics.heightPixels - (screenAlignmentMarker.getVertical() + deviceParams.getTrayToLensDistance() - DaydreamAlignment.this.borderSizeMeters) / DaydreamAlignment.this.yMetersPerPixel;
            }
        }
    }

    public static class DefaultTouchListener
    implements View.OnTouchListener {
        private float[] lastTranslation = new float[2];
        private float[] translation = new float[2];
        private final DaydreamAlignment daydreamAlignment;
        private final GvrApi gvrApi;

        public DefaultTouchListener(DaydreamAlignment daydreamAlignment, GvrApi gvrApi) {
            this.daydreamAlignment = daydreamAlignment;
            this.gvrApi = gvrApi;
        }

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (!this.daydreamAlignment.processMotionEvent(motionEvent)) {
                return false;
            }
            if (!this.daydreamAlignment.wasLastMotionEventInViewer()) {
                this.translation[0] = 0.0f;
                this.translation[1] = 0.0f;
            } else {
                this.daydreamAlignment.getTranslationInScreenSpace(this.translation);
            }
            if (this.translation[0] != this.lastTranslation[0] || this.translation[1] != this.lastTranslation[1]) {
                this.lastTranslation[0] = this.translation[0];
                this.lastTranslation[1] = this.translation[1];
                this.gvrApi.setLensOffset(this.translation[0], this.translation[1]);
            }
            return true;
        }
    }
}

