/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.cardboard;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import com.google.vr.vrcore.base.api.VrCoreNotAvailableException;
import com.google.vr.vrcore.performance.api.IPerformanceService;

public class PerfMonitor
implements AutoCloseable {
    private static final int STATUS_DISCONNECTED = 0;
    private static final int STATUS_CONNECTING = 1;
    private static final int STATUS_CONNECTED = 2;
    private final Object lock = new Object();
    private final Context context;
    private IPerformanceService perfService;
    private int status = 1;
    private final ServiceConnection connection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Object object = PerfMonitor.this.lock;
            synchronized (object) {
                PerfMonitor.this.perfService = IPerformanceService.Stub.asInterface(iBinder);
                PerfMonitor.this.status = 2;
                PerfMonitor.this.lock.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName componentName) {
            Object object = PerfMonitor.this.lock;
            synchronized (object) {
                PerfMonitor.this.perfService = null;
                PerfMonitor.this.status = 0;
                PerfMonitor.this.lock.notifyAll();
                return;
            }
        }
    };

    protected PerfMonitor(Context context) {
        this.context = context;
    }

    public static PerfMonitor build(Context context) {
        Intent intent = new Intent("com.google.vr.vrcore.performance.BIND");
        intent.setPackage("com.google.vr.vrcore");
        PerfMonitor perfMonitor = new PerfMonitor(context);
        if (!context.bindService(intent, perfMonitor.connection, 1)) {
            return null;
        }
        return perfMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilReady(long l) throws IllegalStateException, InterruptedException {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            throw new IllegalStateException("waitUntilReady cannot be called from the UI thread");
        }
        Object object = this.lock;
        synchronized (object) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 + l;
            while (this.status == 1 && l2 < l3) {
                this.lock.wait(l3 - l2);
                l2 = System.currentTimeMillis();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            return this.status == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float queryRelativeTemperature() throws VrCoreNotAvailableException {
        IPerformanceService iPerformanceService;
        Object object = this.lock;
        synchronized (object) {
            iPerformanceService = this.perfService;
        }
        if (iPerformanceService == null) {
            throw new VrCoreNotAvailableException(5);
        }
        try {
            return iPerformanceService.getCurrentThrottlingRelativeTemperature();
        }
        catch (RemoteException remoteException) {
            throw new VrCoreNotAvailableException(8);
        }
        catch (SecurityException securityException) {
            throw new VrCoreNotAvailableException(6);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new VrCoreNotAvailableException(7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportFrameDrops(long l, long l2, int n) throws VrCoreNotAvailableException {
        IPerformanceService iPerformanceService;
        Object object = this.lock;
        synchronized (object) {
            iPerformanceService = this.perfService;
        }
        if (iPerformanceService == null) {
            throw new VrCoreNotAvailableException(5);
        }
        try {
            iPerformanceService.reportFrameDrops(l, l2, n);
            return;
        }
        catch (RemoteException remoteException) {
            throw new VrCoreNotAvailableException(8);
        }
    }

    @Override
    public void close() {
        this.context.unbindService(this.connection);
    }
}

