/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.vrcore.controller.api;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.vr.vrcore.controller.api.ControllerAccelEvent;
import com.google.vr.vrcore.controller.api.ControllerButtonEvent;
import com.google.vr.vrcore.controller.api.ControllerGyroEvent;
import com.google.vr.vrcore.controller.api.ControllerOrientationEvent;
import com.google.vr.vrcore.controller.api.ControllerTouchEvent;
import java.util.ArrayDeque;

public final class ControllerEventPacket
implements Parcelable {
    private static final int SERIALIZED_FORMAT_VERSION = 1;
    private static final int MAX_EVENTS = 16;
    private static ArrayDeque<ControllerEventPacket> pool = new ArrayDeque();
    private static Object poolLock = new Object();
    private int accelEventCount;
    private ControllerAccelEvent[] accelEvents = new ControllerAccelEvent[16];
    private int buttonEventCount;
    private ControllerButtonEvent[] buttonEvents = new ControllerButtonEvent[16];
    private int gyroEventCount;
    private ControllerGyroEvent[] gyroEvents = new ControllerGyroEvent[16];
    private int orientationEventCount;
    private ControllerOrientationEvent[] orientationEvents = new ControllerOrientationEvent[16];
    private int touchEventCount;
    private ControllerTouchEvent[] touchEvents = new ControllerTouchEvent[16];
    public static final Parcelable.Creator<ControllerEventPacket> CREATOR = new Parcelable.Creator<ControllerEventPacket>(){

        public final ControllerEventPacket createFromParcel(Parcel parcel) {
            ControllerEventPacket controllerEventPacket = ControllerEventPacket.obtain();
            controllerEventPacket.readFromParcel(parcel);
            return controllerEventPacket;
        }

        public final ControllerEventPacket[] newArray(int n) {
            return new ControllerEventPacket[n];
        }
    };

    public ControllerEventPacket() {
        for (int i = 0; i < 16; ++i) {
            this.accelEvents[i] = new ControllerAccelEvent();
            this.buttonEvents[i] = new ControllerButtonEvent();
            this.gyroEvents[i] = new ControllerGyroEvent();
            this.orientationEvents[i] = new ControllerOrientationEvent();
            this.touchEvents[i] = new ControllerTouchEvent();
        }
        this.clear();
    }

    protected ControllerEventPacket(Parcel parcel) {
        this();
        this.readFromParcel(parcel);
    }

    public final void clear() {
        this.accelEventCount = 0;
        this.buttonEventCount = 0;
        this.gyroEventCount = 0;
        this.orientationEventCount = 0;
        this.touchEventCount = 0;
    }

    public final int getAccelEventCount() {
        return this.accelEventCount;
    }

    public final int getButtonEventCount() {
        return this.buttonEventCount;
    }

    public final int getGyroEventCount() {
        return this.gyroEventCount;
    }

    public final int getOrientationEventCount() {
        return this.orientationEventCount;
    }

    public final int getTouchEventCount() {
        return this.touchEventCount;
    }

    public final ControllerAccelEvent getAccelEvent(int n) {
        if (n < 0 || n >= this.accelEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.accelEvents[n];
    }

    public final ControllerButtonEvent getButtonEvent(int n) {
        if (n < 0 || n >= this.buttonEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.buttonEvents[n];
    }

    public final ControllerGyroEvent getGyroEvent(int n) {
        if (n < 0 || n >= this.gyroEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.gyroEvents[n];
    }

    public final ControllerOrientationEvent getOrientationEvent(int n) {
        if (n < 0 || n >= this.orientationEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.orientationEvents[n];
    }

    public final ControllerTouchEvent getTouchEvent(int n) {
        if (n < 0 || n >= this.touchEventCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.touchEvents[n];
    }

    public final ControllerAccelEvent addAccelEvent() {
        if (this.accelEventCount >= 16) {
            throw new IllegalStateException("ControllerEventPacket capacity exceeded.");
        }
        return this.accelEvents[this.accelEventCount++];
    }

    public final ControllerButtonEvent addButtonEvent() {
        if (this.buttonEventCount >= 16) {
            throw new IllegalStateException("ControllerEventPacket capacity exceeded.");
        }
        return this.buttonEvents[this.buttonEventCount++];
    }

    public final ControllerGyroEvent addGyroEvent() {
        if (this.gyroEventCount >= 16) {
            throw new IllegalStateException("ControllerEventPacket capacity exceeded.");
        }
        return this.gyroEvents[this.gyroEventCount++];
    }

    public final ControllerOrientationEvent addOrientationEvent() {
        if (this.orientationEventCount >= 16) {
            throw new IllegalStateException("ControllerEventPacket capacity exceeded.");
        }
        return this.orientationEvents[this.orientationEventCount++];
    }

    public final ControllerTouchEvent addTouchEvent() {
        if (this.touchEventCount >= 16) {
            throw new IllegalStateException("ControllerEventPacket capacity exceeded.");
        }
        return this.touchEvents[this.touchEventCount++];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerEventPacket obtain() {
        Object object = poolLock;
        synchronized (object) {
            return pool.isEmpty() ? new ControllerEventPacket() : pool.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recycle() {
        this.clear();
        Object object = poolLock;
        synchronized (object) {
            if (!pool.contains(this)) {
                pool.add(this);
            }
            return;
        }
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        int n2;
        parcel.writeInt(1);
        parcel.writeInt(this.accelEventCount);
        for (n2 = 0; n2 < this.accelEventCount; ++n2) {
            this.accelEvents[n2].writeToParcel(parcel, n);
        }
        parcel.writeInt(this.buttonEventCount);
        for (n2 = 0; n2 < this.buttonEventCount; ++n2) {
            this.buttonEvents[n2].writeToParcel(parcel, n);
        }
        parcel.writeInt(this.gyroEventCount);
        for (n2 = 0; n2 < this.gyroEventCount; ++n2) {
            this.gyroEvents[n2].writeToParcel(parcel, n);
        }
        parcel.writeInt(this.orientationEventCount);
        for (n2 = 0; n2 < this.orientationEventCount; ++n2) {
            this.orientationEvents[n2].writeToParcel(parcel, n);
        }
        parcel.writeInt(this.touchEventCount);
        for (n2 = 0; n2 < this.touchEventCount; ++n2) {
            this.touchEvents[n2].writeToParcel(parcel, n);
        }
    }

    public final void readFromParcel(Parcel parcel) {
        int n;
        parcel.readInt();
        this.accelEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.accelEventCount);
        for (n = 0; n < this.accelEventCount; ++n) {
            this.accelEvents[n].readFromParcel(parcel);
        }
        this.buttonEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.buttonEventCount);
        for (n = 0; n < this.buttonEventCount; ++n) {
            this.buttonEvents[n].readFromParcel(parcel);
        }
        this.gyroEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.gyroEventCount);
        for (n = 0; n < this.gyroEventCount; ++n) {
            this.gyroEvents[n].readFromParcel(parcel);
        }
        this.orientationEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.orientationEventCount);
        for (n = 0; n < this.orientationEventCount; ++n) {
            this.orientationEvents[n].readFromParcel(parcel);
        }
        this.touchEventCount = parcel.readInt();
        this.checkIsValidEventCount(this.touchEventCount);
        for (n = 0; n < this.touchEventCount; ++n) {
            this.touchEvents[n].readFromParcel(parcel);
        }
    }

    private final void checkIsValidEventCount(int n) {
        if (n < 0 || n >= 16) {
            throw new IllegalArgumentException(new StringBuilder(32).append("Invalid event count: ").append(n).toString());
        }
    }
}

