/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.ndk.base;

import android.content.Context;
import android.view.View;
import android.view.animation.AnimationUtils;

class FadeOverlayView
extends View {
    private static final String TAG = "FadeOverlayView";
    private static final boolean DEBUG = false;
    private static final int BACKGROUND_COLOR = -16777216;
    static final long AUTO_FADE_DURATION_MILLIS = 350L;
    static final long AUTO_FADE_START_DELAY_MILLIS = 1000L;
    private int fadeType = 0;
    private long fadeStartTimeMillis;
    private long fadeDurationMillis;
    private boolean resumed;
    private final Runnable fadeUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            FadeOverlayView.this.updateFade();
        }
    };
    private final Runnable startAutoFadeRunnable = new Runnable(){

        @Override
        public void run() {
            FadeOverlayView.this.startFade(1, 350L);
        }
    };

    public FadeOverlayView(Context context) {
        super(context);
        this.setBackgroundColor(-16777216);
    }

    public void startFade(int n, long l) {
        this.fadeType = n;
        this.fadeDurationMillis = l;
        this.fadeStartTimeMillis = AnimationUtils.currentAnimationTimeMillis();
        this.updateFade();
    }

    public void onPause() {
        this.removeCallbacks(this.startAutoFadeRunnable);
        this.fadeType = 2;
        this.endFade();
        this.resumed = false;
    }

    public void onResume() {
        this.resumed = true;
        this.postDelayed(this.startAutoFadeRunnable, 1000L);
    }

    int getFadeType() {
        return this.fadeType;
    }

    boolean isResumed() {
        return this.resumed;
    }

    private void endFade() {
        if (this.fadeType == 0) {
            return;
        }
        this.setVisibility(this.fadeType == 2 ? 0 : 8);
        this.setAlpha(this.fadeType == 2 ? 1.0f : 0.0f);
        this.removeCallbacks(this.fadeUpdateRunnable);
        this.fadeType = 0;
    }

    private void updateFade() {
        long l = AnimationUtils.currentAnimationTimeMillis() - this.fadeStartTimeMillis;
        float f = (float)l / (float)this.fadeDurationMillis;
        float f2 = this.fadeType == 2 ? f : 1.0f - f;
        this.setAlpha(Math.min(Math.max(f2, 0.0f), 1.0f));
        if (l < this.fadeDurationMillis && this.getVisibility() != 0) {
            this.setVisibility(0);
        }
        if (l < this.fadeDurationMillis) {
            this.postOnAnimation(this.fadeUpdateRunnable);
            return;
        }
        this.endFade();
    }
}

